/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the configuration for a Amazon SageMaker endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SageMakerEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<SageMakerEndpoint.Builder, SageMakerEndpoint> {
    private static final SdkField<Integer> INITIAL_INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("initialInstanceCount").getter(getter(SageMakerEndpoint::initialInstanceCount))
            .setter(setter(Builder::initialInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialInstanceCount").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(SageMakerEndpoint::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRole").getter(getter(SageMakerEndpoint::executionRole)).setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()).build();

    private static final SdkField<String> KMS_ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsEncryptionKey").getter(getter(SageMakerEndpoint::kmsEncryptionKey))
            .setter(setter(Builder::kmsEncryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsEncryptionKey").build()).build();

    private static final SdkField<VpcConfig> VPC_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO).memberName("vpc")
            .getter(getter(SageMakerEndpoint::vpc)).setter(setter(Builder::vpc)).constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpc").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_INSTANCE_COUNT_FIELD,
            INSTANCE_TYPE_FIELD, EXECUTION_ROLE_FIELD, KMS_ENCRYPTION_KEY_FIELD, VPC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer initialInstanceCount;

    private final String instanceType;

    private final String executionRole;

    private final String kmsEncryptionKey;

    private final VpcConfig vpc;

    private SageMakerEndpoint(BuilderImpl builder) {
        this.initialInstanceCount = builder.initialInstanceCount;
        this.instanceType = builder.instanceType;
        this.executionRole = builder.executionRole;
        this.kmsEncryptionKey = builder.kmsEncryptionKey;
        this.vpc = builder.vpc;
    }

    /**
     * <p>
     * The number of Amazon EC2 compute instances to deploy for initial endpoint creation.
     * </p>
     * 
     * @return The number of Amazon EC2 compute instances to deploy for initial endpoint creation.
     */
    public final Integer initialInstanceCount() {
        return initialInstanceCount;
    }

    /**
     * <p>
     * The Amazon EC2 compute instance type to deploy for hosting the model.
     * </p>
     * 
     * @return The Amazon EC2 compute instance type to deploy for hosting the model.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and docker image for
     * deployment on Amazon EC2 compute instances or for batch transform jobs.
     * </p>
     * 
     * @return The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and docker image for
     *         deployment on Amazon EC2 compute instances or for batch transform jobs.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to the
     * Amazon EC2 compute instance that hosts the endpoint.
     * </p>
     * 
     * @return The Amazon Web Services KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached
     *         to the Amazon EC2 compute instance that hosts the endpoint.
     */
    public final String kmsEncryptionKey() {
        return kmsEncryptionKey;
    }

    /**
     * <p>
     * The VPC configuration for the endpoint.
     * </p>
     * 
     * @return The VPC configuration for the endpoint.
     */
    public final VpcConfig vpc() {
        return vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initialInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(kmsEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(vpc());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SageMakerEndpoint)) {
            return false;
        }
        SageMakerEndpoint other = (SageMakerEndpoint) obj;
        return Objects.equals(initialInstanceCount(), other.initialInstanceCount())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(kmsEncryptionKey(), other.kmsEncryptionKey()) && Objects.equals(vpc(), other.vpc());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SageMakerEndpoint").add("InitialInstanceCount", initialInstanceCount())
                .add("InstanceType", instanceType()).add("ExecutionRole", executionRole())
                .add("KmsEncryptionKey", kmsEncryptionKey()).add("Vpc", vpc()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "initialInstanceCount":
            return Optional.ofNullable(clazz.cast(initialInstanceCount()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "executionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "kmsEncryptionKey":
            return Optional.ofNullable(clazz.cast(kmsEncryptionKey()));
        case "vpc":
            return Optional.ofNullable(clazz.cast(vpc()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("initialInstanceCount", INITIAL_INSTANCE_COUNT_FIELD);
        map.put("instanceType", INSTANCE_TYPE_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("kmsEncryptionKey", KMS_ENCRYPTION_KEY_FIELD);
        map.put("vpc", VPC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SageMakerEndpoint, T> g) {
        return obj -> g.apply((SageMakerEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SageMakerEndpoint> {
        /**
         * <p>
         * The number of Amazon EC2 compute instances to deploy for initial endpoint creation.
         * </p>
         * 
         * @param initialInstanceCount
         *        The number of Amazon EC2 compute instances to deploy for initial endpoint creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialInstanceCount(Integer initialInstanceCount);

        /**
         * <p>
         * The Amazon EC2 compute instance type to deploy for hosting the model.
         * </p>
         * 
         * @param instanceType
         *        The Amazon EC2 compute instance type to deploy for hosting the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and docker image for
         * deployment on Amazon EC2 compute instances or for batch transform jobs.
         * </p>
         * 
         * @param executionRole
         *        The ARN of the IAM role that Amazon SageMaker can assume to access model artifacts and docker image
         *        for deployment on Amazon EC2 compute instances or for batch transform jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * The Amazon Web Services KMS key that Amazon SageMaker uses to encrypt data on the storage volume attached to
         * the Amazon EC2 compute instance that hosts the endpoint.
         * </p>
         * 
         * @param kmsEncryptionKey
         *        The Amazon Web Services KMS key that Amazon SageMaker uses to encrypt data on the storage volume
         *        attached to the Amazon EC2 compute instance that hosts the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsEncryptionKey(String kmsEncryptionKey);

        /**
         * <p>
         * The VPC configuration for the endpoint.
         * </p>
         * 
         * @param vpc
         *        The VPC configuration for the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpc(VpcConfig vpc);

        /**
         * <p>
         * The VPC configuration for the endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpc(VpcConfig)}.
         * 
         * @param vpc
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpc(VpcConfig)
         */
        default Builder vpc(Consumer<VpcConfig.Builder> vpc) {
            return vpc(VpcConfig.builder().applyMutation(vpc).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Integer initialInstanceCount;

        private String instanceType;

        private String executionRole;

        private String kmsEncryptionKey;

        private VpcConfig vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(SageMakerEndpoint model) {
            initialInstanceCount(model.initialInstanceCount);
            instanceType(model.instanceType);
            executionRole(model.executionRole);
            kmsEncryptionKey(model.kmsEncryptionKey);
            vpc(model.vpc);
        }

        public final Integer getInitialInstanceCount() {
            return initialInstanceCount;
        }

        public final void setInitialInstanceCount(Integer initialInstanceCount) {
            this.initialInstanceCount = initialInstanceCount;
        }

        @Override
        public final Builder initialInstanceCount(Integer initialInstanceCount) {
            this.initialInstanceCount = initialInstanceCount;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final String getKmsEncryptionKey() {
            return kmsEncryptionKey;
        }

        public final void setKmsEncryptionKey(String kmsEncryptionKey) {
            this.kmsEncryptionKey = kmsEncryptionKey;
        }

        @Override
        public final Builder kmsEncryptionKey(String kmsEncryptionKey) {
            this.kmsEncryptionKey = kmsEncryptionKey;
            return this;
        }

        public final VpcConfig.Builder getVpc() {
            return vpc != null ? vpc.toBuilder() : null;
        }

        public final void setVpc(VpcConfig.BuilderImpl vpc) {
            this.vpc = vpc != null ? vpc.build() : null;
        }

        @Override
        public final Builder vpc(VpcConfig vpc) {
            this.vpc = vpc;
            return this;
        }

        @Override
        public SageMakerEndpoint build() {
            return new SageMakerEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
