/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details for the model to process the prompt prior to retrieval and response generation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrchestrationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OrchestrationConfiguration.Builder, OrchestrationConfiguration> {
    private static final SdkField<QueryTransformationConfiguration> QUERY_TRANSFORMATION_CONFIGURATION_FIELD = SdkField
            .<QueryTransformationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("queryTransformationConfiguration")
            .getter(getter(OrchestrationConfiguration::queryTransformationConfiguration))
            .setter(setter(Builder::queryTransformationConfiguration))
            .constructor(QueryTransformationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryTransformationConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(QUERY_TRANSFORMATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final QueryTransformationConfiguration queryTransformationConfiguration;

    private OrchestrationConfiguration(BuilderImpl builder) {
        this.queryTransformationConfiguration = builder.queryTransformationConfiguration;
    }

    /**
     * <p>
     * Contains configuration details for transforming the prompt.
     * </p>
     * 
     * @return Contains configuration details for transforming the prompt.
     */
    public final QueryTransformationConfiguration queryTransformationConfiguration() {
        return queryTransformationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queryTransformationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrchestrationConfiguration)) {
            return false;
        }
        OrchestrationConfiguration other = (OrchestrationConfiguration) obj;
        return Objects.equals(queryTransformationConfiguration(), other.queryTransformationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrchestrationConfiguration")
                .add("QueryTransformationConfiguration", queryTransformationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queryTransformationConfiguration":
            return Optional.ofNullable(clazz.cast(queryTransformationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("queryTransformationConfiguration", QUERY_TRANSFORMATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrchestrationConfiguration, T> g) {
        return obj -> g.apply((OrchestrationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrchestrationConfiguration> {
        /**
         * <p>
         * Contains configuration details for transforming the prompt.
         * </p>
         * 
         * @param queryTransformationConfiguration
         *        Contains configuration details for transforming the prompt.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryTransformationConfiguration(QueryTransformationConfiguration queryTransformationConfiguration);

        /**
         * <p>
         * Contains configuration details for transforming the prompt.
         * </p>
         * This is a convenience method that creates an instance of the {@link QueryTransformationConfiguration.Builder}
         * avoiding the need to create one manually via {@link QueryTransformationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QueryTransformationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #queryTransformationConfiguration(QueryTransformationConfiguration)}.
         * 
         * @param queryTransformationConfiguration
         *        a consumer that will call methods on {@link QueryTransformationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queryTransformationConfiguration(QueryTransformationConfiguration)
         */
        default Builder queryTransformationConfiguration(
                Consumer<QueryTransformationConfiguration.Builder> queryTransformationConfiguration) {
            return queryTransformationConfiguration(QueryTransformationConfiguration.builder()
                    .applyMutation(queryTransformationConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private QueryTransformationConfiguration queryTransformationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(OrchestrationConfiguration model) {
            queryTransformationConfiguration(model.queryTransformationConfiguration);
        }

        public final QueryTransformationConfiguration.Builder getQueryTransformationConfiguration() {
            return queryTransformationConfiguration != null ? queryTransformationConfiguration.toBuilder() : null;
        }

        public final void setQueryTransformationConfiguration(
                QueryTransformationConfiguration.BuilderImpl queryTransformationConfiguration) {
            this.queryTransformationConfiguration = queryTransformationConfiguration != null ? queryTransformationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder queryTransformationConfiguration(QueryTransformationConfiguration queryTransformationConfiguration) {
            this.queryTransformationConfiguration = queryTransformationConfiguration;
            return this;
        }

        @Override
        public OrchestrationConfiguration build() {
            return new OrchestrationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
