/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about an endpoint for a model from Amazon Bedrock Marketplace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MarketplaceModelEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<MarketplaceModelEndpoint.Builder, MarketplaceModelEndpoint> {
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpointArn").getter(getter(MarketplaceModelEndpoint::endpointArn)).setter(setter(Builder::endpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointArn").build()).build();

    private static final SdkField<String> MODEL_SOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelSourceIdentifier").getter(getter(MarketplaceModelEndpoint::modelSourceIdentifier))
            .setter(setter(Builder::modelSourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSourceIdentifier").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(MarketplaceModelEndpoint::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(MarketplaceModelEndpoint::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(MarketplaceModelEndpoint::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(MarketplaceModelEndpoint::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<EndpointConfig> ENDPOINT_CONFIG_FIELD = SdkField
            .<EndpointConfig> builder(MarshallingType.SDK_POJO).memberName("endpointConfig")
            .getter(getter(MarketplaceModelEndpoint::endpointConfig)).setter(setter(Builder::endpointConfig))
            .constructor(EndpointConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfig").build()).build();

    private static final SdkField<String> ENDPOINT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpointStatus").getter(getter(MarketplaceModelEndpoint::endpointStatus))
            .setter(setter(Builder::endpointStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointStatus").build()).build();

    private static final SdkField<String> ENDPOINT_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpointStatusMessage").getter(getter(MarketplaceModelEndpoint::endpointStatusMessage))
            .setter(setter(Builder::endpointStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointStatusMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ARN_FIELD,
            MODEL_SOURCE_IDENTIFIER_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD,
            ENDPOINT_CONFIG_FIELD, ENDPOINT_STATUS_FIELD, ENDPOINT_STATUS_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String endpointArn;

    private final String modelSourceIdentifier;

    private final String status;

    private final String statusMessage;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final EndpointConfig endpointConfig;

    private final String endpointStatus;

    private final String endpointStatusMessage;

    private MarketplaceModelEndpoint(BuilderImpl builder) {
        this.endpointArn = builder.endpointArn;
        this.modelSourceIdentifier = builder.modelSourceIdentifier;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.endpointConfig = builder.endpointConfig;
        this.endpointStatus = builder.endpointStatus;
        this.endpointStatusMessage = builder.endpointStatusMessage;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint.
     */
    public final String endpointArn() {
        return endpointArn;
    }

    /**
     * <p>
     * The ARN of the model from Amazon Bedrock Marketplace that is deployed on this endpoint.
     * </p>
     * 
     * @return The ARN of the model from Amazon Bedrock Marketplace that is deployed on this endpoint.
     */
    public final String modelSourceIdentifier() {
        return modelSourceIdentifier;
    }

    /**
     * <p>
     * The overall status of the endpoint in Amazon Bedrock Marketplace (e.g., ACTIVE, INACTIVE).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The overall status of the endpoint in Amazon Bedrock Marketplace (e.g., ACTIVE, INACTIVE).
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The overall status of the endpoint in Amazon Bedrock Marketplace (e.g., ACTIVE, INACTIVE).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The overall status of the endpoint in Amazon Bedrock Marketplace (e.g., ACTIVE, INACTIVE).
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Additional information about the overall status, if available.
     * </p>
     * 
     * @return Additional information about the overall status, if available.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The timestamp when the endpoint was registered.
     * </p>
     * 
     * @return The timestamp when the endpoint was registered.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the endpoint was last updated.
     * </p>
     * 
     * @return The timestamp when the endpoint was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The configuration of the endpoint, including the number and type of instances used.
     * </p>
     * 
     * @return The configuration of the endpoint, including the number and type of instances used.
     */
    public final EndpointConfig endpointConfig() {
        return endpointConfig;
    }

    /**
     * <p>
     * The current status of the endpoint (e.g., Creating, InService, Updating, Failed).
     * </p>
     * 
     * @return The current status of the endpoint (e.g., Creating, InService, Updating, Failed).
     */
    public final String endpointStatus() {
        return endpointStatus;
    }

    /**
     * <p>
     * Additional information about the endpoint status, if available.
     * </p>
     * 
     * @return Additional information about the endpoint status, if available.
     */
    public final String endpointStatusMessage() {
        return endpointStatusMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelSourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(endpointStatus());
        hashCode = 31 * hashCode + Objects.hashCode(endpointStatusMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MarketplaceModelEndpoint)) {
            return false;
        }
        MarketplaceModelEndpoint other = (MarketplaceModelEndpoint) obj;
        return Objects.equals(endpointArn(), other.endpointArn())
                && Objects.equals(modelSourceIdentifier(), other.modelSourceIdentifier())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(endpointConfig(), other.endpointConfig())
                && Objects.equals(endpointStatus(), other.endpointStatus())
                && Objects.equals(endpointStatusMessage(), other.endpointStatusMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MarketplaceModelEndpoint").add("EndpointArn", endpointArn())
                .add("ModelSourceIdentifier", modelSourceIdentifier()).add("Status", statusAsString())
                .add("StatusMessage", statusMessage()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("EndpointConfig", endpointConfig()).add("EndpointStatus", endpointStatus())
                .add("EndpointStatusMessage", endpointStatusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "endpointArn":
            return Optional.ofNullable(clazz.cast(endpointArn()));
        case "modelSourceIdentifier":
            return Optional.ofNullable(clazz.cast(modelSourceIdentifier()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "endpointConfig":
            return Optional.ofNullable(clazz.cast(endpointConfig()));
        case "endpointStatus":
            return Optional.ofNullable(clazz.cast(endpointStatus()));
        case "endpointStatusMessage":
            return Optional.ofNullable(clazz.cast(endpointStatusMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("endpointArn", ENDPOINT_ARN_FIELD);
        map.put("modelSourceIdentifier", MODEL_SOURCE_IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("endpointConfig", ENDPOINT_CONFIG_FIELD);
        map.put("endpointStatus", ENDPOINT_STATUS_FIELD);
        map.put("endpointStatusMessage", ENDPOINT_STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MarketplaceModelEndpoint, T> g) {
        return obj -> g.apply((MarketplaceModelEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MarketplaceModelEndpoint> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint.
         * </p>
         * 
         * @param endpointArn
         *        The Amazon Resource Name (ARN) of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);

        /**
         * <p>
         * The ARN of the model from Amazon Bedrock Marketplace that is deployed on this endpoint.
         * </p>
         * 
         * @param modelSourceIdentifier
         *        The ARN of the model from Amazon Bedrock Marketplace that is deployed on this endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelSourceIdentifier(String modelSourceIdentifier);

        /**
         * <p>
         * The overall status of the endpoint in Amazon Bedrock Marketplace (e.g., ACTIVE, INACTIVE).
         * </p>
         * 
         * @param status
         *        The overall status of the endpoint in Amazon Bedrock Marketplace (e.g., ACTIVE, INACTIVE).
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The overall status of the endpoint in Amazon Bedrock Marketplace (e.g., ACTIVE, INACTIVE).
         * </p>
         * 
         * @param status
         *        The overall status of the endpoint in Amazon Bedrock Marketplace (e.g., ACTIVE, INACTIVE).
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * Additional information about the overall status, if available.
         * </p>
         * 
         * @param statusMessage
         *        Additional information about the overall status, if available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The timestamp when the endpoint was registered.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the endpoint was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the endpoint was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the endpoint was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The configuration of the endpoint, including the number and type of instances used.
         * </p>
         * 
         * @param endpointConfig
         *        The configuration of the endpoint, including the number and type of instances used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfig(EndpointConfig endpointConfig);

        /**
         * <p>
         * The configuration of the endpoint, including the number and type of instances used.
         * </p>
         * This is a convenience method that creates an instance of the {@link EndpointConfig.Builder} avoiding the need
         * to create one manually via {@link EndpointConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EndpointConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointConfig(EndpointConfig)}.
         * 
         * @param endpointConfig
         *        a consumer that will call methods on {@link EndpointConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointConfig(EndpointConfig)
         */
        default Builder endpointConfig(Consumer<EndpointConfig.Builder> endpointConfig) {
            return endpointConfig(EndpointConfig.builder().applyMutation(endpointConfig).build());
        }

        /**
         * <p>
         * The current status of the endpoint (e.g., Creating, InService, Updating, Failed).
         * </p>
         * 
         * @param endpointStatus
         *        The current status of the endpoint (e.g., Creating, InService, Updating, Failed).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointStatus(String endpointStatus);

        /**
         * <p>
         * Additional information about the endpoint status, if available.
         * </p>
         * 
         * @param endpointStatusMessage
         *        Additional information about the endpoint status, if available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointStatusMessage(String endpointStatusMessage);
    }

    static final class BuilderImpl implements Builder {
        private String endpointArn;

        private String modelSourceIdentifier;

        private String status;

        private String statusMessage;

        private Instant createdAt;

        private Instant updatedAt;

        private EndpointConfig endpointConfig;

        private String endpointStatus;

        private String endpointStatusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(MarketplaceModelEndpoint model) {
            endpointArn(model.endpointArn);
            modelSourceIdentifier(model.modelSourceIdentifier);
            status(model.status);
            statusMessage(model.statusMessage);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            endpointConfig(model.endpointConfig);
            endpointStatus(model.endpointStatus);
            endpointStatusMessage(model.endpointStatusMessage);
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final String getModelSourceIdentifier() {
            return modelSourceIdentifier;
        }

        public final void setModelSourceIdentifier(String modelSourceIdentifier) {
            this.modelSourceIdentifier = modelSourceIdentifier;
        }

        @Override
        public final Builder modelSourceIdentifier(String modelSourceIdentifier) {
            this.modelSourceIdentifier = modelSourceIdentifier;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final EndpointConfig.Builder getEndpointConfig() {
            return endpointConfig != null ? endpointConfig.toBuilder() : null;
        }

        public final void setEndpointConfig(EndpointConfig.BuilderImpl endpointConfig) {
            this.endpointConfig = endpointConfig != null ? endpointConfig.build() : null;
        }

        @Override
        public final Builder endpointConfig(EndpointConfig endpointConfig) {
            this.endpointConfig = endpointConfig;
            return this;
        }

        public final String getEndpointStatus() {
            return endpointStatus;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        @Override
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        public final String getEndpointStatusMessage() {
            return endpointStatusMessage;
        }

        public final void setEndpointStatusMessage(String endpointStatusMessage) {
            this.endpointStatusMessage = endpointStatusMessage;
        }

        @Override
        public final Builder endpointStatusMessage(String endpointStatusMessage) {
            this.endpointStatusMessage = endpointStatusMessage;
            return this;
        }

        @Override
        public MarketplaceModelEndpoint build() {
            return new MarketplaceModelEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
