/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The system-defined guardrail profile that you're using with your guardrail. Guardrail profiles define the destination
 * Amazon Web Services Regions where guardrail inference requests can be automatically routed. Using guardrail profiles
 * helps maintain guardrail performance and reliability when demand increases.
 * </p>
 * <p>
 * For more information, see the <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html">Amazon Bedrock User
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailCrossRegionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailCrossRegionConfig.Builder, GuardrailCrossRegionConfig> {
    private static final SdkField<String> GUARDRAIL_PROFILE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("guardrailProfileIdentifier")
            .getter(getter(GuardrailCrossRegionConfig::guardrailProfileIdentifier))
            .setter(setter(Builder::guardrailProfileIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailProfileIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GUARDRAIL_PROFILE_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String guardrailProfileIdentifier;

    private GuardrailCrossRegionConfig(BuilderImpl builder) {
        this.guardrailProfileIdentifier = builder.guardrailProfileIdentifier;
    }

    /**
     * <p>
     * The ID or Amazon Resource Name (ARN) of the guardrail profile that your guardrail is using. Guardrail profile
     * availability depends on your current Amazon Web Services Region. For more information, see the <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region-support.html">Amazon Bedrock
     * User Guide</a>.
     * </p>
     * 
     * @return The ID or Amazon Resource Name (ARN) of the guardrail profile that your guardrail is using. Guardrail
     *         profile availability depends on your current Amazon Web Services Region. For more information, see the <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region-support.html">Amazon
     *         Bedrock User Guide</a>.
     */
    public final String guardrailProfileIdentifier() {
        return guardrailProfileIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(guardrailProfileIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailCrossRegionConfig)) {
            return false;
        }
        GuardrailCrossRegionConfig other = (GuardrailCrossRegionConfig) obj;
        return Objects.equals(guardrailProfileIdentifier(), other.guardrailProfileIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailCrossRegionConfig").add("GuardrailProfileIdentifier", guardrailProfileIdentifier())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "guardrailProfileIdentifier":
            return Optional.ofNullable(clazz.cast(guardrailProfileIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("guardrailProfileIdentifier", GUARDRAIL_PROFILE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailCrossRegionConfig, T> g) {
        return obj -> g.apply((GuardrailCrossRegionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailCrossRegionConfig> {
        /**
         * <p>
         * The ID or Amazon Resource Name (ARN) of the guardrail profile that your guardrail is using. Guardrail profile
         * availability depends on your current Amazon Web Services Region. For more information, see the <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region-support.html">Amazon
         * Bedrock User Guide</a>.
         * </p>
         * 
         * @param guardrailProfileIdentifier
         *        The ID or Amazon Resource Name (ARN) of the guardrail profile that your guardrail is using. Guardrail
         *        profile availability depends on your current Amazon Web Services Region. For more information, see the
         *        <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region-support.html">
         *        Amazon Bedrock User Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrailProfileIdentifier(String guardrailProfileIdentifier);
    }

    static final class BuilderImpl implements Builder {
        private String guardrailProfileIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailCrossRegionConfig model) {
            guardrailProfileIdentifier(model.guardrailProfileIdentifier);
        }

        public final String getGuardrailProfileIdentifier() {
            return guardrailProfileIdentifier;
        }

        public final void setGuardrailProfileIdentifier(String guardrailProfileIdentifier) {
            this.guardrailProfileIdentifier = guardrailProfileIdentifier;
        }

        @Override
        public final Builder guardrailProfileIdentifier(String guardrailProfileIdentifier) {
            this.guardrailProfileIdentifier = guardrailProfileIdentifier;
            return this;
        }

        @Override
        public GuardrailCrossRegionConfig build() {
            return new GuardrailCrossRegionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
