/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a RAG source used for a Knowledge Base evaluation job where you provide your own inference response
 * data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationPrecomputedRagSourceConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationPrecomputedRagSourceConfig.Builder, EvaluationPrecomputedRagSourceConfig> {
    private static final SdkField<EvaluationPrecomputedRetrieveSourceConfig> RETRIEVE_SOURCE_CONFIG_FIELD = SdkField
            .<EvaluationPrecomputedRetrieveSourceConfig> builder(MarshallingType.SDK_POJO).memberName("retrieveSourceConfig")
            .getter(getter(EvaluationPrecomputedRagSourceConfig::retrieveSourceConfig))
            .setter(setter(Builder::retrieveSourceConfig)).constructor(EvaluationPrecomputedRetrieveSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieveSourceConfig").build())
            .build();

    private static final SdkField<EvaluationPrecomputedRetrieveAndGenerateSourceConfig> RETRIEVE_AND_GENERATE_SOURCE_CONFIG_FIELD = SdkField
            .<EvaluationPrecomputedRetrieveAndGenerateSourceConfig> builder(MarshallingType.SDK_POJO)
            .memberName("retrieveAndGenerateSourceConfig")
            .getter(getter(EvaluationPrecomputedRagSourceConfig::retrieveAndGenerateSourceConfig))
            .setter(setter(Builder::retrieveAndGenerateSourceConfig))
            .constructor(EvaluationPrecomputedRetrieveAndGenerateSourceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrieveAndGenerateSourceConfig")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRIEVE_SOURCE_CONFIG_FIELD,
            RETRIEVE_AND_GENERATE_SOURCE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EvaluationPrecomputedRetrieveSourceConfig retrieveSourceConfig;

    private final EvaluationPrecomputedRetrieveAndGenerateSourceConfig retrieveAndGenerateSourceConfig;

    private final Type type;

    private EvaluationPrecomputedRagSourceConfig(BuilderImpl builder) {
        this.retrieveSourceConfig = builder.retrieveSourceConfig;
        this.retrieveAndGenerateSourceConfig = builder.retrieveAndGenerateSourceConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * A summary of a RAG source used for a retrieve-only Knowledge Base evaluation job where you provide your own
     * inference response data.
     * </p>
     * 
     * @return A summary of a RAG source used for a retrieve-only Knowledge Base evaluation job where you provide your
     *         own inference response data.
     */
    public final EvaluationPrecomputedRetrieveSourceConfig retrieveSourceConfig() {
        return retrieveSourceConfig;
    }

    /**
     * <p>
     * A summary of a RAG source used for a retrieve-and-generate Knowledge Base evaluation job where you provide your
     * own inference response data.
     * </p>
     * 
     * @return A summary of a RAG source used for a retrieve-and-generate Knowledge Base evaluation job where you
     *         provide your own inference response data.
     */
    public final EvaluationPrecomputedRetrieveAndGenerateSourceConfig retrieveAndGenerateSourceConfig() {
        return retrieveAndGenerateSourceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retrieveSourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(retrieveAndGenerateSourceConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationPrecomputedRagSourceConfig)) {
            return false;
        }
        EvaluationPrecomputedRagSourceConfig other = (EvaluationPrecomputedRagSourceConfig) obj;
        return Objects.equals(retrieveSourceConfig(), other.retrieveSourceConfig())
                && Objects.equals(retrieveAndGenerateSourceConfig(), other.retrieveAndGenerateSourceConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationPrecomputedRagSourceConfig").add("RetrieveSourceConfig", retrieveSourceConfig())
                .add("RetrieveAndGenerateSourceConfig", retrieveAndGenerateSourceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "retrieveSourceConfig":
            return Optional.ofNullable(clazz.cast(retrieveSourceConfig()));
        case "retrieveAndGenerateSourceConfig":
            return Optional.ofNullable(clazz.cast(retrieveAndGenerateSourceConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #retrieveSourceConfig()} initialized to the given value.
     *
     * <p>
     * A summary of a RAG source used for a retrieve-only Knowledge Base evaluation job where you provide your own
     * inference response data.
     * </p>
     * 
     * @param retrieveSourceConfig
     *        A summary of a RAG source used for a retrieve-only Knowledge Base evaluation job where you provide your
     *        own inference response data.
     */
    public static EvaluationPrecomputedRagSourceConfig fromRetrieveSourceConfig(
            EvaluationPrecomputedRetrieveSourceConfig retrieveSourceConfig) {
        return builder().retrieveSourceConfig(retrieveSourceConfig).build();
    }

    /**
     * Create an instance of this class with {@link #retrieveSourceConfig()} initialized to the given value.
     *
     * <p>
     * A summary of a RAG source used for a retrieve-only Knowledge Base evaluation job where you provide your own
     * inference response data.
     * </p>
     * 
     * @param retrieveSourceConfig
     *        A summary of a RAG source used for a retrieve-only Knowledge Base evaluation job where you provide your
     *        own inference response data.
     */
    public static EvaluationPrecomputedRagSourceConfig fromRetrieveSourceConfig(
            Consumer<EvaluationPrecomputedRetrieveSourceConfig.Builder> retrieveSourceConfig) {
        EvaluationPrecomputedRetrieveSourceConfig.Builder builder = EvaluationPrecomputedRetrieveSourceConfig.builder();
        retrieveSourceConfig.accept(builder);
        return fromRetrieveSourceConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #retrieveAndGenerateSourceConfig()} initialized to the given value.
     *
     * <p>
     * A summary of a RAG source used for a retrieve-and-generate Knowledge Base evaluation job where you provide your
     * own inference response data.
     * </p>
     * 
     * @param retrieveAndGenerateSourceConfig
     *        A summary of a RAG source used for a retrieve-and-generate Knowledge Base evaluation job where you provide
     *        your own inference response data.
     */
    public static EvaluationPrecomputedRagSourceConfig fromRetrieveAndGenerateSourceConfig(
            EvaluationPrecomputedRetrieveAndGenerateSourceConfig retrieveAndGenerateSourceConfig) {
        return builder().retrieveAndGenerateSourceConfig(retrieveAndGenerateSourceConfig).build();
    }

    /**
     * Create an instance of this class with {@link #retrieveAndGenerateSourceConfig()} initialized to the given value.
     *
     * <p>
     * A summary of a RAG source used for a retrieve-and-generate Knowledge Base evaluation job where you provide your
     * own inference response data.
     * </p>
     * 
     * @param retrieveAndGenerateSourceConfig
     *        A summary of a RAG source used for a retrieve-and-generate Knowledge Base evaluation job where you provide
     *        your own inference response data.
     */
    public static EvaluationPrecomputedRagSourceConfig fromRetrieveAndGenerateSourceConfig(
            Consumer<EvaluationPrecomputedRetrieveAndGenerateSourceConfig.Builder> retrieveAndGenerateSourceConfig) {
        EvaluationPrecomputedRetrieveAndGenerateSourceConfig.Builder builder = EvaluationPrecomputedRetrieveAndGenerateSourceConfig
                .builder();
        retrieveAndGenerateSourceConfig.accept(builder);
        return fromRetrieveAndGenerateSourceConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("retrieveSourceConfig", RETRIEVE_SOURCE_CONFIG_FIELD);
        map.put("retrieveAndGenerateSourceConfig", RETRIEVE_AND_GENERATE_SOURCE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationPrecomputedRagSourceConfig, T> g) {
        return obj -> g.apply((EvaluationPrecomputedRagSourceConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationPrecomputedRagSourceConfig> {
        /**
         * <p>
         * A summary of a RAG source used for a retrieve-only Knowledge Base evaluation job where you provide your own
         * inference response data.
         * </p>
         * 
         * @param retrieveSourceConfig
         *        A summary of a RAG source used for a retrieve-only Knowledge Base evaluation job where you provide
         *        your own inference response data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieveSourceConfig(EvaluationPrecomputedRetrieveSourceConfig retrieveSourceConfig);

        /**
         * <p>
         * A summary of a RAG source used for a retrieve-only Knowledge Base evaluation job where you provide your own
         * inference response data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EvaluationPrecomputedRetrieveSourceConfig.Builder} avoiding the need to create one manually via
         * {@link EvaluationPrecomputedRetrieveSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationPrecomputedRetrieveSourceConfig.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #retrieveSourceConfig(EvaluationPrecomputedRetrieveSourceConfig)}.
         * 
         * @param retrieveSourceConfig
         *        a consumer that will call methods on {@link EvaluationPrecomputedRetrieveSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrieveSourceConfig(EvaluationPrecomputedRetrieveSourceConfig)
         */
        default Builder retrieveSourceConfig(Consumer<EvaluationPrecomputedRetrieveSourceConfig.Builder> retrieveSourceConfig) {
            return retrieveSourceConfig(EvaluationPrecomputedRetrieveSourceConfig.builder().applyMutation(retrieveSourceConfig)
                    .build());
        }

        /**
         * <p>
         * A summary of a RAG source used for a retrieve-and-generate Knowledge Base evaluation job where you provide
         * your own inference response data.
         * </p>
         * 
         * @param retrieveAndGenerateSourceConfig
         *        A summary of a RAG source used for a retrieve-and-generate Knowledge Base evaluation job where you
         *        provide your own inference response data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retrieveAndGenerateSourceConfig(
                EvaluationPrecomputedRetrieveAndGenerateSourceConfig retrieveAndGenerateSourceConfig);

        /**
         * <p>
         * A summary of a RAG source used for a retrieve-and-generate Knowledge Base evaluation job where you provide
         * your own inference response data.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link EvaluationPrecomputedRetrieveAndGenerateSourceConfig.Builder} avoiding the need to create one manually
         * via {@link EvaluationPrecomputedRetrieveAndGenerateSourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link EvaluationPrecomputedRetrieveAndGenerateSourceConfig.Builder#build()} is called immediately and its
         * result is passed to
         * {@link #retrieveAndGenerateSourceConfig(EvaluationPrecomputedRetrieveAndGenerateSourceConfig)}.
         * 
         * @param retrieveAndGenerateSourceConfig
         *        a consumer that will call methods on
         *        {@link EvaluationPrecomputedRetrieveAndGenerateSourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retrieveAndGenerateSourceConfig(EvaluationPrecomputedRetrieveAndGenerateSourceConfig)
         */
        default Builder retrieveAndGenerateSourceConfig(
                Consumer<EvaluationPrecomputedRetrieveAndGenerateSourceConfig.Builder> retrieveAndGenerateSourceConfig) {
            return retrieveAndGenerateSourceConfig(EvaluationPrecomputedRetrieveAndGenerateSourceConfig.builder()
                    .applyMutation(retrieveAndGenerateSourceConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EvaluationPrecomputedRetrieveSourceConfig retrieveSourceConfig;

        private EvaluationPrecomputedRetrieveAndGenerateSourceConfig retrieveAndGenerateSourceConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationPrecomputedRagSourceConfig model) {
            retrieveSourceConfig(model.retrieveSourceConfig);
            retrieveAndGenerateSourceConfig(model.retrieveAndGenerateSourceConfig);
        }

        public final EvaluationPrecomputedRetrieveSourceConfig.Builder getRetrieveSourceConfig() {
            return retrieveSourceConfig != null ? retrieveSourceConfig.toBuilder() : null;
        }

        public final void setRetrieveSourceConfig(EvaluationPrecomputedRetrieveSourceConfig.BuilderImpl retrieveSourceConfig) {
            Object oldValue = this.retrieveSourceConfig;
            this.retrieveSourceConfig = retrieveSourceConfig != null ? retrieveSourceConfig.build() : null;
            handleUnionValueChange(Type.RETRIEVE_SOURCE_CONFIG, oldValue, this.retrieveSourceConfig);
        }

        @Override
        public final Builder retrieveSourceConfig(EvaluationPrecomputedRetrieveSourceConfig retrieveSourceConfig) {
            Object oldValue = this.retrieveSourceConfig;
            this.retrieveSourceConfig = retrieveSourceConfig;
            handleUnionValueChange(Type.RETRIEVE_SOURCE_CONFIG, oldValue, this.retrieveSourceConfig);
            return this;
        }

        public final EvaluationPrecomputedRetrieveAndGenerateSourceConfig.Builder getRetrieveAndGenerateSourceConfig() {
            return retrieveAndGenerateSourceConfig != null ? retrieveAndGenerateSourceConfig.toBuilder() : null;
        }

        public final void setRetrieveAndGenerateSourceConfig(
                EvaluationPrecomputedRetrieveAndGenerateSourceConfig.BuilderImpl retrieveAndGenerateSourceConfig) {
            Object oldValue = this.retrieveAndGenerateSourceConfig;
            this.retrieveAndGenerateSourceConfig = retrieveAndGenerateSourceConfig != null ? retrieveAndGenerateSourceConfig
                    .build() : null;
            handleUnionValueChange(Type.RETRIEVE_AND_GENERATE_SOURCE_CONFIG, oldValue, this.retrieveAndGenerateSourceConfig);
        }

        @Override
        public final Builder retrieveAndGenerateSourceConfig(
                EvaluationPrecomputedRetrieveAndGenerateSourceConfig retrieveAndGenerateSourceConfig) {
            Object oldValue = this.retrieveAndGenerateSourceConfig;
            this.retrieveAndGenerateSourceConfig = retrieveAndGenerateSourceConfig;
            handleUnionValueChange(Type.RETRIEVE_AND_GENERATE_SOURCE_CONFIG, oldValue, this.retrieveAndGenerateSourceConfig);
            return this;
        }

        @Override
        public EvaluationPrecomputedRagSourceConfig build() {
            return new EvaluationPrecomputedRagSourceConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see EvaluationPrecomputedRagSourceConfig#type()
     */
    public enum Type {
        RETRIEVE_SOURCE_CONFIG,

        RETRIEVE_AND_GENERATE_SOURCE_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
