/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to specify the name of a built-in prompt dataset and optionally, the Amazon S3 bucket where a custom prompt
 * dataset is saved.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluationDataset implements SdkPojo, Serializable,
        ToCopyableBuilder<EvaluationDataset.Builder, EvaluationDataset> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EvaluationDataset::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<EvaluationDatasetLocation> DATASET_LOCATION_FIELD = SdkField
            .<EvaluationDatasetLocation> builder(MarshallingType.SDK_POJO).memberName("datasetLocation")
            .getter(getter(EvaluationDataset::datasetLocation)).setter(setter(Builder::datasetLocation))
            .constructor(EvaluationDatasetLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DATASET_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final EvaluationDatasetLocation datasetLocation;

    private EvaluationDataset(BuilderImpl builder) {
        this.name = builder.name;
        this.datasetLocation = builder.datasetLocation;
    }

    /**
     * <p>
     * Used to specify supported built-in prompt datasets. Valid values are <code>Builtin.Bold</code>,
     * <code>Builtin.BoolQ</code>, <code>Builtin.NaturalQuestions</code>, <code>Builtin.Gigaword</code>,
     * <code>Builtin.RealToxicityPrompts</code>, <code>Builtin.TriviaQA</code>, <code>Builtin.T-Rex</code>,
     * <code>Builtin.WomensEcommerceClothingReviews</code> and <code>Builtin.Wikitext2</code>.
     * </p>
     * 
     * @return Used to specify supported built-in prompt datasets. Valid values are <code>Builtin.Bold</code>,
     *         <code>Builtin.BoolQ</code>, <code>Builtin.NaturalQuestions</code>, <code>Builtin.Gigaword</code>,
     *         <code>Builtin.RealToxicityPrompts</code>, <code>Builtin.TriviaQA</code>, <code>Builtin.T-Rex</code>,
     *         <code>Builtin.WomensEcommerceClothingReviews</code> and <code>Builtin.Wikitext2</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * For custom prompt datasets, you must specify the location in Amazon S3 where the prompt dataset is saved.
     * </p>
     * 
     * @return For custom prompt datasets, you must specify the location in Amazon S3 where the prompt dataset is saved.
     */
    public final EvaluationDatasetLocation datasetLocation() {
        return datasetLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(datasetLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationDataset)) {
            return false;
        }
        EvaluationDataset other = (EvaluationDataset) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(datasetLocation(), other.datasetLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluationDataset").add("Name", name() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DatasetLocation", datasetLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "datasetLocation":
            return Optional.ofNullable(clazz.cast(datasetLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("datasetLocation", DATASET_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationDataset, T> g) {
        return obj -> g.apply((EvaluationDataset) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EvaluationDataset> {
        /**
         * <p>
         * Used to specify supported built-in prompt datasets. Valid values are <code>Builtin.Bold</code>,
         * <code>Builtin.BoolQ</code>, <code>Builtin.NaturalQuestions</code>, <code>Builtin.Gigaword</code>,
         * <code>Builtin.RealToxicityPrompts</code>, <code>Builtin.TriviaQA</code>, <code>Builtin.T-Rex</code>,
         * <code>Builtin.WomensEcommerceClothingReviews</code> and <code>Builtin.Wikitext2</code>.
         * </p>
         * 
         * @param name
         *        Used to specify supported built-in prompt datasets. Valid values are <code>Builtin.Bold</code>,
         *        <code>Builtin.BoolQ</code>, <code>Builtin.NaturalQuestions</code>, <code>Builtin.Gigaword</code>,
         *        <code>Builtin.RealToxicityPrompts</code>, <code>Builtin.TriviaQA</code>, <code>Builtin.T-Rex</code>,
         *        <code>Builtin.WomensEcommerceClothingReviews</code> and <code>Builtin.Wikitext2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * For custom prompt datasets, you must specify the location in Amazon S3 where the prompt dataset is saved.
         * </p>
         * 
         * @param datasetLocation
         *        For custom prompt datasets, you must specify the location in Amazon S3 where the prompt dataset is
         *        saved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetLocation(EvaluationDatasetLocation datasetLocation);

        /**
         * <p>
         * For custom prompt datasets, you must specify the location in Amazon S3 where the prompt dataset is saved.
         * </p>
         * This is a convenience method that creates an instance of the {@link EvaluationDatasetLocation.Builder}
         * avoiding the need to create one manually via {@link EvaluationDatasetLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EvaluationDatasetLocation.Builder#build()} is called immediately
         * and its result is passed to {@link #datasetLocation(EvaluationDatasetLocation)}.
         * 
         * @param datasetLocation
         *        a consumer that will call methods on {@link EvaluationDatasetLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetLocation(EvaluationDatasetLocation)
         */
        default Builder datasetLocation(Consumer<EvaluationDatasetLocation.Builder> datasetLocation) {
            return datasetLocation(EvaluationDatasetLocation.builder().applyMutation(datasetLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private EvaluationDatasetLocation datasetLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationDataset model) {
            name(model.name);
            datasetLocation(model.datasetLocation);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final EvaluationDatasetLocation.Builder getDatasetLocation() {
            return datasetLocation != null ? datasetLocation.toBuilder() : null;
        }

        public final void setDatasetLocation(EvaluationDatasetLocation.BuilderImpl datasetLocation) {
            this.datasetLocation = datasetLocation != null ? datasetLocation.build() : null;
        }

        @Override
        public final Builder datasetLocation(EvaluationDatasetLocation datasetLocation) {
            this.datasetLocation = datasetLocation;
            return this;
        }

        @Override
        public EvaluationDataset build() {
            return new EvaluationDataset(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
