/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An array item definining a single custom metric for use in an Amazon Bedrock evaluation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AutomatedEvaluationCustomMetricSource implements SdkPojo, Serializable,
        ToCopyableBuilder<AutomatedEvaluationCustomMetricSource.Builder, AutomatedEvaluationCustomMetricSource> {
    private static final SdkField<CustomMetricDefinition> CUSTOM_METRIC_DEFINITION_FIELD = SdkField
            .<CustomMetricDefinition> builder(MarshallingType.SDK_POJO).memberName("customMetricDefinition")
            .getter(getter(AutomatedEvaluationCustomMetricSource::customMetricDefinition))
            .setter(setter(Builder::customMetricDefinition)).constructor(CustomMetricDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customMetricDefinition").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CUSTOM_METRIC_DEFINITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CustomMetricDefinition customMetricDefinition;

    private final Type type;

    private AutomatedEvaluationCustomMetricSource(BuilderImpl builder) {
        this.customMetricDefinition = builder.customMetricDefinition;
        this.type = builder.type;
    }

    /**
     * <p>
     * The definition of a custom metric for use in an Amazon Bedrock evaluation job.
     * </p>
     * 
     * @return The definition of a custom metric for use in an Amazon Bedrock evaluation job.
     */
    public final CustomMetricDefinition customMetricDefinition() {
        return customMetricDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customMetricDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedEvaluationCustomMetricSource)) {
            return false;
        }
        AutomatedEvaluationCustomMetricSource other = (AutomatedEvaluationCustomMetricSource) obj;
        return Objects.equals(customMetricDefinition(), other.customMetricDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AutomatedEvaluationCustomMetricSource")
                .add("CustomMetricDefinition", customMetricDefinition() == null ? null : "*** Sensitive Data Redacted ***")
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customMetricDefinition":
            return Optional.ofNullable(clazz.cast(customMetricDefinition()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #customMetricDefinition()} initialized to the given value.
     *
     * <p>
     * The definition of a custom metric for use in an Amazon Bedrock evaluation job.
     * </p>
     * 
     * @param customMetricDefinition
     *        The definition of a custom metric for use in an Amazon Bedrock evaluation job.
     */
    public static AutomatedEvaluationCustomMetricSource fromCustomMetricDefinition(CustomMetricDefinition customMetricDefinition) {
        return builder().customMetricDefinition(customMetricDefinition).build();
    }

    /**
     * Create an instance of this class with {@link #customMetricDefinition()} initialized to the given value.
     *
     * <p>
     * The definition of a custom metric for use in an Amazon Bedrock evaluation job.
     * </p>
     * 
     * @param customMetricDefinition
     *        The definition of a custom metric for use in an Amazon Bedrock evaluation job.
     */
    public static AutomatedEvaluationCustomMetricSource fromCustomMetricDefinition(
            Consumer<CustomMetricDefinition.Builder> customMetricDefinition) {
        CustomMetricDefinition.Builder builder = CustomMetricDefinition.builder();
        customMetricDefinition.accept(builder);
        return fromCustomMetricDefinition(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customMetricDefinition", CUSTOM_METRIC_DEFINITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedEvaluationCustomMetricSource, T> g) {
        return obj -> g.apply((AutomatedEvaluationCustomMetricSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AutomatedEvaluationCustomMetricSource> {
        /**
         * <p>
         * The definition of a custom metric for use in an Amazon Bedrock evaluation job.
         * </p>
         * 
         * @param customMetricDefinition
         *        The definition of a custom metric for use in an Amazon Bedrock evaluation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customMetricDefinition(CustomMetricDefinition customMetricDefinition);

        /**
         * <p>
         * The definition of a custom metric for use in an Amazon Bedrock evaluation job.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomMetricDefinition.Builder} avoiding
         * the need to create one manually via {@link CustomMetricDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomMetricDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #customMetricDefinition(CustomMetricDefinition)}.
         * 
         * @param customMetricDefinition
         *        a consumer that will call methods on {@link CustomMetricDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customMetricDefinition(CustomMetricDefinition)
         */
        default Builder customMetricDefinition(Consumer<CustomMetricDefinition.Builder> customMetricDefinition) {
            return customMetricDefinition(CustomMetricDefinition.builder().applyMutation(customMetricDefinition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CustomMetricDefinition customMetricDefinition;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedEvaluationCustomMetricSource model) {
            customMetricDefinition(model.customMetricDefinition);
        }

        public final CustomMetricDefinition.Builder getCustomMetricDefinition() {
            return customMetricDefinition != null ? customMetricDefinition.toBuilder() : null;
        }

        public final void setCustomMetricDefinition(CustomMetricDefinition.BuilderImpl customMetricDefinition) {
            Object oldValue = this.customMetricDefinition;
            this.customMetricDefinition = customMetricDefinition != null ? customMetricDefinition.build() : null;
            handleUnionValueChange(Type.CUSTOM_METRIC_DEFINITION, oldValue, this.customMetricDefinition);
        }

        @Override
        public final Builder customMetricDefinition(CustomMetricDefinition customMetricDefinition) {
            Object oldValue = this.customMetricDefinition;
            this.customMetricDefinition = customMetricDefinition;
            handleUnionValueChange(Type.CUSTOM_METRIC_DEFINITION, oldValue, this.customMetricDefinition);
            return this;
        }

        @Override
        public AutomatedEvaluationCustomMetricSource build() {
            return new AutomatedEvaluationCustomMetricSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AutomatedEvaluationCustomMetricSource#type()
     */
    public enum Type {
        CUSTOM_METRIC_DEFINITION,

        UNKNOWN_TO_SDK_VERSION
    }
}
