/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGuardrailRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, GetGuardrailRequest> {
    private static final SdkField<String> GUARDRAIL_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailIdentifier").getter(GetGuardrailRequest.getter(GetGuardrailRequest::guardrailIdentifier)).setter(GetGuardrailRequest.setter(Builder::guardrailIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("guardrailIdentifier").build()}).build();
    private static final SdkField<String> GUARDRAIL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailVersion").getter(GetGuardrailRequest.getter(GetGuardrailRequest::guardrailVersion)).setter(GetGuardrailRequest.setter(Builder::guardrailVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("guardrailVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_IDENTIFIER_FIELD, GUARDRAIL_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetGuardrailRequest.memberNameToFieldInitializer();
    private final String guardrailIdentifier;
    private final String guardrailVersion;

    private GetGuardrailRequest(BuilderImpl builder) {
        super(builder);
        this.guardrailIdentifier = builder.guardrailIdentifier;
        this.guardrailVersion = builder.guardrailVersion;
    }

    public final String guardrailIdentifier() {
        return this.guardrailIdentifier;
    }

    public final String guardrailVersion() {
        return this.guardrailVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGuardrailRequest)) {
            return false;
        }
        GetGuardrailRequest other = (GetGuardrailRequest)((Object)obj);
        return Objects.equals(this.guardrailIdentifier(), other.guardrailIdentifier()) && Objects.equals(this.guardrailVersion(), other.guardrailVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetGuardrailRequest").add("GuardrailIdentifier", (Object)this.guardrailIdentifier()).add("GuardrailVersion", (Object)this.guardrailVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "guardrailIdentifier": {
                return Optional.ofNullable(clazz.cast(this.guardrailIdentifier()));
            }
            case "guardrailVersion": {
                return Optional.ofNullable(clazz.cast(this.guardrailVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("guardrailIdentifier", GUARDRAIL_IDENTIFIER_FIELD);
        map.put("guardrailVersion", GUARDRAIL_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGuardrailRequest, T> g) {
        return obj -> g.apply((GetGuardrailRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String guardrailIdentifier;
        private String guardrailVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGuardrailRequest model) {
            super(model);
            this.guardrailIdentifier(model.guardrailIdentifier);
            this.guardrailVersion(model.guardrailVersion);
        }

        public final String getGuardrailIdentifier() {
            return this.guardrailIdentifier;
        }

        public final void setGuardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
        }

        @Override
        public final Builder guardrailIdentifier(String guardrailIdentifier) {
            this.guardrailIdentifier = guardrailIdentifier;
            return this;
        }

        public final String getGuardrailVersion() {
            return this.guardrailVersion;
        }

        public final void setGuardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
        }

        @Override
        public final Builder guardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetGuardrailRequest build() {
            return new GetGuardrailRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGuardrailRequest> {
        public Builder guardrailIdentifier(String var1);

        public Builder guardrailVersion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

