/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailRegex
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailRegex> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GuardrailRegex.getter(GuardrailRegex::name)).setter(GuardrailRegex.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GuardrailRegex.getter(GuardrailRegex::description)).setter(GuardrailRegex.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> PATTERN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pattern").getter(GuardrailRegex.getter(GuardrailRegex::pattern)).setter(GuardrailRegex.setter(Builder::pattern)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pattern").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("action").getter(GuardrailRegex.getter(GuardrailRegex::actionAsString)).setter(GuardrailRegex.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<String> INPUT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputAction").getter(GuardrailRegex.getter(GuardrailRegex::inputActionAsString)).setter(GuardrailRegex.setter(Builder::inputAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputAction").build()}).build();
    private static final SdkField<String> OUTPUT_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputAction").getter(GuardrailRegex.getter(GuardrailRegex::outputActionAsString)).setter(GuardrailRegex.setter(Builder::outputAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputAction").build()}).build();
    private static final SdkField<Boolean> INPUT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("inputEnabled").getter(GuardrailRegex.getter(GuardrailRegex::inputEnabled)).setter(GuardrailRegex.setter(Builder::inputEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputEnabled").build()}).build();
    private static final SdkField<Boolean> OUTPUT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("outputEnabled").getter(GuardrailRegex.getter(GuardrailRegex::outputEnabled)).setter(GuardrailRegex.setter(Builder::outputEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, PATTERN_FIELD, ACTION_FIELD, INPUT_ACTION_FIELD, OUTPUT_ACTION_FIELD, INPUT_ENABLED_FIELD, OUTPUT_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailRegex.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String pattern;
    private final String action;
    private final String inputAction;
    private final String outputAction;
    private final Boolean inputEnabled;
    private final Boolean outputEnabled;

    private GuardrailRegex(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.pattern = builder.pattern;
        this.action = builder.action;
        this.inputAction = builder.inputAction;
        this.outputAction = builder.outputAction;
        this.inputEnabled = builder.inputEnabled;
        this.outputEnabled = builder.outputEnabled;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String pattern() {
        return this.pattern;
    }

    public final GuardrailSensitiveInformationAction action() {
        return GuardrailSensitiveInformationAction.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final GuardrailSensitiveInformationAction inputAction() {
        return GuardrailSensitiveInformationAction.fromValue(this.inputAction);
    }

    public final String inputActionAsString() {
        return this.inputAction;
    }

    public final GuardrailSensitiveInformationAction outputAction() {
        return GuardrailSensitiveInformationAction.fromValue(this.outputAction);
    }

    public final String outputActionAsString() {
        return this.outputAction;
    }

    public final Boolean inputEnabled() {
        return this.inputEnabled;
    }

    public final Boolean outputEnabled() {
        return this.outputEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.pattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailRegex)) {
            return false;
        }
        GuardrailRegex other = (GuardrailRegex)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.pattern(), other.pattern()) && Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.inputActionAsString(), other.inputActionAsString()) && Objects.equals(this.outputActionAsString(), other.outputActionAsString()) && Objects.equals(this.inputEnabled(), other.inputEnabled()) && Objects.equals(this.outputEnabled(), other.outputEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailRegex").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Pattern", (Object)this.pattern()).add("Action", (Object)this.actionAsString()).add("InputAction", (Object)this.inputActionAsString()).add("OutputAction", (Object)this.outputActionAsString()).add("InputEnabled", (Object)this.inputEnabled()).add("OutputEnabled", (Object)this.outputEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "pattern": {
                return Optional.ofNullable(clazz.cast(this.pattern()));
            }
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "inputAction": {
                return Optional.ofNullable(clazz.cast(this.inputActionAsString()));
            }
            case "outputAction": {
                return Optional.ofNullable(clazz.cast(this.outputActionAsString()));
            }
            case "inputEnabled": {
                return Optional.ofNullable(clazz.cast(this.inputEnabled()));
            }
            case "outputEnabled": {
                return Optional.ofNullable(clazz.cast(this.outputEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("pattern", PATTERN_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("inputAction", INPUT_ACTION_FIELD);
        map.put("outputAction", OUTPUT_ACTION_FIELD);
        map.put("inputEnabled", INPUT_ENABLED_FIELD);
        map.put("outputEnabled", OUTPUT_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailRegex, T> g) {
        return obj -> g.apply((GuardrailRegex)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String pattern;
        private String action;
        private String inputAction;
        private String outputAction;
        private Boolean inputEnabled;
        private Boolean outputEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailRegex model) {
            this.name(model.name);
            this.description(model.description);
            this.pattern(model.pattern);
            this.action(model.action);
            this.inputAction(model.inputAction);
            this.outputAction(model.outputAction);
            this.inputEnabled(model.inputEnabled);
            this.outputEnabled(model.outputEnabled);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getPattern() {
            return this.pattern;
        }

        public final void setPattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public final Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailSensitiveInformationAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getInputAction() {
            return this.inputAction;
        }

        public final void setInputAction(String inputAction) {
            this.inputAction = inputAction;
        }

        @Override
        public final Builder inputAction(String inputAction) {
            this.inputAction = inputAction;
            return this;
        }

        @Override
        public final Builder inputAction(GuardrailSensitiveInformationAction inputAction) {
            this.inputAction(inputAction == null ? null : inputAction.toString());
            return this;
        }

        public final String getOutputAction() {
            return this.outputAction;
        }

        public final void setOutputAction(String outputAction) {
            this.outputAction = outputAction;
        }

        @Override
        public final Builder outputAction(String outputAction) {
            this.outputAction = outputAction;
            return this;
        }

        @Override
        public final Builder outputAction(GuardrailSensitiveInformationAction outputAction) {
            this.outputAction(outputAction == null ? null : outputAction.toString());
            return this;
        }

        public final Boolean getInputEnabled() {
            return this.inputEnabled;
        }

        public final void setInputEnabled(Boolean inputEnabled) {
            this.inputEnabled = inputEnabled;
        }

        @Override
        public final Builder inputEnabled(Boolean inputEnabled) {
            this.inputEnabled = inputEnabled;
            return this;
        }

        public final Boolean getOutputEnabled() {
            return this.outputEnabled;
        }

        public final void setOutputEnabled(Boolean outputEnabled) {
            this.outputEnabled = outputEnabled;
        }

        @Override
        public final Builder outputEnabled(Boolean outputEnabled) {
            this.outputEnabled = outputEnabled;
            return this;
        }

        public GuardrailRegex build() {
            return new GuardrailRegex(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailRegex> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder pattern(String var1);

        public Builder action(String var1);

        public Builder action(GuardrailSensitiveInformationAction var1);

        public Builder inputAction(String var1);

        public Builder inputAction(GuardrailSensitiveInformationAction var1);

        public Builder outputAction(String var1);

        public Builder outputAction(GuardrailSensitiveInformationAction var1);

        public Builder inputEnabled(Boolean var1);

        public Builder outputEnabled(Boolean var1);
    }
}

