/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HumanWorkflowConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HumanWorkflowConfig> {
    private static final SdkField<String> FLOW_DEFINITION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flowDefinitionArn").getter(HumanWorkflowConfig.getter(HumanWorkflowConfig::flowDefinitionArn)).setter(HumanWorkflowConfig.setter(Builder::flowDefinitionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowDefinitionArn").build()}).build();
    private static final SdkField<String> INSTRUCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instructions").getter(HumanWorkflowConfig.getter(HumanWorkflowConfig::instructions)).setter(HumanWorkflowConfig.setter(Builder::instructions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instructions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_DEFINITION_ARN_FIELD, INSTRUCTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HumanWorkflowConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String flowDefinitionArn;
    private final String instructions;

    private HumanWorkflowConfig(BuilderImpl builder) {
        this.flowDefinitionArn = builder.flowDefinitionArn;
        this.instructions = builder.instructions;
    }

    public final String flowDefinitionArn() {
        return this.flowDefinitionArn;
    }

    public final String instructions() {
        return this.instructions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instructions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HumanWorkflowConfig)) {
            return false;
        }
        HumanWorkflowConfig other = (HumanWorkflowConfig)obj;
        return Objects.equals(this.flowDefinitionArn(), other.flowDefinitionArn()) && Objects.equals(this.instructions(), other.instructions());
    }

    public final String toString() {
        return ToString.builder((String)"HumanWorkflowConfig").add("FlowDefinitionArn", (Object)this.flowDefinitionArn()).add("Instructions", (Object)(this.instructions() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "flowDefinitionArn": {
                return Optional.ofNullable(clazz.cast(this.flowDefinitionArn()));
            }
            case "instructions": {
                return Optional.ofNullable(clazz.cast(this.instructions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("flowDefinitionArn", FLOW_DEFINITION_ARN_FIELD);
        map.put("instructions", INSTRUCTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HumanWorkflowConfig, T> g) {
        return obj -> g.apply((HumanWorkflowConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String flowDefinitionArn;
        private String instructions;

        private BuilderImpl() {
        }

        private BuilderImpl(HumanWorkflowConfig model) {
            this.flowDefinitionArn(model.flowDefinitionArn);
            this.instructions(model.instructions);
        }

        public final String getFlowDefinitionArn() {
            return this.flowDefinitionArn;
        }

        public final void setFlowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
        }

        @Override
        public final Builder flowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
            return this;
        }

        public final String getInstructions() {
            return this.instructions;
        }

        public final void setInstructions(String instructions) {
            this.instructions = instructions;
        }

        @Override
        public final Builder instructions(String instructions) {
            this.instructions = instructions;
            return this;
        }

        public HumanWorkflowConfig build() {
            return new HumanWorkflowConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HumanWorkflowConfig> {
        public Builder flowDefinitionArn(String var1);

        public Builder instructions(String var1);
    }
}

