/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.GuardrailContentPolicy;
import software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingPolicy;
import software.amazon.awssdk.services.bedrock.model.GuardrailFailureRecommendationsCopier;
import software.amazon.awssdk.services.bedrock.model.GuardrailSensitiveInformationPolicy;
import software.amazon.awssdk.services.bedrock.model.GuardrailStatus;
import software.amazon.awssdk.services.bedrock.model.GuardrailStatusReasonsCopier;
import software.amazon.awssdk.services.bedrock.model.GuardrailTopicPolicy;
import software.amazon.awssdk.services.bedrock.model.GuardrailWordPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGuardrailResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, GetGuardrailResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetGuardrailResponse.getter(GetGuardrailResponse::name)).setter(GetGuardrailResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetGuardrailResponse.getter(GetGuardrailResponse::description)).setter(GetGuardrailResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> GUARDRAIL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailId").getter(GetGuardrailResponse.getter(GetGuardrailResponse::guardrailId)).setter(GetGuardrailResponse.setter(Builder::guardrailId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailId").build()}).build();
    private static final SdkField<String> GUARDRAIL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailArn").getter(GetGuardrailResponse.getter(GetGuardrailResponse::guardrailArn)).setter(GetGuardrailResponse.setter(Builder::guardrailArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailArn").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(GetGuardrailResponse.getter(GetGuardrailResponse::version)).setter(GetGuardrailResponse.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetGuardrailResponse.getter(GetGuardrailResponse::statusAsString)).setter(GetGuardrailResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<GuardrailTopicPolicy> TOPIC_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("topicPolicy").getter(GetGuardrailResponse.getter(GetGuardrailResponse::topicPolicy)).setter(GetGuardrailResponse.setter(Builder::topicPolicy)).constructor(GuardrailTopicPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicPolicy").build()}).build();
    private static final SdkField<GuardrailContentPolicy> CONTENT_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contentPolicy").getter(GetGuardrailResponse.getter(GetGuardrailResponse::contentPolicy)).setter(GetGuardrailResponse.setter(Builder::contentPolicy)).constructor(GuardrailContentPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentPolicy").build()}).build();
    private static final SdkField<GuardrailWordPolicy> WORD_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("wordPolicy").getter(GetGuardrailResponse.getter(GetGuardrailResponse::wordPolicy)).setter(GetGuardrailResponse.setter(Builder::wordPolicy)).constructor(GuardrailWordPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wordPolicy").build()}).build();
    private static final SdkField<GuardrailSensitiveInformationPolicy> SENSITIVE_INFORMATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sensitiveInformationPolicy").getter(GetGuardrailResponse.getter(GetGuardrailResponse::sensitiveInformationPolicy)).setter(GetGuardrailResponse.setter(Builder::sensitiveInformationPolicy)).constructor(GuardrailSensitiveInformationPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sensitiveInformationPolicy").build()}).build();
    private static final SdkField<GuardrailContextualGroundingPolicy> CONTEXTUAL_GROUNDING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contextualGroundingPolicy").getter(GetGuardrailResponse.getter(GetGuardrailResponse::contextualGroundingPolicy)).setter(GetGuardrailResponse.setter(Builder::contextualGroundingPolicy)).constructor(GuardrailContextualGroundingPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contextualGroundingPolicy").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetGuardrailResponse.getter(GetGuardrailResponse::createdAt)).setter(GetGuardrailResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetGuardrailResponse.getter(GetGuardrailResponse::updatedAt)).setter(GetGuardrailResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<String>> STATUS_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statusReasons").getter(GetGuardrailResponse.getter(GetGuardrailResponse::statusReasons)).setter(GetGuardrailResponse.setter(Builder::statusReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> FAILURE_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureRecommendations").getter(GetGuardrailResponse.getter(GetGuardrailResponse::failureRecommendations)).setter(GetGuardrailResponse.setter(Builder::failureRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> BLOCKED_INPUT_MESSAGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockedInputMessaging").getter(GetGuardrailResponse.getter(GetGuardrailResponse::blockedInputMessaging)).setter(GetGuardrailResponse.setter(Builder::blockedInputMessaging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedInputMessaging").build()}).build();
    private static final SdkField<String> BLOCKED_OUTPUTS_MESSAGING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blockedOutputsMessaging").getter(GetGuardrailResponse.getter(GetGuardrailResponse::blockedOutputsMessaging)).setter(GetGuardrailResponse.setter(Builder::blockedOutputsMessaging)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedOutputsMessaging").build()}).build();
    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyArn").getter(GetGuardrailResponse.getter(GetGuardrailResponse::kmsKeyArn)).setter(GetGuardrailResponse.setter(Builder::kmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, GUARDRAIL_ID_FIELD, GUARDRAIL_ARN_FIELD, VERSION_FIELD, STATUS_FIELD, TOPIC_POLICY_FIELD, CONTENT_POLICY_FIELD, WORD_POLICY_FIELD, SENSITIVE_INFORMATION_POLICY_FIELD, CONTEXTUAL_GROUNDING_POLICY_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, STATUS_REASONS_FIELD, FAILURE_RECOMMENDATIONS_FIELD, BLOCKED_INPUT_MESSAGING_FIELD, BLOCKED_OUTPUTS_MESSAGING_FIELD, KMS_KEY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetGuardrailResponse.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final String guardrailId;
    private final String guardrailArn;
    private final String version;
    private final String status;
    private final GuardrailTopicPolicy topicPolicy;
    private final GuardrailContentPolicy contentPolicy;
    private final GuardrailWordPolicy wordPolicy;
    private final GuardrailSensitiveInformationPolicy sensitiveInformationPolicy;
    private final GuardrailContextualGroundingPolicy contextualGroundingPolicy;
    private final Instant createdAt;
    private final Instant updatedAt;
    private final List<String> statusReasons;
    private final List<String> failureRecommendations;
    private final String blockedInputMessaging;
    private final String blockedOutputsMessaging;
    private final String kmsKeyArn;

    private GetGuardrailResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.guardrailId = builder.guardrailId;
        this.guardrailArn = builder.guardrailArn;
        this.version = builder.version;
        this.status = builder.status;
        this.topicPolicy = builder.topicPolicy;
        this.contentPolicy = builder.contentPolicy;
        this.wordPolicy = builder.wordPolicy;
        this.sensitiveInformationPolicy = builder.sensitiveInformationPolicy;
        this.contextualGroundingPolicy = builder.contextualGroundingPolicy;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.statusReasons = builder.statusReasons;
        this.failureRecommendations = builder.failureRecommendations;
        this.blockedInputMessaging = builder.blockedInputMessaging;
        this.blockedOutputsMessaging = builder.blockedOutputsMessaging;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String guardrailId() {
        return this.guardrailId;
    }

    public final String guardrailArn() {
        return this.guardrailArn;
    }

    public final String version() {
        return this.version;
    }

    public final GuardrailStatus status() {
        return GuardrailStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final GuardrailTopicPolicy topicPolicy() {
        return this.topicPolicy;
    }

    public final GuardrailContentPolicy contentPolicy() {
        return this.contentPolicy;
    }

    public final GuardrailWordPolicy wordPolicy() {
        return this.wordPolicy;
    }

    public final GuardrailSensitiveInformationPolicy sensitiveInformationPolicy() {
        return this.sensitiveInformationPolicy;
    }

    public final GuardrailContextualGroundingPolicy contextualGroundingPolicy() {
        return this.contextualGroundingPolicy;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasStatusReasons() {
        return this.statusReasons != null && !(this.statusReasons instanceof SdkAutoConstructList);
    }

    public final List<String> statusReasons() {
        return this.statusReasons;
    }

    public final boolean hasFailureRecommendations() {
        return this.failureRecommendations != null && !(this.failureRecommendations instanceof SdkAutoConstructList);
    }

    public final List<String> failureRecommendations() {
        return this.failureRecommendations;
    }

    public final String blockedInputMessaging() {
        return this.blockedInputMessaging;
    }

    public final String blockedOutputsMessaging() {
        return this.blockedOutputsMessaging;
    }

    public final String kmsKeyArn() {
        return this.kmsKeyArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.wordPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.sensitiveInformationPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.contextualGroundingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatusReasons() ? this.statusReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureRecommendations() ? this.failureRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.blockedInputMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(this.blockedOutputsMessaging());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGuardrailResponse)) {
            return false;
        }
        GetGuardrailResponse other = (GetGuardrailResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.guardrailId(), other.guardrailId()) && Objects.equals(this.guardrailArn(), other.guardrailArn()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.topicPolicy(), other.topicPolicy()) && Objects.equals(this.contentPolicy(), other.contentPolicy()) && Objects.equals(this.wordPolicy(), other.wordPolicy()) && Objects.equals(this.sensitiveInformationPolicy(), other.sensitiveInformationPolicy()) && Objects.equals(this.contextualGroundingPolicy(), other.contextualGroundingPolicy()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasStatusReasons() == other.hasStatusReasons() && Objects.equals(this.statusReasons(), other.statusReasons()) && this.hasFailureRecommendations() == other.hasFailureRecommendations() && Objects.equals(this.failureRecommendations(), other.failureRecommendations()) && Objects.equals(this.blockedInputMessaging(), other.blockedInputMessaging()) && Objects.equals(this.blockedOutputsMessaging(), other.blockedOutputsMessaging()) && Objects.equals(this.kmsKeyArn(), other.kmsKeyArn());
    }

    public final String toString() {
        return ToString.builder((String)"GetGuardrailResponse").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("GuardrailId", (Object)this.guardrailId()).add("GuardrailArn", (Object)this.guardrailArn()).add("Version", (Object)this.version()).add("Status", (Object)this.statusAsString()).add("TopicPolicy", (Object)this.topicPolicy()).add("ContentPolicy", (Object)this.contentPolicy()).add("WordPolicy", (Object)this.wordPolicy()).add("SensitiveInformationPolicy", (Object)this.sensitiveInformationPolicy()).add("ContextualGroundingPolicy", (Object)this.contextualGroundingPolicy()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).add("StatusReasons", (Object)(this.statusReasons() == null ? null : "*** Sensitive Data Redacted ***")).add("FailureRecommendations", (Object)(this.failureRecommendations() == null ? null : "*** Sensitive Data Redacted ***")).add("BlockedInputMessaging", (Object)(this.blockedInputMessaging() == null ? null : "*** Sensitive Data Redacted ***")).add("BlockedOutputsMessaging", (Object)(this.blockedOutputsMessaging() == null ? null : "*** Sensitive Data Redacted ***")).add("KmsKeyArn", (Object)this.kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "guardrailId": {
                return Optional.ofNullable(clazz.cast(this.guardrailId()));
            }
            case "guardrailArn": {
                return Optional.ofNullable(clazz.cast(this.guardrailArn()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "topicPolicy": {
                return Optional.ofNullable(clazz.cast(this.topicPolicy()));
            }
            case "contentPolicy": {
                return Optional.ofNullable(clazz.cast(this.contentPolicy()));
            }
            case "wordPolicy": {
                return Optional.ofNullable(clazz.cast(this.wordPolicy()));
            }
            case "sensitiveInformationPolicy": {
                return Optional.ofNullable(clazz.cast(this.sensitiveInformationPolicy()));
            }
            case "contextualGroundingPolicy": {
                return Optional.ofNullable(clazz.cast(this.contextualGroundingPolicy()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "statusReasons": {
                return Optional.ofNullable(clazz.cast(this.statusReasons()));
            }
            case "failureRecommendations": {
                return Optional.ofNullable(clazz.cast(this.failureRecommendations()));
            }
            case "blockedInputMessaging": {
                return Optional.ofNullable(clazz.cast(this.blockedInputMessaging()));
            }
            case "blockedOutputsMessaging": {
                return Optional.ofNullable(clazz.cast(this.blockedOutputsMessaging()));
            }
            case "kmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("guardrailId", GUARDRAIL_ID_FIELD);
        map.put("guardrailArn", GUARDRAIL_ARN_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("topicPolicy", TOPIC_POLICY_FIELD);
        map.put("contentPolicy", CONTENT_POLICY_FIELD);
        map.put("wordPolicy", WORD_POLICY_FIELD);
        map.put("sensitiveInformationPolicy", SENSITIVE_INFORMATION_POLICY_FIELD);
        map.put("contextualGroundingPolicy", CONTEXTUAL_GROUNDING_POLICY_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("statusReasons", STATUS_REASONS_FIELD);
        map.put("failureRecommendations", FAILURE_RECOMMENDATIONS_FIELD);
        map.put("blockedInputMessaging", BLOCKED_INPUT_MESSAGING_FIELD);
        map.put("blockedOutputsMessaging", BLOCKED_OUTPUTS_MESSAGING_FIELD);
        map.put("kmsKeyArn", KMS_KEY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGuardrailResponse, T> g) {
        return obj -> g.apply((GetGuardrailResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String guardrailId;
        private String guardrailArn;
        private String version;
        private String status;
        private GuardrailTopicPolicy topicPolicy;
        private GuardrailContentPolicy contentPolicy;
        private GuardrailWordPolicy wordPolicy;
        private GuardrailSensitiveInformationPolicy sensitiveInformationPolicy;
        private GuardrailContextualGroundingPolicy contextualGroundingPolicy;
        private Instant createdAt;
        private Instant updatedAt;
        private List<String> statusReasons = DefaultSdkAutoConstructList.getInstance();
        private List<String> failureRecommendations = DefaultSdkAutoConstructList.getInstance();
        private String blockedInputMessaging;
        private String blockedOutputsMessaging;
        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGuardrailResponse model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.guardrailId(model.guardrailId);
            this.guardrailArn(model.guardrailArn);
            this.version(model.version);
            this.status(model.status);
            this.topicPolicy(model.topicPolicy);
            this.contentPolicy(model.contentPolicy);
            this.wordPolicy(model.wordPolicy);
            this.sensitiveInformationPolicy(model.sensitiveInformationPolicy);
            this.contextualGroundingPolicy(model.contextualGroundingPolicy);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
            this.statusReasons(model.statusReasons);
            this.failureRecommendations(model.failureRecommendations);
            this.blockedInputMessaging(model.blockedInputMessaging);
            this.blockedOutputsMessaging(model.blockedOutputsMessaging);
            this.kmsKeyArn(model.kmsKeyArn);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getGuardrailId() {
            return this.guardrailId;
        }

        public final void setGuardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
        }

        @Override
        public final Builder guardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
            return this;
        }

        public final String getGuardrailArn() {
            return this.guardrailArn;
        }

        public final void setGuardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
        }

        @Override
        public final Builder guardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GuardrailStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final GuardrailTopicPolicy.Builder getTopicPolicy() {
            return this.topicPolicy != null ? this.topicPolicy.toBuilder() : null;
        }

        public final void setTopicPolicy(GuardrailTopicPolicy.BuilderImpl topicPolicy) {
            this.topicPolicy = topicPolicy != null ? topicPolicy.build() : null;
        }

        @Override
        public final Builder topicPolicy(GuardrailTopicPolicy topicPolicy) {
            this.topicPolicy = topicPolicy;
            return this;
        }

        public final GuardrailContentPolicy.Builder getContentPolicy() {
            return this.contentPolicy != null ? this.contentPolicy.toBuilder() : null;
        }

        public final void setContentPolicy(GuardrailContentPolicy.BuilderImpl contentPolicy) {
            this.contentPolicy = contentPolicy != null ? contentPolicy.build() : null;
        }

        @Override
        public final Builder contentPolicy(GuardrailContentPolicy contentPolicy) {
            this.contentPolicy = contentPolicy;
            return this;
        }

        public final GuardrailWordPolicy.Builder getWordPolicy() {
            return this.wordPolicy != null ? this.wordPolicy.toBuilder() : null;
        }

        public final void setWordPolicy(GuardrailWordPolicy.BuilderImpl wordPolicy) {
            this.wordPolicy = wordPolicy != null ? wordPolicy.build() : null;
        }

        @Override
        public final Builder wordPolicy(GuardrailWordPolicy wordPolicy) {
            this.wordPolicy = wordPolicy;
            return this;
        }

        public final GuardrailSensitiveInformationPolicy.Builder getSensitiveInformationPolicy() {
            return this.sensitiveInformationPolicy != null ? this.sensitiveInformationPolicy.toBuilder() : null;
        }

        public final void setSensitiveInformationPolicy(GuardrailSensitiveInformationPolicy.BuilderImpl sensitiveInformationPolicy) {
            this.sensitiveInformationPolicy = sensitiveInformationPolicy != null ? sensitiveInformationPolicy.build() : null;
        }

        @Override
        public final Builder sensitiveInformationPolicy(GuardrailSensitiveInformationPolicy sensitiveInformationPolicy) {
            this.sensitiveInformationPolicy = sensitiveInformationPolicy;
            return this;
        }

        public final GuardrailContextualGroundingPolicy.Builder getContextualGroundingPolicy() {
            return this.contextualGroundingPolicy != null ? this.contextualGroundingPolicy.toBuilder() : null;
        }

        public final void setContextualGroundingPolicy(GuardrailContextualGroundingPolicy.BuilderImpl contextualGroundingPolicy) {
            this.contextualGroundingPolicy = contextualGroundingPolicy != null ? contextualGroundingPolicy.build() : null;
        }

        @Override
        public final Builder contextualGroundingPolicy(GuardrailContextualGroundingPolicy contextualGroundingPolicy) {
            this.contextualGroundingPolicy = contextualGroundingPolicy;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Collection<String> getStatusReasons() {
            if (this.statusReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.statusReasons;
        }

        public final void setStatusReasons(Collection<String> statusReasons) {
            this.statusReasons = GuardrailStatusReasonsCopier.copy(statusReasons);
        }

        @Override
        public final Builder statusReasons(Collection<String> statusReasons) {
            this.statusReasons = GuardrailStatusReasonsCopier.copy(statusReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusReasons(String ... statusReasons) {
            this.statusReasons(Arrays.asList(statusReasons));
            return this;
        }

        public final Collection<String> getFailureRecommendations() {
            if (this.failureRecommendations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureRecommendations;
        }

        public final void setFailureRecommendations(Collection<String> failureRecommendations) {
            this.failureRecommendations = GuardrailFailureRecommendationsCopier.copy(failureRecommendations);
        }

        @Override
        public final Builder failureRecommendations(Collection<String> failureRecommendations) {
            this.failureRecommendations = GuardrailFailureRecommendationsCopier.copy(failureRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureRecommendations(String ... failureRecommendations) {
            this.failureRecommendations(Arrays.asList(failureRecommendations));
            return this;
        }

        public final String getBlockedInputMessaging() {
            return this.blockedInputMessaging;
        }

        public final void setBlockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
        }

        @Override
        public final Builder blockedInputMessaging(String blockedInputMessaging) {
            this.blockedInputMessaging = blockedInputMessaging;
            return this;
        }

        public final String getBlockedOutputsMessaging() {
            return this.blockedOutputsMessaging;
        }

        public final void setBlockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
        }

        @Override
        public final Builder blockedOutputsMessaging(String blockedOutputsMessaging) {
            this.blockedOutputsMessaging = blockedOutputsMessaging;
            return this;
        }

        public final String getKmsKeyArn() {
            return this.kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public GetGuardrailResponse build() {
            return new GetGuardrailResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGuardrailResponse> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder guardrailId(String var1);

        public Builder guardrailArn(String var1);

        public Builder version(String var1);

        public Builder status(String var1);

        public Builder status(GuardrailStatus var1);

        public Builder topicPolicy(GuardrailTopicPolicy var1);

        default public Builder topicPolicy(Consumer<GuardrailTopicPolicy.Builder> topicPolicy) {
            return this.topicPolicy((GuardrailTopicPolicy)((GuardrailTopicPolicy.Builder)GuardrailTopicPolicy.builder().applyMutation(topicPolicy)).build());
        }

        public Builder contentPolicy(GuardrailContentPolicy var1);

        default public Builder contentPolicy(Consumer<GuardrailContentPolicy.Builder> contentPolicy) {
            return this.contentPolicy((GuardrailContentPolicy)((GuardrailContentPolicy.Builder)GuardrailContentPolicy.builder().applyMutation(contentPolicy)).build());
        }

        public Builder wordPolicy(GuardrailWordPolicy var1);

        default public Builder wordPolicy(Consumer<GuardrailWordPolicy.Builder> wordPolicy) {
            return this.wordPolicy((GuardrailWordPolicy)((GuardrailWordPolicy.Builder)GuardrailWordPolicy.builder().applyMutation(wordPolicy)).build());
        }

        public Builder sensitiveInformationPolicy(GuardrailSensitiveInformationPolicy var1);

        default public Builder sensitiveInformationPolicy(Consumer<GuardrailSensitiveInformationPolicy.Builder> sensitiveInformationPolicy) {
            return this.sensitiveInformationPolicy((GuardrailSensitiveInformationPolicy)((GuardrailSensitiveInformationPolicy.Builder)GuardrailSensitiveInformationPolicy.builder().applyMutation(sensitiveInformationPolicy)).build());
        }

        public Builder contextualGroundingPolicy(GuardrailContextualGroundingPolicy var1);

        default public Builder contextualGroundingPolicy(Consumer<GuardrailContextualGroundingPolicy.Builder> contextualGroundingPolicy) {
            return this.contextualGroundingPolicy((GuardrailContextualGroundingPolicy)((GuardrailContextualGroundingPolicy.Builder)GuardrailContextualGroundingPolicy.builder().applyMutation(contextualGroundingPolicy)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);

        public Builder statusReasons(Collection<String> var1);

        public Builder statusReasons(String ... var1);

        public Builder failureRecommendations(Collection<String> var1);

        public Builder failureRecommendations(String ... var1);

        public Builder blockedInputMessaging(String var1);

        public Builder blockedOutputsMessaging(String var1);

        public Builder kmsKeyArn(String var1);
    }
}

