/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.ListPromptRoutersRequest;
import software.amazon.awssdk.services.bedrock.model.ListPromptRoutersResponse;
import software.amazon.awssdk.services.bedrock.model.PromptRouterSummary;

public class ListPromptRoutersPublisher
implements SdkPublisher<ListPromptRoutersResponse> {
    private final BedrockAsyncClient client;
    private final ListPromptRoutersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPromptRoutersPublisher(BedrockAsyncClient client, ListPromptRoutersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPromptRoutersPublisher(BedrockAsyncClient client, ListPromptRoutersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPromptRoutersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPromptRoutersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PromptRouterSummary> promptRouterSummaries() {
        Function<ListPromptRoutersResponse, Iterator> getIterator = response -> {
            if (response != null && response.promptRouterSummaries() != null) {
                return response.promptRouterSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPromptRoutersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPromptRoutersResponseFetcher
    implements AsyncPageFetcher<ListPromptRoutersResponse> {
        private ListPromptRoutersResponseFetcher() {
        }

        public boolean hasNextPage(ListPromptRoutersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPromptRoutersResponse> nextPage(ListPromptRoutersResponse previousPage) {
            if (previousPage == null) {
                return ListPromptRoutersPublisher.this.client.listPromptRouters(ListPromptRoutersPublisher.this.firstRequest);
            }
            return ListPromptRoutersPublisher.this.client.listPromptRouters((ListPromptRoutersRequest)((Object)ListPromptRoutersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

