/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.EvaluationDatasetMetricConfig;
import software.amazon.awssdk.services.bedrock.model.EvaluationDatasetMetricConfigsCopier;
import software.amazon.awssdk.services.bedrock.model.EvaluatorModelConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedEvaluationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedEvaluationConfig> {
    private static final SdkField<List<EvaluationDatasetMetricConfig>> DATASET_METRIC_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("datasetMetricConfigs").getter(AutomatedEvaluationConfig.getter(AutomatedEvaluationConfig::datasetMetricConfigs)).setter(AutomatedEvaluationConfig.setter(Builder::datasetMetricConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetMetricConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluationDatasetMetricConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EvaluatorModelConfig> EVALUATOR_MODEL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("evaluatorModelConfig").getter(AutomatedEvaluationConfig.getter(AutomatedEvaluationConfig::evaluatorModelConfig)).setter(AutomatedEvaluationConfig.setter(Builder::evaluatorModelConfig)).constructor(EvaluatorModelConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatorModelConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_METRIC_CONFIGS_FIELD, EVALUATOR_MODEL_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedEvaluationConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<EvaluationDatasetMetricConfig> datasetMetricConfigs;
    private final EvaluatorModelConfig evaluatorModelConfig;

    private AutomatedEvaluationConfig(BuilderImpl builder) {
        this.datasetMetricConfigs = builder.datasetMetricConfigs;
        this.evaluatorModelConfig = builder.evaluatorModelConfig;
    }

    public final boolean hasDatasetMetricConfigs() {
        return this.datasetMetricConfigs != null && !(this.datasetMetricConfigs instanceof SdkAutoConstructList);
    }

    public final List<EvaluationDatasetMetricConfig> datasetMetricConfigs() {
        return this.datasetMetricConfigs;
    }

    public final EvaluatorModelConfig evaluatorModelConfig() {
        return this.evaluatorModelConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatasetMetricConfigs() ? this.datasetMetricConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorModelConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedEvaluationConfig)) {
            return false;
        }
        AutomatedEvaluationConfig other = (AutomatedEvaluationConfig)obj;
        return this.hasDatasetMetricConfigs() == other.hasDatasetMetricConfigs() && Objects.equals(this.datasetMetricConfigs(), other.datasetMetricConfigs()) && Objects.equals(this.evaluatorModelConfig(), other.evaluatorModelConfig());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedEvaluationConfig").add("DatasetMetricConfigs", this.hasDatasetMetricConfigs() ? this.datasetMetricConfigs() : null).add("EvaluatorModelConfig", (Object)this.evaluatorModelConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "datasetMetricConfigs": {
                return Optional.ofNullable(clazz.cast(this.datasetMetricConfigs()));
            }
            case "evaluatorModelConfig": {
                return Optional.ofNullable(clazz.cast(this.evaluatorModelConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datasetMetricConfigs", DATASET_METRIC_CONFIGS_FIELD);
        map.put("evaluatorModelConfig", EVALUATOR_MODEL_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedEvaluationConfig, T> g) {
        return obj -> g.apply((AutomatedEvaluationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EvaluationDatasetMetricConfig> datasetMetricConfigs = DefaultSdkAutoConstructList.getInstance();
        private EvaluatorModelConfig evaluatorModelConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedEvaluationConfig model) {
            this.datasetMetricConfigs(model.datasetMetricConfigs);
            this.evaluatorModelConfig(model.evaluatorModelConfig);
        }

        public final List<EvaluationDatasetMetricConfig.Builder> getDatasetMetricConfigs() {
            List<EvaluationDatasetMetricConfig.Builder> result = EvaluationDatasetMetricConfigsCopier.copyToBuilder(this.datasetMetricConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDatasetMetricConfigs(Collection<EvaluationDatasetMetricConfig.BuilderImpl> datasetMetricConfigs) {
            this.datasetMetricConfigs = EvaluationDatasetMetricConfigsCopier.copyFromBuilder(datasetMetricConfigs);
        }

        @Override
        public final Builder datasetMetricConfigs(Collection<EvaluationDatasetMetricConfig> datasetMetricConfigs) {
            this.datasetMetricConfigs = EvaluationDatasetMetricConfigsCopier.copy(datasetMetricConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetMetricConfigs(EvaluationDatasetMetricConfig ... datasetMetricConfigs) {
            this.datasetMetricConfigs(Arrays.asList(datasetMetricConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datasetMetricConfigs(Consumer<EvaluationDatasetMetricConfig.Builder> ... datasetMetricConfigs) {
            this.datasetMetricConfigs(Stream.of(datasetMetricConfigs).map(c -> (EvaluationDatasetMetricConfig)((EvaluationDatasetMetricConfig.Builder)EvaluationDatasetMetricConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EvaluatorModelConfig.Builder getEvaluatorModelConfig() {
            return this.evaluatorModelConfig != null ? this.evaluatorModelConfig.toBuilder() : null;
        }

        public final void setEvaluatorModelConfig(EvaluatorModelConfig.BuilderImpl evaluatorModelConfig) {
            this.evaluatorModelConfig = evaluatorModelConfig != null ? evaluatorModelConfig.build() : null;
        }

        @Override
        public final Builder evaluatorModelConfig(EvaluatorModelConfig evaluatorModelConfig) {
            this.evaluatorModelConfig = evaluatorModelConfig;
            return this;
        }

        public AutomatedEvaluationConfig build() {
            return new AutomatedEvaluationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedEvaluationConfig> {
        public Builder datasetMetricConfigs(Collection<EvaluationDatasetMetricConfig> var1);

        public Builder datasetMetricConfigs(EvaluationDatasetMetricConfig ... var1);

        public Builder datasetMetricConfigs(Consumer<EvaluationDatasetMetricConfig.Builder> ... var1);

        public Builder evaluatorModelConfig(EvaluatorModelConfig var1);

        default public Builder evaluatorModelConfig(Consumer<EvaluatorModelConfig.Builder> evaluatorModelConfig) {
            return this.evaluatorModelConfig((EvaluatorModelConfig)((EvaluatorModelConfig.Builder)EvaluatorModelConfig.builder().applyMutation(evaluatorModelConfig)).build());
        }
    }
}

