/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrock.model.BedrockEvaluatorModel;
import software.amazon.awssdk.services.bedrock.model.BedrockEvaluatorModelsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluatorModelConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluatorModelConfig> {
    private static final SdkField<List<BedrockEvaluatorModel>> BEDROCK_EVALUATOR_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("bedrockEvaluatorModels").getter(EvaluatorModelConfig.getter(EvaluatorModelConfig::bedrockEvaluatorModels)).setter(EvaluatorModelConfig.setter(Builder::bedrockEvaluatorModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockEvaluatorModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BedrockEvaluatorModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BEDROCK_EVALUATOR_MODELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluatorModelConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<BedrockEvaluatorModel> bedrockEvaluatorModels;
    private final Type type;

    private EvaluatorModelConfig(BuilderImpl builder) {
        this.bedrockEvaluatorModels = builder.bedrockEvaluatorModels;
        this.type = builder.type;
    }

    public final boolean hasBedrockEvaluatorModels() {
        return this.bedrockEvaluatorModels != null && !(this.bedrockEvaluatorModels instanceof SdkAutoConstructList);
    }

    public final List<BedrockEvaluatorModel> bedrockEvaluatorModels() {
        return this.bedrockEvaluatorModels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBedrockEvaluatorModels() ? this.bedrockEvaluatorModels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluatorModelConfig)) {
            return false;
        }
        EvaluatorModelConfig other = (EvaluatorModelConfig)obj;
        return this.hasBedrockEvaluatorModels() == other.hasBedrockEvaluatorModels() && Objects.equals(this.bedrockEvaluatorModels(), other.bedrockEvaluatorModels());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluatorModelConfig").add("BedrockEvaluatorModels", this.hasBedrockEvaluatorModels() ? this.bedrockEvaluatorModels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "bedrockEvaluatorModels": {
                return Optional.ofNullable(clazz.cast(this.bedrockEvaluatorModels()));
            }
        }
        return Optional.empty();
    }

    public static EvaluatorModelConfig fromBedrockEvaluatorModels(List<BedrockEvaluatorModel> bedrockEvaluatorModels) {
        return (EvaluatorModelConfig)EvaluatorModelConfig.builder().bedrockEvaluatorModels(bedrockEvaluatorModels).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<BedrockEvaluatorModel>>> map = new HashMap<String, SdkField<List<BedrockEvaluatorModel>>>();
        map.put("bedrockEvaluatorModels", BEDROCK_EVALUATOR_MODELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluatorModelConfig, T> g) {
        return obj -> g.apply((EvaluatorModelConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        BEDROCK_EVALUATOR_MODELS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<BedrockEvaluatorModel> bedrockEvaluatorModels = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluatorModelConfig model) {
            this.bedrockEvaluatorModels(model.bedrockEvaluatorModels);
        }

        public final List<BedrockEvaluatorModel.Builder> getBedrockEvaluatorModels() {
            List<BedrockEvaluatorModel.Builder> result = BedrockEvaluatorModelsCopier.copyToBuilder(this.bedrockEvaluatorModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBedrockEvaluatorModels(Collection<BedrockEvaluatorModel.BuilderImpl> bedrockEvaluatorModels) {
            List<BedrockEvaluatorModel> oldValue = this.bedrockEvaluatorModels;
            this.bedrockEvaluatorModels = BedrockEvaluatorModelsCopier.copyFromBuilder(bedrockEvaluatorModels);
            this.handleUnionValueChange(Type.BEDROCK_EVALUATOR_MODELS, oldValue, this.bedrockEvaluatorModels);
        }

        @Override
        public final Builder bedrockEvaluatorModels(Collection<BedrockEvaluatorModel> bedrockEvaluatorModels) {
            List<BedrockEvaluatorModel> oldValue = this.bedrockEvaluatorModels;
            this.bedrockEvaluatorModels = BedrockEvaluatorModelsCopier.copy(bedrockEvaluatorModels);
            this.handleUnionValueChange(Type.BEDROCK_EVALUATOR_MODELS, oldValue, this.bedrockEvaluatorModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bedrockEvaluatorModels(BedrockEvaluatorModel ... bedrockEvaluatorModels) {
            this.bedrockEvaluatorModels(Arrays.asList(bedrockEvaluatorModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bedrockEvaluatorModels(Consumer<BedrockEvaluatorModel.Builder> ... bedrockEvaluatorModels) {
            this.bedrockEvaluatorModels(Stream.of(bedrockEvaluatorModels).map(c -> (BedrockEvaluatorModel)((BedrockEvaluatorModel.Builder)BedrockEvaluatorModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EvaluatorModelConfig build() {
            return new EvaluatorModelConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluatorModelConfig> {
        public Builder bedrockEvaluatorModels(Collection<BedrockEvaluatorModel> var1);

        public Builder bedrockEvaluatorModels(BedrockEvaluatorModel ... var1);

        public Builder bedrockEvaluatorModels(Consumer<BedrockEvaluatorModel.Builder> ... var1);
    }
}

