/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MarketplaceModelEndpointSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MarketplaceModelEndpointSummary> {
    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpointArn").getter(MarketplaceModelEndpointSummary.getter(MarketplaceModelEndpointSummary::endpointArn)).setter(MarketplaceModelEndpointSummary.setter(Builder::endpointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointArn").build()}).build();
    private static final SdkField<String> MODEL_SOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelSourceIdentifier").getter(MarketplaceModelEndpointSummary.getter(MarketplaceModelEndpointSummary::modelSourceIdentifier)).setter(MarketplaceModelEndpointSummary.setter(Builder::modelSourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSourceIdentifier").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(MarketplaceModelEndpointSummary.getter(MarketplaceModelEndpointSummary::statusAsString)).setter(MarketplaceModelEndpointSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(MarketplaceModelEndpointSummary.getter(MarketplaceModelEndpointSummary::statusMessage)).setter(MarketplaceModelEndpointSummary.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(MarketplaceModelEndpointSummary.getter(MarketplaceModelEndpointSummary::createdAt)).setter(MarketplaceModelEndpointSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(MarketplaceModelEndpointSummary.getter(MarketplaceModelEndpointSummary::updatedAt)).setter(MarketplaceModelEndpointSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_ARN_FIELD, MODEL_SOURCE_IDENTIFIER_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MarketplaceModelEndpointSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String endpointArn;
    private final String modelSourceIdentifier;
    private final String status;
    private final String statusMessage;
    private final Instant createdAt;
    private final Instant updatedAt;

    private MarketplaceModelEndpointSummary(BuilderImpl builder) {
        this.endpointArn = builder.endpointArn;
        this.modelSourceIdentifier = builder.modelSourceIdentifier;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String endpointArn() {
        return this.endpointArn;
    }

    public final String modelSourceIdentifier() {
        return this.modelSourceIdentifier;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MarketplaceModelEndpointSummary)) {
            return false;
        }
        MarketplaceModelEndpointSummary other = (MarketplaceModelEndpointSummary)obj;
        return Objects.equals(this.endpointArn(), other.endpointArn()) && Objects.equals(this.modelSourceIdentifier(), other.modelSourceIdentifier()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"MarketplaceModelEndpointSummary").add("EndpointArn", (Object)this.endpointArn()).add("ModelSourceIdentifier", (Object)this.modelSourceIdentifier()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "endpointArn": {
                return Optional.ofNullable(clazz.cast(this.endpointArn()));
            }
            case "modelSourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.modelSourceIdentifier()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("endpointArn", ENDPOINT_ARN_FIELD);
        map.put("modelSourceIdentifier", MODEL_SOURCE_IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MarketplaceModelEndpointSummary, T> g) {
        return obj -> g.apply((MarketplaceModelEndpointSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String endpointArn;
        private String modelSourceIdentifier;
        private String status;
        private String statusMessage;
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(MarketplaceModelEndpointSummary model) {
            this.endpointArn(model.endpointArn);
            this.modelSourceIdentifier(model.modelSourceIdentifier);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getEndpointArn() {
            return this.endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final String getModelSourceIdentifier() {
            return this.modelSourceIdentifier;
        }

        public final void setModelSourceIdentifier(String modelSourceIdentifier) {
            this.modelSourceIdentifier = modelSourceIdentifier;
        }

        @Override
        public final Builder modelSourceIdentifier(String modelSourceIdentifier) {
            this.modelSourceIdentifier = modelSourceIdentifier;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public MarketplaceModelEndpointSummary build() {
            return new MarketplaceModelEndpointSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MarketplaceModelEndpointSummary> {
        public Builder endpointArn(String var1);

        public Builder modelSourceIdentifier(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder statusMessage(String var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

