/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.GuardrailContextualGroundingFilterType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailContextualGroundingFilterConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailContextualGroundingFilterConfig> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GuardrailContextualGroundingFilterConfig.getter(GuardrailContextualGroundingFilterConfig::typeAsString)).setter(GuardrailContextualGroundingFilterConfig.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("threshold").getter(GuardrailContextualGroundingFilterConfig.getter(GuardrailContextualGroundingFilterConfig::threshold)).setter(GuardrailContextualGroundingFilterConfig.setter(Builder::threshold)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, THRESHOLD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailContextualGroundingFilterConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Double threshold;

    private GuardrailContextualGroundingFilterConfig(BuilderImpl builder) {
        this.type = builder.type;
        this.threshold = builder.threshold;
    }

    public final GuardrailContextualGroundingFilterType type() {
        return GuardrailContextualGroundingFilterType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final Double threshold() {
        return this.threshold;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.threshold());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailContextualGroundingFilterConfig)) {
            return false;
        }
        GuardrailContextualGroundingFilterConfig other = (GuardrailContextualGroundingFilterConfig)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.threshold(), other.threshold());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailContextualGroundingFilterConfig").add("Type", (Object)this.typeAsString()).add("Threshold", (Object)this.threshold()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "threshold": {
                return Optional.ofNullable(clazz.cast(this.threshold()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("threshold", THRESHOLD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailContextualGroundingFilterConfig, T> g) {
        return obj -> g.apply((GuardrailContextualGroundingFilterConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Double threshold;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailContextualGroundingFilterConfig model) {
            this.type(model.type);
            this.threshold(model.threshold);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GuardrailContextualGroundingFilterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Double getThreshold() {
            return this.threshold;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        public GuardrailContextualGroundingFilterConfig build() {
            return new GuardrailContextualGroundingFilterConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailContextualGroundingFilterConfig> {
        public Builder type(String var1);

        public Builder type(GuardrailContextualGroundingFilterType var1);

        public Builder threshold(Double var1);
    }
}

