/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrock.model.AutomatedEvaluationConfig;
import software.amazon.awssdk.services.bedrock.model.HumanEvaluationConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluationConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluationConfig> {
    private static final SdkField<AutomatedEvaluationConfig> AUTOMATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("automated").getter(EvaluationConfig.getter(EvaluationConfig::automated)).setter(EvaluationConfig.setter(Builder::automated)).constructor(AutomatedEvaluationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automated").build()}).build();
    private static final SdkField<HumanEvaluationConfig> HUMAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("human").getter(EvaluationConfig.getter(EvaluationConfig::human)).setter(EvaluationConfig.setter(Builder::human)).constructor(HumanEvaluationConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("human").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATED_FIELD, HUMAN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluationConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AutomatedEvaluationConfig automated;
    private final HumanEvaluationConfig human;
    private final Type type;

    private EvaluationConfig(BuilderImpl builder) {
        this.automated = builder.automated;
        this.human = builder.human;
        this.type = builder.type;
    }

    public final AutomatedEvaluationConfig automated() {
        return this.automated;
    }

    public final HumanEvaluationConfig human() {
        return this.human;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automated());
        hashCode = 31 * hashCode + Objects.hashCode(this.human());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluationConfig)) {
            return false;
        }
        EvaluationConfig other = (EvaluationConfig)obj;
        return Objects.equals(this.automated(), other.automated()) && Objects.equals(this.human(), other.human());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluationConfig").add("Automated", (Object)this.automated()).add("Human", (Object)this.human()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "automated": {
                return Optional.ofNullable(clazz.cast(this.automated()));
            }
            case "human": {
                return Optional.ofNullable(clazz.cast(this.human()));
            }
        }
        return Optional.empty();
    }

    public static EvaluationConfig fromAutomated(AutomatedEvaluationConfig automated) {
        return (EvaluationConfig)EvaluationConfig.builder().automated(automated).build();
    }

    public static EvaluationConfig fromAutomated(Consumer<AutomatedEvaluationConfig.Builder> automated) {
        AutomatedEvaluationConfig.Builder builder = AutomatedEvaluationConfig.builder();
        automated.accept(builder);
        return EvaluationConfig.fromAutomated((AutomatedEvaluationConfig)builder.build());
    }

    public static EvaluationConfig fromHuman(HumanEvaluationConfig human) {
        return (EvaluationConfig)EvaluationConfig.builder().human(human).build();
    }

    public static EvaluationConfig fromHuman(Consumer<HumanEvaluationConfig.Builder> human) {
        HumanEvaluationConfig.Builder builder = HumanEvaluationConfig.builder();
        human.accept(builder);
        return EvaluationConfig.fromHuman((HumanEvaluationConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("automated", AUTOMATED_FIELD);
        map.put("human", HUMAN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluationConfig, T> g) {
        return obj -> g.apply((EvaluationConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        AUTOMATED,
        HUMAN,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AutomatedEvaluationConfig automated;
        private HumanEvaluationConfig human;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluationConfig model) {
            this.automated(model.automated);
            this.human(model.human);
        }

        public final AutomatedEvaluationConfig.Builder getAutomated() {
            return this.automated != null ? this.automated.toBuilder() : null;
        }

        public final void setAutomated(AutomatedEvaluationConfig.BuilderImpl automated) {
            AutomatedEvaluationConfig oldValue = this.automated;
            this.automated = automated != null ? automated.build() : null;
            this.handleUnionValueChange(Type.AUTOMATED, oldValue, this.automated);
        }

        @Override
        public final Builder automated(AutomatedEvaluationConfig automated) {
            AutomatedEvaluationConfig oldValue = this.automated;
            this.automated = automated;
            this.handleUnionValueChange(Type.AUTOMATED, oldValue, this.automated);
            return this;
        }

        public final HumanEvaluationConfig.Builder getHuman() {
            return this.human != null ? this.human.toBuilder() : null;
        }

        public final void setHuman(HumanEvaluationConfig.BuilderImpl human) {
            HumanEvaluationConfig oldValue = this.human;
            this.human = human != null ? human.build() : null;
            this.handleUnionValueChange(Type.HUMAN, oldValue, this.human);
        }

        @Override
        public final Builder human(HumanEvaluationConfig human) {
            HumanEvaluationConfig oldValue = this.human;
            this.human = human;
            this.handleUnionValueChange(Type.HUMAN, oldValue, this.human);
            return this;
        }

        public EvaluationConfig build() {
            return new EvaluationConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluationConfig> {
        public Builder automated(AutomatedEvaluationConfig var1);

        default public Builder automated(Consumer<AutomatedEvaluationConfig.Builder> automated) {
            return this.automated((AutomatedEvaluationConfig)((AutomatedEvaluationConfig.Builder)AutomatedEvaluationConfig.builder().applyMutation(automated)).build());
        }

        public Builder human(HumanEvaluationConfig var1);

        default public Builder human(Consumer<HumanEvaluationConfig.Builder> human) {
            return this.human((HumanEvaluationConfig)((HumanEvaluationConfig.Builder)HumanEvaluationConfig.builder().applyMutation(human)).build());
        }
    }
}

