/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.InvocationLogsConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingDataConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingDataConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3Uri").getter(TrainingDataConfig.getter(TrainingDataConfig::s3Uri)).setter(TrainingDataConfig.setter(Builder::s3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()}).build();
    private static final SdkField<InvocationLogsConfig> INVOCATION_LOGS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("invocationLogsConfig").getter(TrainingDataConfig.getter(TrainingDataConfig::invocationLogsConfig)).setter(TrainingDataConfig.setter(Builder::invocationLogsConfig)).constructor(InvocationLogsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationLogsConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD, INVOCATION_LOGS_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("s3Uri", S3_URI_FIELD);
            this.put("invocationLogsConfig", INVOCATION_LOGS_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String s3Uri;
    private final InvocationLogsConfig invocationLogsConfig;

    private TrainingDataConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.invocationLogsConfig = builder.invocationLogsConfig;
    }

    public final String s3Uri() {
        return this.s3Uri;
    }

    public final InvocationLogsConfig invocationLogsConfig() {
        return this.invocationLogsConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationLogsConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingDataConfig)) {
            return false;
        }
        TrainingDataConfig other = (TrainingDataConfig)obj;
        return Objects.equals(this.s3Uri(), other.s3Uri()) && Objects.equals(this.invocationLogsConfig(), other.invocationLogsConfig());
    }

    public final String toString() {
        return ToString.builder((String)"TrainingDataConfig").add("S3Uri", (Object)this.s3Uri()).add("InvocationLogsConfig", (Object)this.invocationLogsConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3Uri": {
                return Optional.ofNullable(clazz.cast(this.s3Uri()));
            }
            case "invocationLogsConfig": {
                return Optional.ofNullable(clazz.cast(this.invocationLogsConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<TrainingDataConfig, T> g) {
        return obj -> g.apply((TrainingDataConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3Uri;
        private InvocationLogsConfig invocationLogsConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingDataConfig model) {
            this.s3Uri(model.s3Uri);
            this.invocationLogsConfig(model.invocationLogsConfig);
        }

        public final String getS3Uri() {
            return this.s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final InvocationLogsConfig.Builder getInvocationLogsConfig() {
            return this.invocationLogsConfig != null ? this.invocationLogsConfig.toBuilder() : null;
        }

        public final void setInvocationLogsConfig(InvocationLogsConfig.BuilderImpl invocationLogsConfig) {
            this.invocationLogsConfig = invocationLogsConfig != null ? invocationLogsConfig.build() : null;
        }

        @Override
        public final Builder invocationLogsConfig(InvocationLogsConfig invocationLogsConfig) {
            this.invocationLogsConfig = invocationLogsConfig;
            return this;
        }

        public TrainingDataConfig build() {
            return new TrainingDataConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingDataConfig> {
        public Builder s3Uri(String var1);

        public Builder invocationLogsConfig(InvocationLogsConfig var1);

        default public Builder invocationLogsConfig(Consumer<InvocationLogsConfig.Builder> invocationLogsConfig) {
            return this.invocationLogsConfig((InvocationLogsConfig)((InvocationLogsConfig.Builder)InvocationLogsConfig.builder().applyMutation(invocationLogsConfig)).build());
        }
    }
}

