/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.PromptRouterSummariesCopier;
import software.amazon.awssdk.services.bedrock.model.PromptRouterSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPromptRoutersResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, ListPromptRoutersResponse> {
    private static final SdkField<List<PromptRouterSummary>> PROMPT_ROUTER_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("promptRouterSummaries").getter(ListPromptRoutersResponse.getter(ListPromptRoutersResponse::promptRouterSummaries)).setter(ListPromptRoutersResponse.setter(Builder::promptRouterSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptRouterSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PromptRouterSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPromptRoutersResponse.getter(ListPromptRoutersResponse::nextToken)).setter(ListPromptRoutersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_ROUTER_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("promptRouterSummaries", PROMPT_ROUTER_SUMMARIES_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<PromptRouterSummary> promptRouterSummaries;
    private final String nextToken;

    private ListPromptRoutersResponse(BuilderImpl builder) {
        super(builder);
        this.promptRouterSummaries = builder.promptRouterSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPromptRouterSummaries() {
        return this.promptRouterSummaries != null && !(this.promptRouterSummaries instanceof SdkAutoConstructList);
    }

    public final List<PromptRouterSummary> promptRouterSummaries() {
        return this.promptRouterSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPromptRouterSummaries() ? this.promptRouterSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPromptRoutersResponse)) {
            return false;
        }
        ListPromptRoutersResponse other = (ListPromptRoutersResponse)((Object)obj);
        return this.hasPromptRouterSummaries() == other.hasPromptRouterSummaries() && Objects.equals(this.promptRouterSummaries(), other.promptRouterSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPromptRoutersResponse").add("PromptRouterSummaries", this.hasPromptRouterSummaries() ? this.promptRouterSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "promptRouterSummaries": {
                return Optional.ofNullable(clazz.cast(this.promptRouterSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPromptRoutersResponse, T> g) {
        return obj -> g.apply((ListPromptRoutersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private List<PromptRouterSummary> promptRouterSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPromptRoutersResponse model) {
            super(model);
            this.promptRouterSummaries(model.promptRouterSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<PromptRouterSummary.Builder> getPromptRouterSummaries() {
            List<PromptRouterSummary.Builder> result = PromptRouterSummariesCopier.copyToBuilder(this.promptRouterSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPromptRouterSummaries(Collection<PromptRouterSummary.BuilderImpl> promptRouterSummaries) {
            this.promptRouterSummaries = PromptRouterSummariesCopier.copyFromBuilder(promptRouterSummaries);
        }

        @Override
        public final Builder promptRouterSummaries(Collection<PromptRouterSummary> promptRouterSummaries) {
            this.promptRouterSummaries = PromptRouterSummariesCopier.copy(promptRouterSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder promptRouterSummaries(PromptRouterSummary ... promptRouterSummaries) {
            this.promptRouterSummaries(Arrays.asList(promptRouterSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder promptRouterSummaries(Consumer<PromptRouterSummary.Builder> ... promptRouterSummaries) {
            this.promptRouterSummaries(Stream.of(promptRouterSummaries).map(c -> (PromptRouterSummary)((PromptRouterSummary.Builder)PromptRouterSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPromptRoutersResponse build() {
            return new ListPromptRoutersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPromptRoutersResponse> {
        public Builder promptRouterSummaries(Collection<PromptRouterSummary> var1);

        public Builder promptRouterSummaries(PromptRouterSummary ... var1);

        public Builder promptRouterSummaries(Consumer<PromptRouterSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

