/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.LoggingConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutModelInvocationLoggingConfigurationRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, PutModelInvocationLoggingConfigurationRequest> {
    private static final SdkField<LoggingConfig> LOGGING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("loggingConfig").getter(PutModelInvocationLoggingConfigurationRequest.getter(PutModelInvocationLoggingConfigurationRequest::loggingConfig)).setter(PutModelInvocationLoggingConfigurationRequest.setter(Builder::loggingConfig)).constructor(LoggingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGGING_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("loggingConfig", LOGGING_CONFIG_FIELD);
        }
    });
    private final LoggingConfig loggingConfig;

    private PutModelInvocationLoggingConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.loggingConfig = builder.loggingConfig;
    }

    public final LoggingConfig loggingConfig() {
        return this.loggingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutModelInvocationLoggingConfigurationRequest)) {
            return false;
        }
        PutModelInvocationLoggingConfigurationRequest other = (PutModelInvocationLoggingConfigurationRequest)((Object)obj);
        return Objects.equals(this.loggingConfig(), other.loggingConfig());
    }

    public final String toString() {
        return ToString.builder((String)"PutModelInvocationLoggingConfigurationRequest").add("LoggingConfig", (Object)this.loggingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "loggingConfig": {
                return Optional.ofNullable(clazz.cast(this.loggingConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PutModelInvocationLoggingConfigurationRequest, T> g) {
        return obj -> g.apply((PutModelInvocationLoggingConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private LoggingConfig loggingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PutModelInvocationLoggingConfigurationRequest model) {
            super(model);
            this.loggingConfig(model.loggingConfig);
        }

        public final LoggingConfig.Builder getLoggingConfig() {
            return this.loggingConfig != null ? this.loggingConfig.toBuilder() : null;
        }

        public final void setLoggingConfig(LoggingConfig.BuilderImpl loggingConfig) {
            this.loggingConfig = loggingConfig != null ? loggingConfig.build() : null;
        }

        @Override
        public final Builder loggingConfig(LoggingConfig loggingConfig) {
            this.loggingConfig = loggingConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutModelInvocationLoggingConfigurationRequest build() {
            return new PutModelInvocationLoggingConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutModelInvocationLoggingConfigurationRequest> {
        public Builder loggingConfig(LoggingConfig var1);

        default public Builder loggingConfig(Consumer<LoggingConfig.Builder> loggingConfig) {
            return this.loggingConfig((LoggingConfig)((LoggingConfig.Builder)LoggingConfig.builder().applyMutation(loggingConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

