/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.ExternalSourcesRetrieveAndGenerateConfiguration;
import software.amazon.awssdk.services.bedrock.model.KnowledgeBaseRetrieveAndGenerateConfiguration;
import software.amazon.awssdk.services.bedrock.model.RetrieveAndGenerateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrieveAndGenerateConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RetrieveAndGenerateConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(RetrieveAndGenerateConfiguration.getter(RetrieveAndGenerateConfiguration::typeAsString)).setter(RetrieveAndGenerateConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<KnowledgeBaseRetrieveAndGenerateConfiguration> KNOWLEDGE_BASE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("knowledgeBaseConfiguration").getter(RetrieveAndGenerateConfiguration.getter(RetrieveAndGenerateConfiguration::knowledgeBaseConfiguration)).setter(RetrieveAndGenerateConfiguration.setter(Builder::knowledgeBaseConfiguration)).constructor(KnowledgeBaseRetrieveAndGenerateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseConfiguration").build()}).build();
    private static final SdkField<ExternalSourcesRetrieveAndGenerateConfiguration> EXTERNAL_SOURCES_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("externalSourcesConfiguration").getter(RetrieveAndGenerateConfiguration.getter(RetrieveAndGenerateConfiguration::externalSourcesConfiguration)).setter(RetrieveAndGenerateConfiguration.setter(Builder::externalSourcesConfiguration)).constructor(ExternalSourcesRetrieveAndGenerateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalSourcesConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, KNOWLEDGE_BASE_CONFIGURATION_FIELD, EXTERNAL_SOURCES_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("type", TYPE_FIELD);
            this.put("knowledgeBaseConfiguration", KNOWLEDGE_BASE_CONFIGURATION_FIELD);
            this.put("externalSourcesConfiguration", EXTERNAL_SOURCES_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final KnowledgeBaseRetrieveAndGenerateConfiguration knowledgeBaseConfiguration;
    private final ExternalSourcesRetrieveAndGenerateConfiguration externalSourcesConfiguration;

    private RetrieveAndGenerateConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.knowledgeBaseConfiguration = builder.knowledgeBaseConfiguration;
        this.externalSourcesConfiguration = builder.externalSourcesConfiguration;
    }

    public final RetrieveAndGenerateType type() {
        return RetrieveAndGenerateType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final KnowledgeBaseRetrieveAndGenerateConfiguration knowledgeBaseConfiguration() {
        return this.knowledgeBaseConfiguration;
    }

    public final ExternalSourcesRetrieveAndGenerateConfiguration externalSourcesConfiguration() {
        return this.externalSourcesConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalSourcesConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveAndGenerateConfiguration)) {
            return false;
        }
        RetrieveAndGenerateConfiguration other = (RetrieveAndGenerateConfiguration)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.knowledgeBaseConfiguration(), other.knowledgeBaseConfiguration()) && Objects.equals(this.externalSourcesConfiguration(), other.externalSourcesConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"RetrieveAndGenerateConfiguration").add("Type", (Object)this.typeAsString()).add("KnowledgeBaseConfiguration", (Object)this.knowledgeBaseConfiguration()).add("ExternalSourcesConfiguration", (Object)this.externalSourcesConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "knowledgeBaseConfiguration": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseConfiguration()));
            }
            case "externalSourcesConfiguration": {
                return Optional.ofNullable(clazz.cast(this.externalSourcesConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RetrieveAndGenerateConfiguration, T> g) {
        return obj -> g.apply((RetrieveAndGenerateConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private KnowledgeBaseRetrieveAndGenerateConfiguration knowledgeBaseConfiguration;
        private ExternalSourcesRetrieveAndGenerateConfiguration externalSourcesConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveAndGenerateConfiguration model) {
            this.type(model.type);
            this.knowledgeBaseConfiguration(model.knowledgeBaseConfiguration);
            this.externalSourcesConfiguration(model.externalSourcesConfiguration);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(RetrieveAndGenerateType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final KnowledgeBaseRetrieveAndGenerateConfiguration.Builder getKnowledgeBaseConfiguration() {
            return this.knowledgeBaseConfiguration != null ? this.knowledgeBaseConfiguration.toBuilder() : null;
        }

        public final void setKnowledgeBaseConfiguration(KnowledgeBaseRetrieveAndGenerateConfiguration.BuilderImpl knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration != null ? knowledgeBaseConfiguration.build() : null;
        }

        @Override
        public final Builder knowledgeBaseConfiguration(KnowledgeBaseRetrieveAndGenerateConfiguration knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration;
            return this;
        }

        public final ExternalSourcesRetrieveAndGenerateConfiguration.Builder getExternalSourcesConfiguration() {
            return this.externalSourcesConfiguration != null ? this.externalSourcesConfiguration.toBuilder() : null;
        }

        public final void setExternalSourcesConfiguration(ExternalSourcesRetrieveAndGenerateConfiguration.BuilderImpl externalSourcesConfiguration) {
            this.externalSourcesConfiguration = externalSourcesConfiguration != null ? externalSourcesConfiguration.build() : null;
        }

        @Override
        public final Builder externalSourcesConfiguration(ExternalSourcesRetrieveAndGenerateConfiguration externalSourcesConfiguration) {
            this.externalSourcesConfiguration = externalSourcesConfiguration;
            return this;
        }

        public RetrieveAndGenerateConfiguration build() {
            return new RetrieveAndGenerateConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RetrieveAndGenerateConfiguration> {
        public Builder type(String var1);

        public Builder type(RetrieveAndGenerateType var1);

        public Builder knowledgeBaseConfiguration(KnowledgeBaseRetrieveAndGenerateConfiguration var1);

        default public Builder knowledgeBaseConfiguration(Consumer<KnowledgeBaseRetrieveAndGenerateConfiguration.Builder> knowledgeBaseConfiguration) {
            return this.knowledgeBaseConfiguration((KnowledgeBaseRetrieveAndGenerateConfiguration)((KnowledgeBaseRetrieveAndGenerateConfiguration.Builder)KnowledgeBaseRetrieveAndGenerateConfiguration.builder().applyMutation(knowledgeBaseConfiguration)).build());
        }

        public Builder externalSourcesConfiguration(ExternalSourcesRetrieveAndGenerateConfiguration var1);

        default public Builder externalSourcesConfiguration(Consumer<ExternalSourcesRetrieveAndGenerateConfiguration.Builder> externalSourcesConfiguration) {
            return this.externalSourcesConfiguration((ExternalSourcesRetrieveAndGenerateConfiguration)((ExternalSourcesRetrieveAndGenerateConfiguration.Builder)ExternalSourcesRetrieveAndGenerateConfiguration.builder().applyMutation(externalSourcesConfiguration)).build());
        }
    }
}

