/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ProvisionedModelStatus {
    CREATING("Creating"),
    IN_SERVICE("InService"),
    UPDATING("Updating"),
    FAILED("Failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ProvisionedModelStatus> VALUE_MAP;
    private final String value;

    private ProvisionedModelStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProvisionedModelStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProvisionedModelStatus> knownValues() {
        EnumSet<ProvisionedModelStatus> knownValues = EnumSet.allOf(ProvisionedModelStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ProvisionedModelStatus.class, ProvisionedModelStatus::toString);
    }
}

