/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.GuardrailTopicExamplesCopier;
import software.amazon.awssdk.services.bedrock.model.GuardrailTopicType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailTopic
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailTopic> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GuardrailTopic.getter(GuardrailTopic::name)).setter(GuardrailTopic.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("definition").getter(GuardrailTopic.getter(GuardrailTopic::definition)).setter(GuardrailTopic.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<List<String>> EXAMPLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("examples").getter(GuardrailTopic.getter(GuardrailTopic::examples)).setter(GuardrailTopic.setter(Builder::examples)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("examples").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GuardrailTopic.getter(GuardrailTopic::typeAsString)).setter(GuardrailTopic.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DEFINITION_FIELD, EXAMPLES_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("definition", DEFINITION_FIELD);
            this.put("examples", EXAMPLES_FIELD);
            this.put("type", TYPE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String definition;
    private final List<String> examples;
    private final String type;

    private GuardrailTopic(BuilderImpl builder) {
        this.name = builder.name;
        this.definition = builder.definition;
        this.examples = builder.examples;
        this.type = builder.type;
    }

    public final String name() {
        return this.name;
    }

    public final String definition() {
        return this.definition;
    }

    public final boolean hasExamples() {
        return this.examples != null && !(this.examples instanceof SdkAutoConstructList);
    }

    public final List<String> examples() {
        return this.examples;
    }

    public final GuardrailTopicType type() {
        return GuardrailTopicType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExamples() ? this.examples() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailTopic)) {
            return false;
        }
        GuardrailTopic other = (GuardrailTopic)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.definition(), other.definition()) && this.hasExamples() == other.hasExamples() && Objects.equals(this.examples(), other.examples()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailTopic").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Definition", (Object)(this.definition() == null ? null : "*** Sensitive Data Redacted ***")).add("Examples", (Object)(this.examples() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "examples": {
                return Optional.ofNullable(clazz.cast(this.examples()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailTopic, T> g) {
        return obj -> g.apply((GuardrailTopic)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String definition;
        private List<String> examples = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailTopic model) {
            this.name(model.name);
            this.definition(model.definition);
            this.examples(model.examples);
            this.type(model.type);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDefinition() {
            return this.definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final Collection<String> getExamples() {
            if (this.examples instanceof SdkAutoConstructList) {
                return null;
            }
            return this.examples;
        }

        public final void setExamples(Collection<String> examples) {
            this.examples = GuardrailTopicExamplesCopier.copy(examples);
        }

        @Override
        public final Builder examples(Collection<String> examples) {
            this.examples = GuardrailTopicExamplesCopier.copy(examples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder examples(String ... examples) {
            this.examples(Arrays.asList(examples));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GuardrailTopicType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public GuardrailTopic build() {
            return new GuardrailTopic(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailTopic> {
        public Builder name(String var1);

        public Builder definition(String var1);

        public Builder examples(Collection<String> var1);

        public Builder examples(String ... var1);

        public Builder type(String var1);

        public Builder type(GuardrailTopicType var1);
    }
}

