/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.InferenceProfileSummary;
import software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesRequest;
import software.amazon.awssdk.services.bedrock.model.ListInferenceProfilesResponse;

public class ListInferenceProfilesIterable
implements SdkIterable<ListInferenceProfilesResponse> {
    private final BedrockClient client;
    private final ListInferenceProfilesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInferenceProfilesIterable(BedrockClient client, ListInferenceProfilesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInferenceProfilesResponseFetcher();
    }

    public Iterator<ListInferenceProfilesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InferenceProfileSummary> inferenceProfileSummaries() {
        Function<ListInferenceProfilesResponse, Iterator> getIterator = response -> {
            if (response != null && response.inferenceProfileSummaries() != null) {
                return response.inferenceProfileSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInferenceProfilesResponseFetcher
    implements SyncPageFetcher<ListInferenceProfilesResponse> {
        private ListInferenceProfilesResponseFetcher() {
        }

        public boolean hasNextPage(ListInferenceProfilesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInferenceProfilesResponse nextPage(ListInferenceProfilesResponse previousPage) {
            if (previousPage == null) {
                return ListInferenceProfilesIterable.this.client.listInferenceProfiles(ListInferenceProfilesIterable.this.firstRequest);
            }
            return ListInferenceProfilesIterable.this.client.listInferenceProfiles((ListInferenceProfilesRequest)((Object)ListInferenceProfilesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

