/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ByteContentDoc
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ByteContentDoc> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(ByteContentDoc.getter(ByteContentDoc::identifier)).setter(ByteContentDoc.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(ByteContentDoc.getter(ByteContentDoc::contentType)).setter(ByteContentDoc.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()}).build();
    private static final SdkField<SdkBytes> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("data").getter(ByteContentDoc.getter(ByteContentDoc::data)).setter(ByteContentDoc.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, CONTENT_TYPE_FIELD, DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("identifier", IDENTIFIER_FIELD);
            this.put("contentType", CONTENT_TYPE_FIELD);
            this.put("data", DATA_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String identifier;
    private final String contentType;
    private final SdkBytes data;

    private ByteContentDoc(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.contentType = builder.contentType;
        this.data = builder.data;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final SdkBytes data() {
        return this.data;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ByteContentDoc)) {
            return false;
        }
        ByteContentDoc other = (ByteContentDoc)obj;
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.data(), other.data());
    }

    public final String toString() {
        return ToString.builder((String)"ByteContentDoc").add("Identifier", (Object)(this.identifier() == null ? null : "*** Sensitive Data Redacted ***")).add("ContentType", (Object)this.contentType()).add("Data", (Object)(this.data() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ByteContentDoc, T> g) {
        return obj -> g.apply((ByteContentDoc)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identifier;
        private String contentType;
        private SdkBytes data;

        private BuilderImpl() {
        }

        private BuilderImpl(ByteContentDoc model) {
            this.identifier(model.identifier);
            this.contentType(model.contentType);
            this.data(model.data);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final ByteBuffer getData() {
            return this.data == null ? null : this.data.asByteBuffer();
        }

        public final void setData(ByteBuffer data) {
            this.data(data == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)data));
        }

        @Override
        public final Builder data(SdkBytes data) {
            this.data = data;
            return this;
        }

        public ByteContentDoc build() {
            return new ByteContentDoc(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ByteContentDoc> {
        public Builder identifier(String var1);

        public Builder contentType(String var1);

        public Builder data(SdkBytes var1);
    }
}

