/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.ModelDataSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetImportedModelResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, GetImportedModelResponse> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArn").getter(GetImportedModelResponse.getter(GetImportedModelResponse::modelArn)).setter(GetImportedModelResponse.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()}).build();
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelName").getter(GetImportedModelResponse.getter(GetImportedModelResponse::modelName)).setter(GetImportedModelResponse.setter(Builder::modelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelName").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobName").getter(GetImportedModelResponse.getter(GetImportedModelResponse::jobName)).setter(GetImportedModelResponse.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()}).build();
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(GetImportedModelResponse.getter(GetImportedModelResponse::jobArn)).setter(GetImportedModelResponse.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<ModelDataSource> MODEL_DATA_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelDataSource").getter(GetImportedModelResponse.getter(GetImportedModelResponse::modelDataSource)).setter(GetImportedModelResponse.setter(Builder::modelDataSource)).constructor(ModelDataSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelDataSource").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetImportedModelResponse.getter(GetImportedModelResponse::creationTime)).setter(GetImportedModelResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> MODEL_ARCHITECTURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArchitecture").getter(GetImportedModelResponse.getter(GetImportedModelResponse::modelArchitecture)).setter(GetImportedModelResponse.setter(Builder::modelArchitecture)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArchitecture").build()}).build();
    private static final SdkField<String> MODEL_KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelKmsKeyArn").getter(GetImportedModelResponse.getter(GetImportedModelResponse::modelKmsKeyArn)).setter(GetImportedModelResponse.setter(Builder::modelKmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelKmsKeyArn").build()}).build();
    private static final SdkField<Boolean> INSTRUCT_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("instructSupported").getter(GetImportedModelResponse.getter(GetImportedModelResponse::instructSupported)).setter(GetImportedModelResponse.setter(Builder::instructSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instructSupported").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD, MODEL_NAME_FIELD, JOB_NAME_FIELD, JOB_ARN_FIELD, MODEL_DATA_SOURCE_FIELD, CREATION_TIME_FIELD, MODEL_ARCHITECTURE_FIELD, MODEL_KMS_KEY_ARN_FIELD, INSTRUCT_SUPPORTED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("modelArn", MODEL_ARN_FIELD);
            this.put("modelName", MODEL_NAME_FIELD);
            this.put("jobName", JOB_NAME_FIELD);
            this.put("jobArn", JOB_ARN_FIELD);
            this.put("modelDataSource", MODEL_DATA_SOURCE_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("modelArchitecture", MODEL_ARCHITECTURE_FIELD);
            this.put("modelKmsKeyArn", MODEL_KMS_KEY_ARN_FIELD);
            this.put("instructSupported", INSTRUCT_SUPPORTED_FIELD);
        }
    });
    private final String modelArn;
    private final String modelName;
    private final String jobName;
    private final String jobArn;
    private final ModelDataSource modelDataSource;
    private final Instant creationTime;
    private final String modelArchitecture;
    private final String modelKmsKeyArn;
    private final Boolean instructSupported;

    private GetImportedModelResponse(BuilderImpl builder) {
        super(builder);
        this.modelArn = builder.modelArn;
        this.modelName = builder.modelName;
        this.jobName = builder.jobName;
        this.jobArn = builder.jobArn;
        this.modelDataSource = builder.modelDataSource;
        this.creationTime = builder.creationTime;
        this.modelArchitecture = builder.modelArchitecture;
        this.modelKmsKeyArn = builder.modelKmsKeyArn;
        this.instructSupported = builder.instructSupported;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final String modelName() {
        return this.modelName;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final ModelDataSource modelDataSource() {
        return this.modelDataSource;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String modelArchitecture() {
        return this.modelArchitecture;
    }

    public final String modelKmsKeyArn() {
        return this.modelKmsKeyArn;
    }

    public final Boolean instructSupported() {
        return this.instructSupported;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelDataSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArchitecture());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instructSupported());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetImportedModelResponse)) {
            return false;
        }
        GetImportedModelResponse other = (GetImportedModelResponse)((Object)obj);
        return Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.modelName(), other.modelName()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.modelDataSource(), other.modelDataSource()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.modelArchitecture(), other.modelArchitecture()) && Objects.equals(this.modelKmsKeyArn(), other.modelKmsKeyArn()) && Objects.equals(this.instructSupported(), other.instructSupported());
    }

    public final String toString() {
        return ToString.builder((String)"GetImportedModelResponse").add("ModelArn", (Object)this.modelArn()).add("ModelName", (Object)this.modelName()).add("JobName", (Object)this.jobName()).add("JobArn", (Object)this.jobArn()).add("ModelDataSource", (Object)this.modelDataSource()).add("CreationTime", (Object)this.creationTime()).add("ModelArchitecture", (Object)this.modelArchitecture()).add("ModelKmsKeyArn", (Object)this.modelKmsKeyArn()).add("InstructSupported", (Object)this.instructSupported()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "modelName": {
                return Optional.ofNullable(clazz.cast(this.modelName()));
            }
            case "jobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "modelDataSource": {
                return Optional.ofNullable(clazz.cast(this.modelDataSource()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "modelArchitecture": {
                return Optional.ofNullable(clazz.cast(this.modelArchitecture()));
            }
            case "modelKmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.modelKmsKeyArn()));
            }
            case "instructSupported": {
                return Optional.ofNullable(clazz.cast(this.instructSupported()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetImportedModelResponse, T> g) {
        return obj -> g.apply((GetImportedModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String modelArn;
        private String modelName;
        private String jobName;
        private String jobArn;
        private ModelDataSource modelDataSource;
        private Instant creationTime;
        private String modelArchitecture;
        private String modelKmsKeyArn;
        private Boolean instructSupported;

        private BuilderImpl() {
        }

        private BuilderImpl(GetImportedModelResponse model) {
            super(model);
            this.modelArn(model.modelArn);
            this.modelName(model.modelName);
            this.jobName(model.jobName);
            this.jobArn(model.jobArn);
            this.modelDataSource(model.modelDataSource);
            this.creationTime(model.creationTime);
            this.modelArchitecture(model.modelArchitecture);
            this.modelKmsKeyArn(model.modelKmsKeyArn);
            this.instructSupported(model.instructSupported);
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getModelName() {
            return this.modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final ModelDataSource.Builder getModelDataSource() {
            return this.modelDataSource != null ? this.modelDataSource.toBuilder() : null;
        }

        public final void setModelDataSource(ModelDataSource.BuilderImpl modelDataSource) {
            this.modelDataSource = modelDataSource != null ? modelDataSource.build() : null;
        }

        @Override
        public final Builder modelDataSource(ModelDataSource modelDataSource) {
            this.modelDataSource = modelDataSource;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getModelArchitecture() {
            return this.modelArchitecture;
        }

        public final void setModelArchitecture(String modelArchitecture) {
            this.modelArchitecture = modelArchitecture;
        }

        @Override
        public final Builder modelArchitecture(String modelArchitecture) {
            this.modelArchitecture = modelArchitecture;
            return this;
        }

        public final String getModelKmsKeyArn() {
            return this.modelKmsKeyArn;
        }

        public final void setModelKmsKeyArn(String modelKmsKeyArn) {
            this.modelKmsKeyArn = modelKmsKeyArn;
        }

        @Override
        public final Builder modelKmsKeyArn(String modelKmsKeyArn) {
            this.modelKmsKeyArn = modelKmsKeyArn;
            return this;
        }

        public final Boolean getInstructSupported() {
            return this.instructSupported;
        }

        public final void setInstructSupported(Boolean instructSupported) {
            this.instructSupported = instructSupported;
        }

        @Override
        public final Builder instructSupported(Boolean instructSupported) {
            this.instructSupported = instructSupported;
            return this;
        }

        @Override
        public GetImportedModelResponse build() {
            return new GetImportedModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetImportedModelResponse> {
        public Builder modelArn(String var1);

        public Builder modelName(String var1);

        public Builder jobName(String var1);

        public Builder jobArn(String var1);

        public Builder modelDataSource(ModelDataSource var1);

        default public Builder modelDataSource(Consumer<ModelDataSource.Builder> modelDataSource) {
            return this.modelDataSource((ModelDataSource)((ModelDataSource.Builder)ModelDataSource.builder().applyMutation(modelDataSource)).build());
        }

        public Builder creationTime(Instant var1);

        public Builder modelArchitecture(String var1);

        public Builder modelKmsKeyArn(String var1);

        public Builder instructSupported(Boolean var1);
    }
}

