/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.Tag;
import software.amazon.awssdk.services.bedrock.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateModelCopyJobRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, CreateModelCopyJobRequest> {
    private static final SdkField<String> SOURCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceModelArn").getter(CreateModelCopyJobRequest.getter(CreateModelCopyJobRequest::sourceModelArn)).setter(CreateModelCopyJobRequest.setter(Builder::sourceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceModelArn").build()}).build();
    private static final SdkField<String> TARGET_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetModelName").getter(CreateModelCopyJobRequest.getter(CreateModelCopyJobRequest::targetModelName)).setter(CreateModelCopyJobRequest.setter(Builder::targetModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetModelName").build()}).build();
    private static final SdkField<String> MODEL_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelKmsKeyId").getter(CreateModelCopyJobRequest.getter(CreateModelCopyJobRequest::modelKmsKeyId)).setter(CreateModelCopyJobRequest.setter(Builder::modelKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelKmsKeyId").build()}).build();
    private static final SdkField<List<Tag>> TARGET_MODEL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetModelTags").getter(CreateModelCopyJobRequest.getter(CreateModelCopyJobRequest::targetModelTags)).setter(CreateModelCopyJobRequest.setter(Builder::targetModelTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetModelTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateModelCopyJobRequest.getter(CreateModelCopyJobRequest::clientRequestToken)).setter(CreateModelCopyJobRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_MODEL_ARN_FIELD, TARGET_MODEL_NAME_FIELD, MODEL_KMS_KEY_ID_FIELD, TARGET_MODEL_TAGS_FIELD, CLIENT_REQUEST_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("sourceModelArn", SOURCE_MODEL_ARN_FIELD);
            this.put("targetModelName", TARGET_MODEL_NAME_FIELD);
            this.put("modelKmsKeyId", MODEL_KMS_KEY_ID_FIELD);
            this.put("targetModelTags", TARGET_MODEL_TAGS_FIELD);
            this.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        }
    });
    private final String sourceModelArn;
    private final String targetModelName;
    private final String modelKmsKeyId;
    private final List<Tag> targetModelTags;
    private final String clientRequestToken;

    private CreateModelCopyJobRequest(BuilderImpl builder) {
        super(builder);
        this.sourceModelArn = builder.sourceModelArn;
        this.targetModelName = builder.targetModelName;
        this.modelKmsKeyId = builder.modelKmsKeyId;
        this.targetModelTags = builder.targetModelTags;
        this.clientRequestToken = builder.clientRequestToken;
    }

    public final String sourceModelArn() {
        return this.sourceModelArn;
    }

    public final String targetModelName() {
        return this.targetModelName;
    }

    public final String modelKmsKeyId() {
        return this.modelKmsKeyId;
    }

    public final boolean hasTargetModelTags() {
        return this.targetModelTags != null && !(this.targetModelTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> targetModelTags() {
        return this.targetModelTags;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetModelTags() ? this.targetModelTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateModelCopyJobRequest)) {
            return false;
        }
        CreateModelCopyJobRequest other = (CreateModelCopyJobRequest)((Object)obj);
        return Objects.equals(this.sourceModelArn(), other.sourceModelArn()) && Objects.equals(this.targetModelName(), other.targetModelName()) && Objects.equals(this.modelKmsKeyId(), other.modelKmsKeyId()) && this.hasTargetModelTags() == other.hasTargetModelTags() && Objects.equals(this.targetModelTags(), other.targetModelTags()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateModelCopyJobRequest").add("SourceModelArn", (Object)this.sourceModelArn()).add("TargetModelName", (Object)this.targetModelName()).add("ModelKmsKeyId", (Object)this.modelKmsKeyId()).add("TargetModelTags", this.hasTargetModelTags() ? this.targetModelTags() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceModelArn": {
                return Optional.ofNullable(clazz.cast(this.sourceModelArn()));
            }
            case "targetModelName": {
                return Optional.ofNullable(clazz.cast(this.targetModelName()));
            }
            case "modelKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.modelKmsKeyId()));
            }
            case "targetModelTags": {
                return Optional.ofNullable(clazz.cast(this.targetModelTags()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateModelCopyJobRequest, T> g) {
        return obj -> g.apply((CreateModelCopyJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String sourceModelArn;
        private String targetModelName;
        private String modelKmsKeyId;
        private List<Tag> targetModelTags = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateModelCopyJobRequest model) {
            super(model);
            this.sourceModelArn(model.sourceModelArn);
            this.targetModelName(model.targetModelName);
            this.modelKmsKeyId(model.modelKmsKeyId);
            this.targetModelTags(model.targetModelTags);
            this.clientRequestToken(model.clientRequestToken);
        }

        public final String getSourceModelArn() {
            return this.sourceModelArn;
        }

        public final void setSourceModelArn(String sourceModelArn) {
            this.sourceModelArn = sourceModelArn;
        }

        @Override
        public final Builder sourceModelArn(String sourceModelArn) {
            this.sourceModelArn = sourceModelArn;
            return this;
        }

        public final String getTargetModelName() {
            return this.targetModelName;
        }

        public final void setTargetModelName(String targetModelName) {
            this.targetModelName = targetModelName;
        }

        @Override
        public final Builder targetModelName(String targetModelName) {
            this.targetModelName = targetModelName;
            return this;
        }

        public final String getModelKmsKeyId() {
            return this.modelKmsKeyId;
        }

        public final void setModelKmsKeyId(String modelKmsKeyId) {
            this.modelKmsKeyId = modelKmsKeyId;
        }

        @Override
        public final Builder modelKmsKeyId(String modelKmsKeyId) {
            this.modelKmsKeyId = modelKmsKeyId;
            return this;
        }

        public final List<Tag.Builder> getTargetModelTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.targetModelTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetModelTags(Collection<Tag.BuilderImpl> targetModelTags) {
            this.targetModelTags = TagListCopier.copyFromBuilder(targetModelTags);
        }

        @Override
        public final Builder targetModelTags(Collection<Tag> targetModelTags) {
            this.targetModelTags = TagListCopier.copy(targetModelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetModelTags(Tag ... targetModelTags) {
            this.targetModelTags(Arrays.asList(targetModelTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetModelTags(Consumer<Tag.Builder> ... targetModelTags) {
            this.targetModelTags(Stream.of(targetModelTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateModelCopyJobRequest build() {
            return new CreateModelCopyJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateModelCopyJobRequest> {
        public Builder sourceModelArn(String var1);

        public Builder targetModelName(String var1);

        public Builder modelKmsKeyId(String var1);

        public Builder targetModelTags(Collection<Tag> var1);

        public Builder targetModelTags(Tag ... var1);

        public Builder targetModelTags(Consumer<Tag.Builder> ... var1);

        public Builder clientRequestToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

