/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobSummariesCopier;
import software.amazon.awssdk.services.bedrock.model.ModelCustomizationJobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelCustomizationJobsResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, ListModelCustomizationJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListModelCustomizationJobsResponse.getter(ListModelCustomizationJobsResponse::nextToken)).setter(ListModelCustomizationJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ModelCustomizationJobSummary>> MODEL_CUSTOMIZATION_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modelCustomizationJobSummaries").getter(ListModelCustomizationJobsResponse.getter(ListModelCustomizationJobsResponse::modelCustomizationJobSummaries)).setter(ListModelCustomizationJobsResponse.setter(Builder::modelCustomizationJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelCustomizationJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelCustomizationJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MODEL_CUSTOMIZATION_JOB_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("modelCustomizationJobSummaries", MODEL_CUSTOMIZATION_JOB_SUMMARIES_FIELD);
        }
    });
    private final String nextToken;
    private final List<ModelCustomizationJobSummary> modelCustomizationJobSummaries;

    private ListModelCustomizationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.modelCustomizationJobSummaries = builder.modelCustomizationJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasModelCustomizationJobSummaries() {
        return this.modelCustomizationJobSummaries != null && !(this.modelCustomizationJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<ModelCustomizationJobSummary> modelCustomizationJobSummaries() {
        return this.modelCustomizationJobSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelCustomizationJobSummaries() ? this.modelCustomizationJobSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelCustomizationJobsResponse)) {
            return false;
        }
        ListModelCustomizationJobsResponse other = (ListModelCustomizationJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasModelCustomizationJobSummaries() == other.hasModelCustomizationJobSummaries() && Objects.equals(this.modelCustomizationJobSummaries(), other.modelCustomizationJobSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelCustomizationJobsResponse").add("NextToken", (Object)this.nextToken()).add("ModelCustomizationJobSummaries", this.hasModelCustomizationJobSummaries() ? this.modelCustomizationJobSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "modelCustomizationJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.modelCustomizationJobSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListModelCustomizationJobsResponse, T> g) {
        return obj -> g.apply((ListModelCustomizationJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ModelCustomizationJobSummary> modelCustomizationJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelCustomizationJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.modelCustomizationJobSummaries(model.modelCustomizationJobSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ModelCustomizationJobSummary.Builder> getModelCustomizationJobSummaries() {
            List<ModelCustomizationJobSummary.Builder> result = ModelCustomizationJobSummariesCopier.copyToBuilder(this.modelCustomizationJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelCustomizationJobSummaries(Collection<ModelCustomizationJobSummary.BuilderImpl> modelCustomizationJobSummaries) {
            this.modelCustomizationJobSummaries = ModelCustomizationJobSummariesCopier.copyFromBuilder(modelCustomizationJobSummaries);
        }

        @Override
        public final Builder modelCustomizationJobSummaries(Collection<ModelCustomizationJobSummary> modelCustomizationJobSummaries) {
            this.modelCustomizationJobSummaries = ModelCustomizationJobSummariesCopier.copy(modelCustomizationJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelCustomizationJobSummaries(ModelCustomizationJobSummary ... modelCustomizationJobSummaries) {
            this.modelCustomizationJobSummaries(Arrays.asList(modelCustomizationJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelCustomizationJobSummaries(Consumer<ModelCustomizationJobSummary.Builder> ... modelCustomizationJobSummaries) {
            this.modelCustomizationJobSummaries(Stream.of(modelCustomizationJobSummaries).map(c -> (ModelCustomizationJobSummary)((ModelCustomizationJobSummary.Builder)ModelCustomizationJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListModelCustomizationJobsResponse build() {
            return new ListModelCustomizationJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelCustomizationJobsResponse> {
        public Builder nextToken(String var1);

        public Builder modelCustomizationJobSummaries(Collection<ModelCustomizationJobSummary> var1);

        public Builder modelCustomizationJobSummaries(ModelCustomizationJobSummary ... var1);

        public Builder modelCustomizationJobSummaries(Consumer<ModelCustomizationJobSummary.Builder> ... var1);
    }
}

