/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.InferenceProfileModelSource;
import software.amazon.awssdk.services.bedrock.model.Tag;
import software.amazon.awssdk.services.bedrock.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInferenceProfileRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, CreateInferenceProfileRequest> {
    private static final SdkField<String> INFERENCE_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inferenceProfileName").getter(CreateInferenceProfileRequest.getter(CreateInferenceProfileRequest::inferenceProfileName)).setter(CreateInferenceProfileRequest.setter(Builder::inferenceProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceProfileName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateInferenceProfileRequest.getter(CreateInferenceProfileRequest::description)).setter(CreateInferenceProfileRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientRequestToken").getter(CreateInferenceProfileRequest.getter(CreateInferenceProfileRequest::clientRequestToken)).setter(CreateInferenceProfileRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<InferenceProfileModelSource> MODEL_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("modelSource").getter(CreateInferenceProfileRequest.getter(CreateInferenceProfileRequest::modelSource)).setter(CreateInferenceProfileRequest.setter(Builder::modelSource)).constructor(InferenceProfileModelSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSource").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateInferenceProfileRequest.getter(CreateInferenceProfileRequest::tags)).setter(CreateInferenceProfileRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_PROFILE_NAME_FIELD, DESCRIPTION_FIELD, CLIENT_REQUEST_TOKEN_FIELD, MODEL_SOURCE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("inferenceProfileName", INFERENCE_PROFILE_NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
            this.put("modelSource", MODEL_SOURCE_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String inferenceProfileName;
    private final String description;
    private final String clientRequestToken;
    private final InferenceProfileModelSource modelSource;
    private final List<Tag> tags;

    private CreateInferenceProfileRequest(BuilderImpl builder) {
        super(builder);
        this.inferenceProfileName = builder.inferenceProfileName;
        this.description = builder.description;
        this.clientRequestToken = builder.clientRequestToken;
        this.modelSource = builder.modelSource;
        this.tags = builder.tags;
    }

    public final String inferenceProfileName() {
        return this.inferenceProfileName;
    }

    public final String description() {
        return this.description;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final InferenceProfileModelSource modelSource() {
        return this.modelSource;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInferenceProfileRequest)) {
            return false;
        }
        CreateInferenceProfileRequest other = (CreateInferenceProfileRequest)((Object)obj);
        return Objects.equals(this.inferenceProfileName(), other.inferenceProfileName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.modelSource(), other.modelSource()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInferenceProfileRequest").add("InferenceProfileName", (Object)this.inferenceProfileName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientRequestToken", (Object)this.clientRequestToken()).add("ModelSource", (Object)this.modelSource()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inferenceProfileName": {
                return Optional.ofNullable(clazz.cast(this.inferenceProfileName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "clientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "modelSource": {
                return Optional.ofNullable(clazz.cast(this.modelSource()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateInferenceProfileRequest, T> g) {
        return obj -> g.apply((CreateInferenceProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String inferenceProfileName;
        private String description;
        private String clientRequestToken;
        private InferenceProfileModelSource modelSource;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInferenceProfileRequest model) {
            super(model);
            this.inferenceProfileName(model.inferenceProfileName);
            this.description(model.description);
            this.clientRequestToken(model.clientRequestToken);
            this.modelSource(model.modelSource);
            this.tags(model.tags);
        }

        public final String getInferenceProfileName() {
            return this.inferenceProfileName;
        }

        public final void setInferenceProfileName(String inferenceProfileName) {
            this.inferenceProfileName = inferenceProfileName;
        }

        @Override
        public final Builder inferenceProfileName(String inferenceProfileName) {
            this.inferenceProfileName = inferenceProfileName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final InferenceProfileModelSource.Builder getModelSource() {
            return this.modelSource != null ? this.modelSource.toBuilder() : null;
        }

        public final void setModelSource(InferenceProfileModelSource.BuilderImpl modelSource) {
            this.modelSource = modelSource != null ? modelSource.build() : null;
        }

        @Override
        public final Builder modelSource(InferenceProfileModelSource modelSource) {
            this.modelSource = modelSource;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInferenceProfileRequest build() {
            return new CreateInferenceProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInferenceProfileRequest> {
        public Builder inferenceProfileName(String var1);

        public Builder description(String var1);

        public Builder clientRequestToken(String var1);

        public Builder modelSource(InferenceProfileModelSource var1);

        default public Builder modelSource(Consumer<InferenceProfileModelSource.Builder> modelSource) {
            return this.modelSource((InferenceProfileModelSource)((InferenceProfileModelSource.Builder)InferenceProfileModelSource.builder().applyMutation(modelSource)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

