/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3InputFormat {
    JSONL("JSONL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3InputFormat> VALUE_MAP;
    private final String value;

    private S3InputFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3InputFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3InputFormat> knownValues() {
        EnumSet<S3InputFormat> knownValues = EnumSet.allOf(S3InputFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3InputFormat.class, S3InputFormat::toString);
    }
}

