/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.services.bedrock.model.SortModelsBy;
import software.amazon.awssdk.services.bedrock.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomModelsRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, ListCustomModelsRequest> {
    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTimeBefore").getter(ListCustomModelsRequest.getter(ListCustomModelsRequest::creationTimeBefore)).setter(ListCustomModelsRequest.setter(Builder::creationTimeBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("creationTimeBefore").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTimeAfter").getter(ListCustomModelsRequest.getter(ListCustomModelsRequest::creationTimeAfter)).setter(ListCustomModelsRequest.setter(Builder::creationTimeAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("creationTimeAfter").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nameContains").getter(ListCustomModelsRequest.getter(ListCustomModelsRequest::nameContains)).setter(ListCustomModelsRequest.setter(Builder::nameContains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nameContains").build()}).build();
    private static final SdkField<String> BASE_MODEL_ARN_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baseModelArnEquals").getter(ListCustomModelsRequest.getter(ListCustomModelsRequest::baseModelArnEquals)).setter(ListCustomModelsRequest.setter(Builder::baseModelArnEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("baseModelArnEquals").build()}).build();
    private static final SdkField<String> FOUNDATION_MODEL_ARN_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("foundationModelArnEquals").getter(ListCustomModelsRequest.getter(ListCustomModelsRequest::foundationModelArnEquals)).setter(ListCustomModelsRequest.setter(Builder::foundationModelArnEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("foundationModelArnEquals").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListCustomModelsRequest.getter(ListCustomModelsRequest::maxResults)).setter(ListCustomModelsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCustomModelsRequest.getter(ListCustomModelsRequest::nextToken)).setter(ListCustomModelsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortBy").getter(ListCustomModelsRequest.getter(ListCustomModelsRequest::sortByAsString)).setter(ListCustomModelsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sortOrder").getter(ListCustomModelsRequest.getter(ListCustomModelsRequest::sortOrderAsString)).setter(ListCustomModelsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("sortOrder").build()}).build();
    private static final SdkField<Boolean> IS_OWNED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isOwned").getter(ListCustomModelsRequest.getter(ListCustomModelsRequest::isOwned)).setter(ListCustomModelsRequest.setter(Builder::isOwned)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("isOwned").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_BEFORE_FIELD, CREATION_TIME_AFTER_FIELD, NAME_CONTAINS_FIELD, BASE_MODEL_ARN_EQUALS_FIELD, FOUNDATION_MODEL_ARN_EQUALS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, IS_OWNED_FIELD));
    private final Instant creationTimeBefore;
    private final Instant creationTimeAfter;
    private final String nameContains;
    private final String baseModelArnEquals;
    private final String foundationModelArnEquals;
    private final Integer maxResults;
    private final String nextToken;
    private final String sortBy;
    private final String sortOrder;
    private final Boolean isOwned;

    private ListCustomModelsRequest(BuilderImpl builder) {
        super(builder);
        this.creationTimeBefore = builder.creationTimeBefore;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.nameContains = builder.nameContains;
        this.baseModelArnEquals = builder.baseModelArnEquals;
        this.foundationModelArnEquals = builder.foundationModelArnEquals;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.isOwned = builder.isOwned;
    }

    public final Instant creationTimeBefore() {
        return this.creationTimeBefore;
    }

    public final Instant creationTimeAfter() {
        return this.creationTimeAfter;
    }

    public final String nameContains() {
        return this.nameContains;
    }

    public final String baseModelArnEquals() {
        return this.baseModelArnEquals;
    }

    public final String foundationModelArnEquals() {
        return this.foundationModelArnEquals;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final SortModelsBy sortBy() {
        return SortModelsBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final Boolean isOwned() {
        return this.isOwned;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseModelArnEquals());
        hashCode = 31 * hashCode + Objects.hashCode(this.foundationModelArnEquals());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.isOwned());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomModelsRequest)) {
            return false;
        }
        ListCustomModelsRequest other = (ListCustomModelsRequest)((Object)obj);
        return Objects.equals(this.creationTimeBefore(), other.creationTimeBefore()) && Objects.equals(this.creationTimeAfter(), other.creationTimeAfter()) && Objects.equals(this.nameContains(), other.nameContains()) && Objects.equals(this.baseModelArnEquals(), other.baseModelArnEquals()) && Objects.equals(this.foundationModelArnEquals(), other.foundationModelArnEquals()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.isOwned(), other.isOwned());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomModelsRequest").add("CreationTimeBefore", (Object)this.creationTimeBefore()).add("CreationTimeAfter", (Object)this.creationTimeAfter()).add("NameContains", (Object)this.nameContains()).add("BaseModelArnEquals", (Object)this.baseModelArnEquals()).add("FoundationModelArnEquals", (Object)this.foundationModelArnEquals()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("IsOwned", (Object)this.isOwned()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "creationTimeBefore": {
                return Optional.ofNullable(clazz.cast(this.creationTimeBefore()));
            }
            case "creationTimeAfter": {
                return Optional.ofNullable(clazz.cast(this.creationTimeAfter()));
            }
            case "nameContains": {
                return Optional.ofNullable(clazz.cast(this.nameContains()));
            }
            case "baseModelArnEquals": {
                return Optional.ofNullable(clazz.cast(this.baseModelArnEquals()));
            }
            case "foundationModelArnEquals": {
                return Optional.ofNullable(clazz.cast(this.foundationModelArnEquals()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "sortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "isOwned": {
                return Optional.ofNullable(clazz.cast(this.isOwned()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCustomModelsRequest, T> g) {
        return obj -> g.apply((ListCustomModelsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private Instant creationTimeBefore;
        private Instant creationTimeAfter;
        private String nameContains;
        private String baseModelArnEquals;
        private String foundationModelArnEquals;
        private Integer maxResults;
        private String nextToken;
        private String sortBy;
        private String sortOrder;
        private Boolean isOwned;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomModelsRequest model) {
            super(model);
            this.creationTimeBefore(model.creationTimeBefore);
            this.creationTimeAfter(model.creationTimeAfter);
            this.nameContains(model.nameContains);
            this.baseModelArnEquals(model.baseModelArnEquals);
            this.foundationModelArnEquals(model.foundationModelArnEquals);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.isOwned(model.isOwned);
        }

        public final Instant getCreationTimeBefore() {
            return this.creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return this.creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final String getNameContains() {
            return this.nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final String getBaseModelArnEquals() {
            return this.baseModelArnEquals;
        }

        public final void setBaseModelArnEquals(String baseModelArnEquals) {
            this.baseModelArnEquals = baseModelArnEquals;
        }

        @Override
        public final Builder baseModelArnEquals(String baseModelArnEquals) {
            this.baseModelArnEquals = baseModelArnEquals;
            return this;
        }

        public final String getFoundationModelArnEquals() {
            return this.foundationModelArnEquals;
        }

        public final void setFoundationModelArnEquals(String foundationModelArnEquals) {
            this.foundationModelArnEquals = foundationModelArnEquals;
        }

        @Override
        public final Builder foundationModelArnEquals(String foundationModelArnEquals) {
            this.foundationModelArnEquals = foundationModelArnEquals;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortModelsBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final Boolean getIsOwned() {
            return this.isOwned;
        }

        public final void setIsOwned(Boolean isOwned) {
            this.isOwned = isOwned;
        }

        @Override
        public final Builder isOwned(Boolean isOwned) {
            this.isOwned = isOwned;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCustomModelsRequest build() {
            return new ListCustomModelsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCustomModelsRequest> {
        public Builder creationTimeBefore(Instant var1);

        public Builder creationTimeAfter(Instant var1);

        public Builder nameContains(String var1);

        public Builder baseModelArnEquals(String var1);

        public Builder foundationModelArnEquals(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder sortBy(String var1);

        public Builder sortBy(SortModelsBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder isOwned(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

