/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.ModelCopyJobStatus;
import software.amazon.awssdk.services.bedrock.model.Tag;
import software.amazon.awssdk.services.bedrock.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetModelCopyJobResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, GetModelCopyJobResponse> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobArn").getter(GetModelCopyJobResponse.getter(GetModelCopyJobResponse::jobArn)).setter(GetModelCopyJobResponse.setter(Builder::jobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetModelCopyJobResponse.getter(GetModelCopyJobResponse::statusAsString)).setter(GetModelCopyJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetModelCopyJobResponse.getter(GetModelCopyJobResponse::creationTime)).setter(GetModelCopyJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TARGET_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetModelArn").getter(GetModelCopyJobResponse.getter(GetModelCopyJobResponse::targetModelArn)).setter(GetModelCopyJobResponse.setter(Builder::targetModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetModelArn").build()}).build();
    private static final SdkField<String> TARGET_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetModelName").getter(GetModelCopyJobResponse.getter(GetModelCopyJobResponse::targetModelName)).setter(GetModelCopyJobResponse.setter(Builder::targetModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetModelName").build()}).build();
    private static final SdkField<String> SOURCE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceAccountId").getter(GetModelCopyJobResponse.getter(GetModelCopyJobResponse::sourceAccountId)).setter(GetModelCopyJobResponse.setter(Builder::sourceAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAccountId").build()}).build();
    private static final SdkField<String> SOURCE_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceModelArn").getter(GetModelCopyJobResponse.getter(GetModelCopyJobResponse::sourceModelArn)).setter(GetModelCopyJobResponse.setter(Builder::sourceModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceModelArn").build()}).build();
    private static final SdkField<String> TARGET_MODEL_KMS_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetModelKmsKeyArn").getter(GetModelCopyJobResponse.getter(GetModelCopyJobResponse::targetModelKmsKeyArn)).setter(GetModelCopyJobResponse.setter(Builder::targetModelKmsKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetModelKmsKeyArn").build()}).build();
    private static final SdkField<List<Tag>> TARGET_MODEL_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetModelTags").getter(GetModelCopyJobResponse.getter(GetModelCopyJobResponse::targetModelTags)).setter(GetModelCopyJobResponse.setter(Builder::targetModelTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetModelTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureMessage").getter(GetModelCopyJobResponse.getter(GetModelCopyJobResponse::failureMessage)).setter(GetModelCopyJobResponse.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()}).build();
    private static final SdkField<String> SOURCE_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceModelName").getter(GetModelCopyJobResponse.getter(GetModelCopyJobResponse::sourceModelName)).setter(GetModelCopyJobResponse.setter(Builder::sourceModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceModelName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, TARGET_MODEL_ARN_FIELD, TARGET_MODEL_NAME_FIELD, SOURCE_ACCOUNT_ID_FIELD, SOURCE_MODEL_ARN_FIELD, TARGET_MODEL_KMS_KEY_ARN_FIELD, TARGET_MODEL_TAGS_FIELD, FAILURE_MESSAGE_FIELD, SOURCE_MODEL_NAME_FIELD));
    private final String jobArn;
    private final String status;
    private final Instant creationTime;
    private final String targetModelArn;
    private final String targetModelName;
    private final String sourceAccountId;
    private final String sourceModelArn;
    private final String targetModelKmsKeyArn;
    private final List<Tag> targetModelTags;
    private final String failureMessage;
    private final String sourceModelName;

    private GetModelCopyJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobArn = builder.jobArn;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.targetModelArn = builder.targetModelArn;
        this.targetModelName = builder.targetModelName;
        this.sourceAccountId = builder.sourceAccountId;
        this.sourceModelArn = builder.sourceModelArn;
        this.targetModelKmsKeyArn = builder.targetModelKmsKeyArn;
        this.targetModelTags = builder.targetModelTags;
        this.failureMessage = builder.failureMessage;
        this.sourceModelName = builder.sourceModelName;
    }

    public final String jobArn() {
        return this.jobArn;
    }

    public final ModelCopyJobStatus status() {
        return ModelCopyJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String targetModelArn() {
        return this.targetModelArn;
    }

    public final String targetModelName() {
        return this.targetModelName;
    }

    public final String sourceAccountId() {
        return this.sourceAccountId;
    }

    public final String sourceModelArn() {
        return this.sourceModelArn;
    }

    public final String targetModelKmsKeyArn() {
        return this.targetModelKmsKeyArn;
    }

    public final boolean hasTargetModelTags() {
        return this.targetModelTags != null && !(this.targetModelTags instanceof SdkAutoConstructList);
    }

    public final List<Tag> targetModelTags() {
        return this.targetModelTags;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final String sourceModelName() {
        return this.sourceModelName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetModelKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetModelTags() ? this.targetModelTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceModelName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetModelCopyJobResponse)) {
            return false;
        }
        GetModelCopyJobResponse other = (GetModelCopyJobResponse)((Object)obj);
        return Objects.equals(this.jobArn(), other.jobArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.targetModelArn(), other.targetModelArn()) && Objects.equals(this.targetModelName(), other.targetModelName()) && Objects.equals(this.sourceAccountId(), other.sourceAccountId()) && Objects.equals(this.sourceModelArn(), other.sourceModelArn()) && Objects.equals(this.targetModelKmsKeyArn(), other.targetModelKmsKeyArn()) && this.hasTargetModelTags() == other.hasTargetModelTags() && Objects.equals(this.targetModelTags(), other.targetModelTags()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.sourceModelName(), other.sourceModelName());
    }

    public final String toString() {
        return ToString.builder((String)"GetModelCopyJobResponse").add("JobArn", (Object)this.jobArn()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("TargetModelArn", (Object)this.targetModelArn()).add("TargetModelName", (Object)this.targetModelName()).add("SourceAccountId", (Object)this.sourceAccountId()).add("SourceModelArn", (Object)this.sourceModelArn()).add("TargetModelKmsKeyArn", (Object)this.targetModelKmsKeyArn()).add("TargetModelTags", this.hasTargetModelTags() ? this.targetModelTags() : null).add("FailureMessage", (Object)this.failureMessage()).add("SourceModelName", (Object)this.sourceModelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobArn": {
                return Optional.ofNullable(clazz.cast(this.jobArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "targetModelArn": {
                return Optional.ofNullable(clazz.cast(this.targetModelArn()));
            }
            case "targetModelName": {
                return Optional.ofNullable(clazz.cast(this.targetModelName()));
            }
            case "sourceAccountId": {
                return Optional.ofNullable(clazz.cast(this.sourceAccountId()));
            }
            case "sourceModelArn": {
                return Optional.ofNullable(clazz.cast(this.sourceModelArn()));
            }
            case "targetModelKmsKeyArn": {
                return Optional.ofNullable(clazz.cast(this.targetModelKmsKeyArn()));
            }
            case "targetModelTags": {
                return Optional.ofNullable(clazz.cast(this.targetModelTags()));
            }
            case "failureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "sourceModelName": {
                return Optional.ofNullable(clazz.cast(this.sourceModelName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetModelCopyJobResponse, T> g) {
        return obj -> g.apply((GetModelCopyJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String jobArn;
        private String status;
        private Instant creationTime;
        private String targetModelArn;
        private String targetModelName;
        private String sourceAccountId;
        private String sourceModelArn;
        private String targetModelKmsKeyArn;
        private List<Tag> targetModelTags = DefaultSdkAutoConstructList.getInstance();
        private String failureMessage;
        private String sourceModelName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetModelCopyJobResponse model) {
            super(model);
            this.jobArn(model.jobArn);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.targetModelArn(model.targetModelArn);
            this.targetModelName(model.targetModelName);
            this.sourceAccountId(model.sourceAccountId);
            this.sourceModelArn(model.sourceModelArn);
            this.targetModelKmsKeyArn(model.targetModelKmsKeyArn);
            this.targetModelTags(model.targetModelTags);
            this.failureMessage(model.failureMessage);
            this.sourceModelName(model.sourceModelName);
        }

        public final String getJobArn() {
            return this.jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelCopyJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getTargetModelArn() {
            return this.targetModelArn;
        }

        public final void setTargetModelArn(String targetModelArn) {
            this.targetModelArn = targetModelArn;
        }

        @Override
        public final Builder targetModelArn(String targetModelArn) {
            this.targetModelArn = targetModelArn;
            return this;
        }

        public final String getTargetModelName() {
            return this.targetModelName;
        }

        public final void setTargetModelName(String targetModelName) {
            this.targetModelName = targetModelName;
        }

        @Override
        public final Builder targetModelName(String targetModelName) {
            this.targetModelName = targetModelName;
            return this;
        }

        public final String getSourceAccountId() {
            return this.sourceAccountId;
        }

        public final void setSourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
        }

        @Override
        public final Builder sourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
            return this;
        }

        public final String getSourceModelArn() {
            return this.sourceModelArn;
        }

        public final void setSourceModelArn(String sourceModelArn) {
            this.sourceModelArn = sourceModelArn;
        }

        @Override
        public final Builder sourceModelArn(String sourceModelArn) {
            this.sourceModelArn = sourceModelArn;
            return this;
        }

        public final String getTargetModelKmsKeyArn() {
            return this.targetModelKmsKeyArn;
        }

        public final void setTargetModelKmsKeyArn(String targetModelKmsKeyArn) {
            this.targetModelKmsKeyArn = targetModelKmsKeyArn;
        }

        @Override
        public final Builder targetModelKmsKeyArn(String targetModelKmsKeyArn) {
            this.targetModelKmsKeyArn = targetModelKmsKeyArn;
            return this;
        }

        public final List<Tag.Builder> getTargetModelTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.targetModelTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetModelTags(Collection<Tag.BuilderImpl> targetModelTags) {
            this.targetModelTags = TagListCopier.copyFromBuilder(targetModelTags);
        }

        @Override
        public final Builder targetModelTags(Collection<Tag> targetModelTags) {
            this.targetModelTags = TagListCopier.copy(targetModelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetModelTags(Tag ... targetModelTags) {
            this.targetModelTags(Arrays.asList(targetModelTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetModelTags(Consumer<Tag.Builder> ... targetModelTags) {
            this.targetModelTags(Stream.of(targetModelTags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final String getSourceModelName() {
            return this.sourceModelName;
        }

        public final void setSourceModelName(String sourceModelName) {
            this.sourceModelName = sourceModelName;
        }

        @Override
        public final Builder sourceModelName(String sourceModelName) {
            this.sourceModelName = sourceModelName;
            return this;
        }

        @Override
        public GetModelCopyJobResponse build() {
            return new GetModelCopyJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetModelCopyJobResponse> {
        public Builder jobArn(String var1);

        public Builder status(String var1);

        public Builder status(ModelCopyJobStatus var1);

        public Builder creationTime(Instant var1);

        public Builder targetModelArn(String var1);

        public Builder targetModelName(String var1);

        public Builder sourceAccountId(String var1);

        public Builder sourceModelArn(String var1);

        public Builder targetModelKmsKeyArn(String var1);

        public Builder targetModelTags(Collection<Tag> var1);

        public Builder targetModelTags(Tag ... var1);

        public Builder targetModelTags(Consumer<Tag.Builder> ... var1);

        public Builder failureMessage(String var1);

        public Builder sourceModelName(String var1);
    }
}

