/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EvaluationTaskType {
    SUMMARIZATION("Summarization"),
    CLASSIFICATION("Classification"),
    QUESTION_AND_ANSWER("QuestionAndAnswer"),
    GENERATION("Generation"),
    CUSTOM("Custom"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EvaluationTaskType> VALUE_MAP;
    private final String value;

    private EvaluationTaskType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EvaluationTaskType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EvaluationTaskType> knownValues() {
        EnumSet<EvaluationTaskType> knownValues = EnumSet.allOf(EvaluationTaskType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EvaluationTaskType.class, EvaluationTaskType::toString);
    }
}

