/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about one customization job
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelCustomizationJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelCustomizationJobSummary.Builder, ModelCustomizationJobSummary> {
    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(ModelCustomizationJobSummary::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> BASE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("baseModelArn").getter(getter(ModelCustomizationJobSummary::baseModelArn))
            .setter(setter(Builder::baseModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseModelArn").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(ModelCustomizationJobSummary::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ModelCustomizationJobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastModifiedTime")
            .getter(getter(ModelCustomizationJobSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(ModelCustomizationJobSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(ModelCustomizationJobSummary::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CUSTOM_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customModelArn").getter(getter(ModelCustomizationJobSummary::customModelArn))
            .setter(setter(Builder::customModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelArn").build()).build();

    private static final SdkField<String> CUSTOM_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customModelName").getter(getter(ModelCustomizationJobSummary::customModelName))
            .setter(setter(Builder::customModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ARN_FIELD,
            BASE_MODEL_ARN_FIELD, JOB_NAME_FIELD, STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD,
            CUSTOM_MODEL_ARN_FIELD, CUSTOM_MODEL_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String jobArn;

    private final String baseModelArn;

    private final String jobName;

    private final String status;

    private final Instant lastModifiedTime;

    private final Instant creationTime;

    private final Instant endTime;

    private final String customModelArn;

    private final String customModelName;

    private ModelCustomizationJobSummary(BuilderImpl builder) {
        this.jobArn = builder.jobArn;
        this.baseModelArn = builder.baseModelArn;
        this.jobName = builder.jobName;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
        this.customModelArn = builder.customModelArn;
        this.customModelName = builder.customModelName;
    }

    /**
     * <p>
     * ARN of the customization job.
     * </p>
     * 
     * @return ARN of the customization job.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * ARN of the base model.
     * </p>
     * 
     * @return ARN of the base model.
     */
    public final String baseModelArn() {
        return baseModelArn;
    }

    /**
     * <p>
     * Name of the customization job.
     * </p>
     * 
     * @return Name of the customization job.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * Status of the customization job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelCustomizationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the customization job.
     * @see ModelCustomizationJobStatus
     */
    public final ModelCustomizationJobStatus status() {
        return ModelCustomizationJobStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the customization job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ModelCustomizationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the customization job.
     * @see ModelCustomizationJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Time that the customization job was last modified.
     * </p>
     * 
     * @return Time that the customization job was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Creation time of the custom model.
     * </p>
     * 
     * @return Creation time of the custom model.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Time that the customization job ended.
     * </p>
     * 
     * @return Time that the customization job ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * ARN of the custom model.
     * </p>
     * 
     * @return ARN of the custom model.
     */
    public final String customModelArn() {
        return customModelArn;
    }

    /**
     * <p>
     * Name of the custom model.
     * </p>
     * 
     * @return Name of the custom model.
     */
    public final String customModelName() {
        return customModelName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(baseModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(customModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(customModelName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelCustomizationJobSummary)) {
            return false;
        }
        ModelCustomizationJobSummary other = (ModelCustomizationJobSummary) obj;
        return Objects.equals(jobArn(), other.jobArn()) && Objects.equals(baseModelArn(), other.baseModelArn())
                && Objects.equals(jobName(), other.jobName()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(customModelArn(), other.customModelArn())
                && Objects.equals(customModelName(), other.customModelName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelCustomizationJobSummary").add("JobArn", jobArn()).add("BaseModelArn", baseModelArn())
                .add("JobName", jobName()).add("Status", statusAsString()).add("LastModifiedTime", lastModifiedTime())
                .add("CreationTime", creationTime()).add("EndTime", endTime()).add("CustomModelArn", customModelArn())
                .add("CustomModelName", customModelName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "baseModelArn":
            return Optional.ofNullable(clazz.cast(baseModelArn()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "lastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "customModelArn":
            return Optional.ofNullable(clazz.cast(customModelArn()));
        case "customModelName":
            return Optional.ofNullable(clazz.cast(customModelName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelCustomizationJobSummary, T> g) {
        return obj -> g.apply((ModelCustomizationJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelCustomizationJobSummary> {
        /**
         * <p>
         * ARN of the customization job.
         * </p>
         * 
         * @param jobArn
         *        ARN of the customization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * ARN of the base model.
         * </p>
         * 
         * @param baseModelArn
         *        ARN of the base model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseModelArn(String baseModelArn);

        /**
         * <p>
         * Name of the customization job.
         * </p>
         * 
         * @param jobName
         *        Name of the customization job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * Status of the customization job.
         * </p>
         * 
         * @param status
         *        Status of the customization job.
         * @see ModelCustomizationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCustomizationJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the customization job.
         * </p>
         * 
         * @param status
         *        Status of the customization job.
         * @see ModelCustomizationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCustomizationJobStatus
         */
        Builder status(ModelCustomizationJobStatus status);

        /**
         * <p>
         * Time that the customization job was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        Time that the customization job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * Creation time of the custom model.
         * </p>
         * 
         * @param creationTime
         *        Creation time of the custom model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Time that the customization job ended.
         * </p>
         * 
         * @param endTime
         *        Time that the customization job ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * ARN of the custom model.
         * </p>
         * 
         * @param customModelArn
         *        ARN of the custom model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customModelArn(String customModelArn);

        /**
         * <p>
         * Name of the custom model.
         * </p>
         * 
         * @param customModelName
         *        Name of the custom model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customModelName(String customModelName);
    }

    static final class BuilderImpl implements Builder {
        private String jobArn;

        private String baseModelArn;

        private String jobName;

        private String status;

        private Instant lastModifiedTime;

        private Instant creationTime;

        private Instant endTime;

        private String customModelArn;

        private String customModelName;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelCustomizationJobSummary model) {
            jobArn(model.jobArn);
            baseModelArn(model.baseModelArn);
            jobName(model.jobName);
            status(model.status);
            lastModifiedTime(model.lastModifiedTime);
            creationTime(model.creationTime);
            endTime(model.endTime);
            customModelArn(model.customModelArn);
            customModelName(model.customModelName);
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getBaseModelArn() {
            return baseModelArn;
        }

        public final void setBaseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
        }

        @Override
        public final Builder baseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ModelCustomizationJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getCustomModelArn() {
            return customModelArn;
        }

        public final void setCustomModelArn(String customModelArn) {
            this.customModelArn = customModelArn;
        }

        @Override
        public final Builder customModelArn(String customModelArn) {
            this.customModelArn = customModelArn;
            return this;
        }

        public final String getCustomModelName() {
            return customModelName;
        }

        public final void setCustomModelName(String customModelName) {
            this.customModelName = customModelName;
        }

        @Override
        public final Builder customModelName(String customModelName) {
            this.customModelName = customModelName;
            return this;
        }

        @Override
        public ModelCustomizationJobSummary build() {
            return new ModelCustomizationJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
