/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.CustomModelSummary;
import software.amazon.awssdk.services.bedrock.model.ListCustomModelsRequest;
import software.amazon.awssdk.services.bedrock.model.ListCustomModelsResponse;

public class ListCustomModelsIterable
implements SdkIterable<ListCustomModelsResponse> {
    private final BedrockClient client;
    private final ListCustomModelsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCustomModelsIterable(BedrockClient client, ListCustomModelsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCustomModelsResponseFetcher();
    }

    public Iterator<ListCustomModelsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CustomModelSummary> modelSummaries() {
        Function<ListCustomModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelSummaries() != null) {
                return response.modelSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCustomModelsResponseFetcher
    implements SyncPageFetcher<ListCustomModelsResponse> {
        private ListCustomModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCustomModelsResponse nextPage(ListCustomModelsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomModelsIterable.this.client.listCustomModels(ListCustomModelsIterable.this.firstRequest);
            }
            return ListCustomModelsIterable.this.client.listCustomModels((ListCustomModelsRequest)((Object)ListCustomModelsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

