/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmrecommendedactions.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActionType {
    ADD_ALTERNATE_BILLING_CONTACT("ADD_ALTERNATE_BILLING_CONTACT"),
    CREATE_ANOMALY_MONITOR("CREATE_ANOMALY_MONITOR"),
    CREATE_BUDGET("CREATE_BUDGET"),
    ENABLE_COST_OPTIMIZATION_HUB("ENABLE_COST_OPTIMIZATION_HUB"),
    MIGRATE_TO_GRANULAR_PERMISSIONS("MIGRATE_TO_GRANULAR_PERMISSIONS"),
    PAYMENTS_DUE("PAYMENTS_DUE"),
    PAYMENTS_PAST_DUE("PAYMENTS_PAST_DUE"),
    REVIEW_ANOMALIES("REVIEW_ANOMALIES"),
    REVIEW_BUDGET_ALERTS("REVIEW_BUDGET_ALERTS"),
    REVIEW_BUDGETS_EXCEEDED("REVIEW_BUDGETS_EXCEEDED"),
    REVIEW_EXPIRING_RI("REVIEW_EXPIRING_RI"),
    REVIEW_EXPIRING_SP("REVIEW_EXPIRING_SP"),
    REVIEW_FREETIER_USAGE_ALERTS("REVIEW_FREETIER_USAGE_ALERTS"),
    REVIEW_FREETIER_CREDITS_REMAINING("REVIEW_FREETIER_CREDITS_REMAINING"),
    REVIEW_FREETIER_DAYS_REMAINING("REVIEW_FREETIER_DAYS_REMAINING"),
    REVIEW_SAVINGS_OPPORTUNITY_RECOMMENDATIONS("REVIEW_SAVINGS_OPPORTUNITY_RECOMMENDATIONS"),
    UPDATE_EXPIRED_PAYMENT_METHOD("UPDATE_EXPIRED_PAYMENT_METHOD"),
    UPDATE_INVALID_PAYMENT_METHOD("UPDATE_INVALID_PAYMENT_METHOD"),
    UPDATE_TAX_EXEMPTION_CERTIFICATE("UPDATE_TAX_EXEMPTION_CERTIFICATE"),
    UPDATE_TAX_REGISTRATION_NUMBER("UPDATE_TAX_REGISTRATION_NUMBER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActionType> VALUE_MAP;
    private final String value;

    private ActionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActionType> knownValues() {
        EnumSet<ActionType> knownValues = EnumSet.allOf(ActionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActionType.class, ActionType::toString);
    }
}

