/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmrecommendedactions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a specific recommended action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecommendedAction implements SdkPojo, Serializable,
        ToCopyableBuilder<RecommendedAction.Builder, RecommendedAction> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(RecommendedAction::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RecommendedAction::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountId").getter(getter(RecommendedAction::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("severity").getter(getter(RecommendedAction::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()).build();

    private static final SdkField<String> FEATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("feature")
            .getter(getter(RecommendedAction::featureAsString)).setter(setter(Builder::feature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("feature").build()).build();

    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("context")
            .getter(getter(RecommendedAction::context))
            .setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> NEXT_STEPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("nextSteps")
            .getter(getter(RecommendedAction::nextSteps))
            .setter(setter(Builder::nextSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LAST_UPDATED_TIME_STAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lastUpdatedTimeStamp").getter(getter(RecommendedAction::lastUpdatedTimeStamp))
            .setter(setter(Builder::lastUpdatedTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTimeStamp").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD,
            ACCOUNT_ID_FIELD, SEVERITY_FIELD, FEATURE_FIELD, CONTEXT_FIELD, NEXT_STEPS_FIELD, LAST_UPDATED_TIME_STAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String type;

    private final String accountId;

    private final String severity;

    private final String feature;

    private final Map<String, String> context;

    private final List<String> nextSteps;

    private final String lastUpdatedTimeStamp;

    private RecommendedAction(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.accountId = builder.accountId;
        this.severity = builder.severity;
        this.feature = builder.feature;
        this.context = builder.context;
        this.nextSteps = builder.nextSteps;
        this.lastUpdatedTimeStamp = builder.lastUpdatedTimeStamp;
    }

    /**
     * <p>
     * The ID for the recommended action.
     * </p>
     * 
     * @return The ID for the recommended action.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of action you can take by adopting the recommended action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of action you can take by adopting the recommended action.
     * @see ActionType
     */
    public final ActionType type() {
        return ActionType.fromValue(type);
    }

    /**
     * <p>
     * The type of action you can take by adopting the recommended action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of action you can take by adopting the recommended action.
     * @see ActionType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The account that the recommended action is for.
     * </p>
     * 
     * @return The account that the recommended action is for.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The severity associated with the recommended action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link Severity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity associated with the recommended action.
     * @see Severity
     */
    public final Severity severity() {
        return Severity.fromValue(severity);
    }

    /**
     * <p>
     * The severity associated with the recommended action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link Severity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity associated with the recommended action.
     * @see Severity
     */
    public final String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * The feature associated with the recommended action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feature} will
     * return {@link Feature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureAsString}.
     * </p>
     * 
     * @return The feature associated with the recommended action.
     * @see Feature
     */
    public final Feature feature() {
        return Feature.fromValue(feature);
    }

    /**
     * <p>
     * The feature associated with the recommended action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #feature} will
     * return {@link Feature#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureAsString}.
     * </p>
     * 
     * @return The feature associated with the recommended action.
     * @see Feature
     */
    public final String featureAsString() {
        return feature;
    }

    /**
     * For responses, this returns true if the service returned a value for the Context property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContext() {
        return context != null && !(context instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Context that applies to the recommended action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContext} method.
     * </p>
     * 
     * @return Context that applies to the recommended action.
     */
    public final Map<String, String> context() {
        return context;
    }

    /**
     * For responses, this returns true if the service returned a value for the NextSteps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNextSteps() {
        return nextSteps != null && !(nextSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The possible next steps to execute the recommended action.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNextSteps} method.
     * </p>
     * 
     * @return The possible next steps to execute the recommended action.
     */
    public final List<String> nextSteps() {
        return nextSteps;
    }

    /**
     * <p>
     * The time when the recommended action status was last updated.
     * </p>
     * 
     * @return The time when the recommended action status was last updated.
     */
    public final String lastUpdatedTimeStamp() {
        return lastUpdatedTimeStamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(featureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasContext() ? context() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNextSteps() ? nextSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTimeStamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendedAction)) {
            return false;
        }
        RecommendedAction other = (RecommendedAction) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(accountId(), other.accountId()) && Objects.equals(severityAsString(), other.severityAsString())
                && Objects.equals(featureAsString(), other.featureAsString()) && hasContext() == other.hasContext()
                && Objects.equals(context(), other.context()) && hasNextSteps() == other.hasNextSteps()
                && Objects.equals(nextSteps(), other.nextSteps())
                && Objects.equals(lastUpdatedTimeStamp(), other.lastUpdatedTimeStamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecommendedAction").add("Id", id()).add("Type", typeAsString()).add("AccountId", accountId())
                .add("Severity", severityAsString()).add("Feature", featureAsString())
                .add("Context", hasContext() ? context() : null).add("NextSteps", hasNextSteps() ? nextSteps() : null)
                .add("LastUpdatedTimeStamp", lastUpdatedTimeStamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "accountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "feature":
            return Optional.ofNullable(clazz.cast(featureAsString()));
        case "context":
            return Optional.ofNullable(clazz.cast(context()));
        case "nextSteps":
            return Optional.ofNullable(clazz.cast(nextSteps()));
        case "lastUpdatedTimeStamp":
            return Optional.ofNullable(clazz.cast(lastUpdatedTimeStamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("severity", SEVERITY_FIELD);
        map.put("feature", FEATURE_FIELD);
        map.put("context", CONTEXT_FIELD);
        map.put("nextSteps", NEXT_STEPS_FIELD);
        map.put("lastUpdatedTimeStamp", LAST_UPDATED_TIME_STAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendedAction, T> g) {
        return obj -> g.apply((RecommendedAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecommendedAction> {
        /**
         * <p>
         * The ID for the recommended action.
         * </p>
         * 
         * @param id
         *        The ID for the recommended action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of action you can take by adopting the recommended action.
         * </p>
         * 
         * @param type
         *        The type of action you can take by adopting the recommended action.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of action you can take by adopting the recommended action.
         * </p>
         * 
         * @param type
         *        The type of action you can take by adopting the recommended action.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder type(ActionType type);

        /**
         * <p>
         * The account that the recommended action is for.
         * </p>
         * 
         * @param accountId
         *        The account that the recommended action is for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The severity associated with the recommended action.
         * </p>
         * 
         * @param severity
         *        The severity associated with the recommended action.
         * @see Severity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Severity
         */
        Builder severity(String severity);

        /**
         * <p>
         * The severity associated with the recommended action.
         * </p>
         * 
         * @param severity
         *        The severity associated with the recommended action.
         * @see Severity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Severity
         */
        Builder severity(Severity severity);

        /**
         * <p>
         * The feature associated with the recommended action.
         * </p>
         * 
         * @param feature
         *        The feature associated with the recommended action.
         * @see Feature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Feature
         */
        Builder feature(String feature);

        /**
         * <p>
         * The feature associated with the recommended action.
         * </p>
         * 
         * @param feature
         *        The feature associated with the recommended action.
         * @see Feature
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Feature
         */
        Builder feature(Feature feature);

        /**
         * <p>
         * Context that applies to the recommended action.
         * </p>
         * 
         * @param context
         *        Context that applies to the recommended action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(Map<String, String> context);

        /**
         * <p>
         * The possible next steps to execute the recommended action.
         * </p>
         * 
         * @param nextSteps
         *        The possible next steps to execute the recommended action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextSteps(Collection<String> nextSteps);

        /**
         * <p>
         * The possible next steps to execute the recommended action.
         * </p>
         * 
         * @param nextSteps
         *        The possible next steps to execute the recommended action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextSteps(String... nextSteps);

        /**
         * <p>
         * The time when the recommended action status was last updated.
         * </p>
         * 
         * @param lastUpdatedTimeStamp
         *        The time when the recommended action status was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTimeStamp(String lastUpdatedTimeStamp);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private String accountId;

        private String severity;

        private String feature;

        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();

        private List<String> nextSteps = DefaultSdkAutoConstructList.getInstance();

        private String lastUpdatedTimeStamp;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendedAction model) {
            id(model.id);
            type(model.type);
            accountId(model.accountId);
            severity(model.severity);
            feature(model.feature);
            context(model.context);
            nextSteps(model.nextSteps);
            lastUpdatedTimeStamp(model.lastUpdatedTimeStamp);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getFeature() {
            return feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public final Builder feature(Feature feature) {
            this.feature(feature == null ? null : feature.toString());
            return this;
        }

        public final Map<String, String> getContext() {
            if (context instanceof SdkAutoConstructMap) {
                return null;
            }
            return context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ContextCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ContextCopier.copy(context);
            return this;
        }

        public final Collection<String> getNextSteps() {
            if (nextSteps instanceof SdkAutoConstructList) {
                return null;
            }
            return nextSteps;
        }

        public final void setNextSteps(Collection<String> nextSteps) {
            this.nextSteps = NextStepsCopier.copy(nextSteps);
        }

        @Override
        public final Builder nextSteps(Collection<String> nextSteps) {
            this.nextSteps = NextStepsCopier.copy(nextSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextSteps(String... nextSteps) {
            nextSteps(Arrays.asList(nextSteps));
            return this;
        }

        public final String getLastUpdatedTimeStamp() {
            return lastUpdatedTimeStamp;
        }

        public final void setLastUpdatedTimeStamp(String lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
        }

        @Override
        public final Builder lastUpdatedTimeStamp(String lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
            return this;
        }

        @Override
        public RecommendedAction build() {
            return new RecommendedAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
