/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmrecommendedactions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Enables filtering of results based on specified action criteria. You can define multiple action filters to refine
 * results using combinations of feature type, severity level, and recommendation type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestFilter implements SdkPojo, Serializable, ToCopyableBuilder<RequestFilter.Builder, RequestFilter> {
    private static final SdkField<List<ActionFilter>> ACTIONS_FIELD = SdkField
            .<List<ActionFilter>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(RequestFilter::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ActionFilter> actions;

    private RequestFilter(BuilderImpl builder) {
        this.actions = builder.actions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Actions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of action filters that define criteria for filtering results. Each filter specifies a key, match option,
     * and corresponding values to filter on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActions} method.
     * </p>
     * 
     * @return A list of action filters that define criteria for filtering results. Each filter specifies a key, match
     *         option, and corresponding values to filter on.
     */
    public final List<ActionFilter> actions() {
        return actions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestFilter)) {
            return false;
        }
        RequestFilter other = (RequestFilter) obj;
        return hasActions() == other.hasActions() && Objects.equals(actions(), other.actions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestFilter").add("Actions", hasActions() ? actions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actions", ACTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RequestFilter, T> g) {
        return obj -> g.apply((RequestFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RequestFilter> {
        /**
         * <p>
         * A list of action filters that define criteria for filtering results. Each filter specifies a key, match
         * option, and corresponding values to filter on.
         * </p>
         * 
         * @param actions
         *        A list of action filters that define criteria for filtering results. Each filter specifies a key,
         *        match option, and corresponding values to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<ActionFilter> actions);

        /**
         * <p>
         * A list of action filters that define criteria for filtering results. Each filter specifies a key, match
         * option, and corresponding values to filter on.
         * </p>
         * 
         * @param actions
         *        A list of action filters that define criteria for filtering results. Each filter specifies a key,
         *        match option, and corresponding values to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(ActionFilter... actions);

        /**
         * <p>
         * A list of action filters that define criteria for filtering results. Each filter specifies a key, match
         * option, and corresponding values to filter on.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bcmrecommendedactions.model.ActionFilter.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bcmrecommendedactions.model.ActionFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bcmrecommendedactions.model.ActionFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #actions(List<ActionFilter>)}.
         * 
         * @param actions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bcmrecommendedactions.model.ActionFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actions(java.util.Collection<ActionFilter>)
         */
        Builder actions(Consumer<ActionFilter.Builder>... actions);
    }

    static final class BuilderImpl implements Builder {
        private List<ActionFilter> actions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RequestFilter model) {
            actions(model.actions);
        }

        public final List<ActionFilter.Builder> getActions() {
            List<ActionFilter.Builder> result = ActionFilterListCopier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<ActionFilter.BuilderImpl> actions) {
            this.actions = ActionFilterListCopier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<ActionFilter> actions) {
            this.actions = ActionFilterListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(ActionFilter... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<ActionFilter.Builder>... actions) {
            actions(Stream.of(actions).map(c -> ActionFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RequestFilter build() {
            return new RequestFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
