/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmrecommendedactions;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.bcmrecommendedactions.model.AccessDeniedException;
import software.amazon.awssdk.services.bcmrecommendedactions.model.BcmRecommendedActionsException;
import software.amazon.awssdk.services.bcmrecommendedactions.model.InternalServerException;
import software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsRequest;
import software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsResponse;
import software.amazon.awssdk.services.bcmrecommendedactions.model.ThrottlingException;
import software.amazon.awssdk.services.bcmrecommendedactions.model.ValidationException;
import software.amazon.awssdk.services.bcmrecommendedactions.paginators.ListRecommendedActionsIterable;

/**
 * Service client for accessing AWS Billing and Cost Management Recommended Actions. This can be created using the
 * static {@link #builder()} method.
 *
 * <p>
 * You can use the Billing and Cost Management Recommended Actions API to programmatically query your best practices and
 * recommendations to optimize your costs.
 * </p>
 * <p>
 * The Billing and Cost Management Recommended Actions API provides the following endpoint:
 * </p>
 * <ul>
 * <li>
 * <p>
 * https://bcm-recommended-actions.us-east-1.api.aws
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface BcmRecommendedActionsClient extends AwsClient {
    String SERVICE_NAME = "bcm-recommended-actions";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "bcm-recommended-actions";

    /**
     * <p>
     * Returns a list of recommended actions that match the filter criteria.
     * </p>
     *
     * @param listRecommendedActionsRequest
     * @return Result of the ListRecommendedActions operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred during the processing of your request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmRecommendedActionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmRecommendedActionsClient.ListRecommendedActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-recommended-actions-2024-11-14/ListRecommendedActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendedActionsResponse listRecommendedActions(ListRecommendedActionsRequest listRecommendedActionsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ThrottlingException, AwsServiceException,
            SdkClientException, BcmRecommendedActionsException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of recommended actions that match the filter criteria.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendedActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendedActionsRequest#builder()}
     * </p>
     *
     * @param listRecommendedActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsRequest.Builder}
     *        to create a request.
     * @return Result of the ListRecommendedActions operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred during the processing of your request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmRecommendedActionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmRecommendedActionsClient.ListRecommendedActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-recommended-actions-2024-11-14/ListRecommendedActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendedActionsResponse listRecommendedActions(
            Consumer<ListRecommendedActionsRequest.Builder> listRecommendedActionsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmRecommendedActionsException {
        return listRecommendedActions(ListRecommendedActionsRequest.builder().applyMutation(listRecommendedActionsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendedActions(software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmrecommendedactions.paginators.ListRecommendedActionsIterable responses = client.listRecommendedActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmrecommendedactions.paginators.ListRecommendedActionsIterable responses = client
     *             .listRecommendedActionsPaginator(request);
     *     for (software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmrecommendedactions.paginators.ListRecommendedActionsIterable responses = client.listRecommendedActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendedActions(software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRecommendedActionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred during the processing of your request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmRecommendedActionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmRecommendedActionsClient.ListRecommendedActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-recommended-actions-2024-11-14/ListRecommendedActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendedActionsIterable listRecommendedActionsPaginator(
            ListRecommendedActionsRequest listRecommendedActionsRequest) throws AccessDeniedException, InternalServerException,
            ValidationException, ThrottlingException, AwsServiceException, SdkClientException, BcmRecommendedActionsException {
        return new ListRecommendedActionsIterable(this, listRecommendedActionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRecommendedActions(software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmrecommendedactions.paginators.ListRecommendedActionsIterable responses = client.listRecommendedActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.bcmrecommendedactions.paginators.ListRecommendedActionsIterable responses = client
     *             .listRecommendedActionsPaginator(request);
     *     for (software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.bcmrecommendedactions.paginators.ListRecommendedActionsIterable responses = client.listRecommendedActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRecommendedActions(software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRecommendedActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListRecommendedActionsRequest#builder()}
     * </p>
     *
     * @param listRecommendedActionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws InternalServerException
     *         An unexpected error occurred during the processing of your request.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an Amazon Web Services service.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws BcmRecommendedActionsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample BcmRecommendedActionsClient.ListRecommendedActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/bcm-recommended-actions-2024-11-14/ListRecommendedActions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRecommendedActionsIterable listRecommendedActionsPaginator(
            Consumer<ListRecommendedActionsRequest.Builder> listRecommendedActionsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ThrottlingException, AwsServiceException, SdkClientException,
            BcmRecommendedActionsException {
        return listRecommendedActionsPaginator(ListRecommendedActionsRequest.builder()
                .applyMutation(listRecommendedActionsRequest).build());
    }

    /**
     * Create a {@link BcmRecommendedActionsClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static BcmRecommendedActionsClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link BcmRecommendedActionsClient}.
     */
    static BcmRecommendedActionsClientBuilder builder() {
        return new DefaultBcmRecommendedActionsClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default BcmRecommendedActionsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
