/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmrecommendedactions.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmrecommendedactions.BcmRecommendedActionsAsyncClient;
import software.amazon.awssdk.services.bcmrecommendedactions.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsRequest;
import software.amazon.awssdk.services.bcmrecommendedactions.model.ListRecommendedActionsResponse;
import software.amazon.awssdk.services.bcmrecommendedactions.model.RecommendedAction;

public class ListRecommendedActionsPublisher
implements SdkPublisher<ListRecommendedActionsResponse> {
    private final BcmRecommendedActionsAsyncClient client;
    private final ListRecommendedActionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRecommendedActionsPublisher(BcmRecommendedActionsAsyncClient client, ListRecommendedActionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRecommendedActionsPublisher(BcmRecommendedActionsAsyncClient client, ListRecommendedActionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRecommendedActionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRecommendedActionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<RecommendedAction> recommendedActions() {
        Function<ListRecommendedActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.recommendedActions() != null) {
                return response.recommendedActions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRecommendedActionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRecommendedActionsResponseFetcher
    implements AsyncPageFetcher<ListRecommendedActionsResponse> {
        private ListRecommendedActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListRecommendedActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRecommendedActionsResponse> nextPage(ListRecommendedActionsResponse previousPage) {
            if (previousPage == null) {
                return ListRecommendedActionsPublisher.this.client.listRecommendedActions(ListRecommendedActionsPublisher.this.firstRequest);
            }
            return ListRecommendedActionsPublisher.this.client.listRecommendedActions((ListRecommendedActionsRequest)((Object)ListRecommendedActionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

