/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBillEstimateResponse extends BcmPricingCalculatorResponse implements
        ToCopyableBuilder<GetBillEstimateResponse.Builder, GetBillEstimateResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetBillEstimateResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetBillEstimateResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetBillEstimateResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureMessage").getter(getter(GetBillEstimateResponse::failureMessage))
            .setter(setter(Builder::failureMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()).build();

    private static final SdkField<BillInterval> BILL_INTERVAL_FIELD = SdkField.<BillInterval> builder(MarshallingType.SDK_POJO)
            .memberName("billInterval").getter(getter(GetBillEstimateResponse::billInterval))
            .setter(setter(Builder::billInterval)).constructor(BillInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billInterval").build()).build();

    private static final SdkField<BillEstimateCostSummary> COST_SUMMARY_FIELD = SdkField
            .<BillEstimateCostSummary> builder(MarshallingType.SDK_POJO).memberName("costSummary")
            .getter(getter(GetBillEstimateResponse::costSummary)).setter(setter(Builder::costSummary))
            .constructor(BillEstimateCostSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costSummary").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(GetBillEstimateResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("expiresAt").getter(getter(GetBillEstimateResponse::expiresAt)).setter(setter(Builder::expiresAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build()).build();

    private static final SdkField<String> GROUP_SHARING_PREFERENCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupSharingPreference").getter(getter(GetBillEstimateResponse::groupSharingPreferenceAsString))
            .setter(setter(Builder::groupSharingPreference))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupSharingPreference").build())
            .build();

    private static final SdkField<String> COST_CATEGORY_GROUP_SHARING_PREFERENCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("costCategoryGroupSharingPreferenceArn")
            .getter(getter(GetBillEstimateResponse::costCategoryGroupSharingPreferenceArn))
            .setter(setter(Builder::costCategoryGroupSharingPreferenceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("costCategoryGroupSharingPreferenceArn").build()).build();

    private static final SdkField<Instant> COST_CATEGORY_GROUP_SHARING_PREFERENCE_EFFECTIVE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("costCategoryGroupSharingPreferenceEffectiveDate")
            .getter(getter(GetBillEstimateResponse::costCategoryGroupSharingPreferenceEffectiveDate))
            .setter(setter(Builder::costCategoryGroupSharingPreferenceEffectiveDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("costCategoryGroupSharingPreferenceEffectiveDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            STATUS_FIELD, FAILURE_MESSAGE_FIELD, BILL_INTERVAL_FIELD, COST_SUMMARY_FIELD, CREATED_AT_FIELD, EXPIRES_AT_FIELD,
            GROUP_SHARING_PREFERENCE_FIELD, COST_CATEGORY_GROUP_SHARING_PREFERENCE_ARN_FIELD,
            COST_CATEGORY_GROUP_SHARING_PREFERENCE_EFFECTIVE_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String name;

    private final String status;

    private final String failureMessage;

    private final BillInterval billInterval;

    private final BillEstimateCostSummary costSummary;

    private final Instant createdAt;

    private final Instant expiresAt;

    private final String groupSharingPreference;

    private final String costCategoryGroupSharingPreferenceArn;

    private final Instant costCategoryGroupSharingPreferenceEffectiveDate;

    private GetBillEstimateResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.failureMessage = builder.failureMessage;
        this.billInterval = builder.billInterval;
        this.costSummary = builder.costSummary;
        this.createdAt = builder.createdAt;
        this.expiresAt = builder.expiresAt;
        this.groupSharingPreference = builder.groupSharingPreference;
        this.costCategoryGroupSharingPreferenceArn = builder.costCategoryGroupSharingPreferenceArn;
        this.costCategoryGroupSharingPreferenceEffectiveDate = builder.costCategoryGroupSharingPreferenceEffectiveDate;
    }

    /**
     * <p>
     * The unique identifier of the retrieved bill estimate.
     * </p>
     * 
     * @return The unique identifier of the retrieved bill estimate.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the retrieved bill estimate.
     * </p>
     * 
     * @return The name of the retrieved bill estimate.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the bill estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BillEstimateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the bill estimate.
     * @see BillEstimateStatus
     */
    public final BillEstimateStatus status() {
        return BillEstimateStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the bill estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link BillEstimateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the bill estimate.
     * @see BillEstimateStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * An error message if the bill estimate retrieval failed.
     * </p>
     * 
     * @return An error message if the bill estimate retrieval failed.
     */
    public final String failureMessage() {
        return failureMessage;
    }

    /**
     * <p>
     * The time period covered by the bill estimate.
     * </p>
     * 
     * @return The time period covered by the bill estimate.
     */
    public final BillInterval billInterval() {
        return billInterval;
    }

    /**
     * <p>
     * A summary of the estimated costs.
     * </p>
     * 
     * @return A summary of the estimated costs.
     */
    public final BillEstimateCostSummary costSummary() {
        return costSummary;
    }

    /**
     * <p>
     * The timestamp when the bill estimate was created.
     * </p>
     * 
     * @return The timestamp when the bill estimate was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp when the bill estimate will expire.
     * </p>
     * 
     * @return The timestamp when the bill estimate will expire.
     */
    public final Instant expiresAt() {
        return expiresAt;
    }

    /**
     * <p>
     * The setting for the reserved instance and savings plan group sharing used in this estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #groupSharingPreference} will return {@link GroupSharingPreferenceEnum#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #groupSharingPreferenceAsString}.
     * </p>
     * 
     * @return The setting for the reserved instance and savings plan group sharing used in this estimate.
     * @see GroupSharingPreferenceEnum
     */
    public final GroupSharingPreferenceEnum groupSharingPreference() {
        return GroupSharingPreferenceEnum.fromValue(groupSharingPreference);
    }

    /**
     * <p>
     * The setting for the reserved instance and savings plan group sharing used in this estimate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #groupSharingPreference} will return {@link GroupSharingPreferenceEnum#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #groupSharingPreferenceAsString}.
     * </p>
     * 
     * @return The setting for the reserved instance and savings plan group sharing used in this estimate.
     * @see GroupSharingPreferenceEnum
     */
    public final String groupSharingPreferenceAsString() {
        return groupSharingPreference;
    }

    /**
     * <p>
     * The arn of the cost category used in the reserved and prioritized group sharing.
     * </p>
     * 
     * @return The arn of the cost category used in the reserved and prioritized group sharing.
     */
    public final String costCategoryGroupSharingPreferenceArn() {
        return costCategoryGroupSharingPreferenceArn;
    }

    /**
     * <p>
     * Timestamp of the effective date of the cost category used in the group sharing settings.
     * </p>
     * 
     * @return Timestamp of the effective date of the cost category used in the group sharing settings.
     */
    public final Instant costCategoryGroupSharingPreferenceEffectiveDate() {
        return costCategoryGroupSharingPreferenceEffectiveDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(billInterval());
        hashCode = 31 * hashCode + Objects.hashCode(costSummary());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(groupSharingPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(costCategoryGroupSharingPreferenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(costCategoryGroupSharingPreferenceEffectiveDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBillEstimateResponse)) {
            return false;
        }
        GetBillEstimateResponse other = (GetBillEstimateResponse) obj;
        return Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(failureMessage(), other.failureMessage())
                && Objects.equals(billInterval(), other.billInterval())
                && Objects.equals(costSummary(), other.costSummary())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(expiresAt(), other.expiresAt())
                && Objects.equals(groupSharingPreferenceAsString(), other.groupSharingPreferenceAsString())
                && Objects.equals(costCategoryGroupSharingPreferenceArn(), other.costCategoryGroupSharingPreferenceArn())
                && Objects.equals(costCategoryGroupSharingPreferenceEffectiveDate(),
                        other.costCategoryGroupSharingPreferenceEffectiveDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBillEstimateResponse").add("Id", id()).add("Name", name()).add("Status", statusAsString())
                .add("FailureMessage", failureMessage()).add("BillInterval", billInterval()).add("CostSummary", costSummary())
                .add("CreatedAt", createdAt()).add("ExpiresAt", expiresAt())
                .add("GroupSharingPreference", groupSharingPreferenceAsString())
                .add("CostCategoryGroupSharingPreferenceArn", costCategoryGroupSharingPreferenceArn())
                .add("CostCategoryGroupSharingPreferenceEffectiveDate", costCategoryGroupSharingPreferenceEffectiveDate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "failureMessage":
            return Optional.ofNullable(clazz.cast(failureMessage()));
        case "billInterval":
            return Optional.ofNullable(clazz.cast(billInterval()));
        case "costSummary":
            return Optional.ofNullable(clazz.cast(costSummary()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "expiresAt":
            return Optional.ofNullable(clazz.cast(expiresAt()));
        case "groupSharingPreference":
            return Optional.ofNullable(clazz.cast(groupSharingPreferenceAsString()));
        case "costCategoryGroupSharingPreferenceArn":
            return Optional.ofNullable(clazz.cast(costCategoryGroupSharingPreferenceArn()));
        case "costCategoryGroupSharingPreferenceEffectiveDate":
            return Optional.ofNullable(clazz.cast(costCategoryGroupSharingPreferenceEffectiveDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        map.put("billInterval", BILL_INTERVAL_FIELD);
        map.put("costSummary", COST_SUMMARY_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("expiresAt", EXPIRES_AT_FIELD);
        map.put("groupSharingPreference", GROUP_SHARING_PREFERENCE_FIELD);
        map.put("costCategoryGroupSharingPreferenceArn", COST_CATEGORY_GROUP_SHARING_PREFERENCE_ARN_FIELD);
        map.put("costCategoryGroupSharingPreferenceEffectiveDate", COST_CATEGORY_GROUP_SHARING_PREFERENCE_EFFECTIVE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetBillEstimateResponse, T> g) {
        return obj -> g.apply((GetBillEstimateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BcmPricingCalculatorResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetBillEstimateResponse> {
        /**
         * <p>
         * The unique identifier of the retrieved bill estimate.
         * </p>
         * 
         * @param id
         *        The unique identifier of the retrieved bill estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the retrieved bill estimate.
         * </p>
         * 
         * @param name
         *        The name of the retrieved bill estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the bill estimate.
         * </p>
         * 
         * @param status
         *        The current status of the bill estimate.
         * @see BillEstimateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillEstimateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the bill estimate.
         * </p>
         * 
         * @param status
         *        The current status of the bill estimate.
         * @see BillEstimateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BillEstimateStatus
         */
        Builder status(BillEstimateStatus status);

        /**
         * <p>
         * An error message if the bill estimate retrieval failed.
         * </p>
         * 
         * @param failureMessage
         *        An error message if the bill estimate retrieval failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureMessage(String failureMessage);

        /**
         * <p>
         * The time period covered by the bill estimate.
         * </p>
         * 
         * @param billInterval
         *        The time period covered by the bill estimate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billInterval(BillInterval billInterval);

        /**
         * <p>
         * The time period covered by the bill estimate.
         * </p>
         * This is a convenience method that creates an instance of the {@link BillInterval.Builder} avoiding the need
         * to create one manually via {@link BillInterval#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BillInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #billInterval(BillInterval)}.
         * 
         * @param billInterval
         *        a consumer that will call methods on {@link BillInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billInterval(BillInterval)
         */
        default Builder billInterval(Consumer<BillInterval.Builder> billInterval) {
            return billInterval(BillInterval.builder().applyMutation(billInterval).build());
        }

        /**
         * <p>
         * A summary of the estimated costs.
         * </p>
         * 
         * @param costSummary
         *        A summary of the estimated costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costSummary(BillEstimateCostSummary costSummary);

        /**
         * <p>
         * A summary of the estimated costs.
         * </p>
         * This is a convenience method that creates an instance of the {@link BillEstimateCostSummary.Builder} avoiding
         * the need to create one manually via {@link BillEstimateCostSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BillEstimateCostSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #costSummary(BillEstimateCostSummary)}.
         * 
         * @param costSummary
         *        a consumer that will call methods on {@link BillEstimateCostSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costSummary(BillEstimateCostSummary)
         */
        default Builder costSummary(Consumer<BillEstimateCostSummary.Builder> costSummary) {
            return costSummary(BillEstimateCostSummary.builder().applyMutation(costSummary).build());
        }

        /**
         * <p>
         * The timestamp when the bill estimate was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the bill estimate was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp when the bill estimate will expire.
         * </p>
         * 
         * @param expiresAt
         *        The timestamp when the bill estimate will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiresAt(Instant expiresAt);

        /**
         * <p>
         * The setting for the reserved instance and savings plan group sharing used in this estimate.
         * </p>
         * 
         * @param groupSharingPreference
         *        The setting for the reserved instance and savings plan group sharing used in this estimate.
         * @see GroupSharingPreferenceEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupSharingPreferenceEnum
         */
        Builder groupSharingPreference(String groupSharingPreference);

        /**
         * <p>
         * The setting for the reserved instance and savings plan group sharing used in this estimate.
         * </p>
         * 
         * @param groupSharingPreference
         *        The setting for the reserved instance and savings plan group sharing used in this estimate.
         * @see GroupSharingPreferenceEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupSharingPreferenceEnum
         */
        Builder groupSharingPreference(GroupSharingPreferenceEnum groupSharingPreference);

        /**
         * <p>
         * The arn of the cost category used in the reserved and prioritized group sharing.
         * </p>
         * 
         * @param costCategoryGroupSharingPreferenceArn
         *        The arn of the cost category used in the reserved and prioritized group sharing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryGroupSharingPreferenceArn(String costCategoryGroupSharingPreferenceArn);

        /**
         * <p>
         * Timestamp of the effective date of the cost category used in the group sharing settings.
         * </p>
         * 
         * @param costCategoryGroupSharingPreferenceEffectiveDate
         *        Timestamp of the effective date of the cost category used in the group sharing settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryGroupSharingPreferenceEffectiveDate(Instant costCategoryGroupSharingPreferenceEffectiveDate);
    }

    static final class BuilderImpl extends BcmPricingCalculatorResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String status;

        private String failureMessage;

        private BillInterval billInterval;

        private BillEstimateCostSummary costSummary;

        private Instant createdAt;

        private Instant expiresAt;

        private String groupSharingPreference;

        private String costCategoryGroupSharingPreferenceArn;

        private Instant costCategoryGroupSharingPreferenceEffectiveDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBillEstimateResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            status(model.status);
            failureMessage(model.failureMessage);
            billInterval(model.billInterval);
            costSummary(model.costSummary);
            createdAt(model.createdAt);
            expiresAt(model.expiresAt);
            groupSharingPreference(model.groupSharingPreference);
            costCategoryGroupSharingPreferenceArn(model.costCategoryGroupSharingPreferenceArn);
            costCategoryGroupSharingPreferenceEffectiveDate(model.costCategoryGroupSharingPreferenceEffectiveDate);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BillEstimateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureMessage() {
            return failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final BillInterval.Builder getBillInterval() {
            return billInterval != null ? billInterval.toBuilder() : null;
        }

        public final void setBillInterval(BillInterval.BuilderImpl billInterval) {
            this.billInterval = billInterval != null ? billInterval.build() : null;
        }

        @Override
        public final Builder billInterval(BillInterval billInterval) {
            this.billInterval = billInterval;
            return this;
        }

        public final BillEstimateCostSummary.Builder getCostSummary() {
            return costSummary != null ? costSummary.toBuilder() : null;
        }

        public final void setCostSummary(BillEstimateCostSummary.BuilderImpl costSummary) {
            this.costSummary = costSummary != null ? costSummary.build() : null;
        }

        @Override
        public final Builder costSummary(BillEstimateCostSummary costSummary) {
            this.costSummary = costSummary;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getExpiresAt() {
            return expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final String getGroupSharingPreference() {
            return groupSharingPreference;
        }

        public final void setGroupSharingPreference(String groupSharingPreference) {
            this.groupSharingPreference = groupSharingPreference;
        }

        @Override
        public final Builder groupSharingPreference(String groupSharingPreference) {
            this.groupSharingPreference = groupSharingPreference;
            return this;
        }

        @Override
        public final Builder groupSharingPreference(GroupSharingPreferenceEnum groupSharingPreference) {
            this.groupSharingPreference(groupSharingPreference == null ? null : groupSharingPreference.toString());
            return this;
        }

        public final String getCostCategoryGroupSharingPreferenceArn() {
            return costCategoryGroupSharingPreferenceArn;
        }

        public final void setCostCategoryGroupSharingPreferenceArn(String costCategoryGroupSharingPreferenceArn) {
            this.costCategoryGroupSharingPreferenceArn = costCategoryGroupSharingPreferenceArn;
        }

        @Override
        public final Builder costCategoryGroupSharingPreferenceArn(String costCategoryGroupSharingPreferenceArn) {
            this.costCategoryGroupSharingPreferenceArn = costCategoryGroupSharingPreferenceArn;
            return this;
        }

        public final Instant getCostCategoryGroupSharingPreferenceEffectiveDate() {
            return costCategoryGroupSharingPreferenceEffectiveDate;
        }

        public final void setCostCategoryGroupSharingPreferenceEffectiveDate(
                Instant costCategoryGroupSharingPreferenceEffectiveDate) {
            this.costCategoryGroupSharingPreferenceEffectiveDate = costCategoryGroupSharingPreferenceEffectiveDate;
        }

        @Override
        public final Builder costCategoryGroupSharingPreferenceEffectiveDate(
                Instant costCategoryGroupSharingPreferenceEffectiveDate) {
            this.costCategoryGroupSharingPreferenceEffectiveDate = costCategoryGroupSharingPreferenceEffectiveDate;
            return this;
        }

        @Override
        public GetBillEstimateResponse build() {
            return new GetBillEstimateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
