/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of cost-related information for a bill estimate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BillEstimateCostSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BillEstimateCostSummary.Builder, BillEstimateCostSummary> {
    private static final SdkField<CostDifference> TOTAL_COST_DIFFERENCE_FIELD = SdkField
            .<CostDifference> builder(MarshallingType.SDK_POJO).memberName("totalCostDifference")
            .getter(getter(BillEstimateCostSummary::totalCostDifference)).setter(setter(Builder::totalCostDifference))
            .constructor(CostDifference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalCostDifference").build())
            .build();

    private static final SdkField<Map<String, CostDifference>> SERVICE_COST_DIFFERENCES_FIELD = SdkField
            .<Map<String, CostDifference>> builder(MarshallingType.MAP)
            .memberName("serviceCostDifferences")
            .getter(getter(BillEstimateCostSummary::serviceCostDifferences))
            .setter(setter(Builder::serviceCostDifferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCostDifferences").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<CostDifference> builder(MarshallingType.SDK_POJO)
                                            .constructor(CostDifference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_COST_DIFFERENCE_FIELD,
            SERVICE_COST_DIFFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CostDifference totalCostDifference;

    private final Map<String, CostDifference> serviceCostDifferences;

    private BillEstimateCostSummary(BuilderImpl builder) {
        this.totalCostDifference = builder.totalCostDifference;
        this.serviceCostDifferences = builder.serviceCostDifferences;
    }

    /**
     * <p>
     * The total difference in cost between the estimated and historical costs.
     * </p>
     * 
     * @return The total difference in cost between the estimated and historical costs.
     */
    public final CostDifference totalCostDifference() {
        return totalCostDifference;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceCostDifferences property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasServiceCostDifferences() {
        return serviceCostDifferences != null && !(serviceCostDifferences instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A breakdown of cost differences by Amazon Web Services service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceCostDifferences} method.
     * </p>
     * 
     * @return A breakdown of cost differences by Amazon Web Services service.
     */
    public final Map<String, CostDifference> serviceCostDifferences() {
        return serviceCostDifferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalCostDifference());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceCostDifferences() ? serviceCostDifferences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillEstimateCostSummary)) {
            return false;
        }
        BillEstimateCostSummary other = (BillEstimateCostSummary) obj;
        return Objects.equals(totalCostDifference(), other.totalCostDifference())
                && hasServiceCostDifferences() == other.hasServiceCostDifferences()
                && Objects.equals(serviceCostDifferences(), other.serviceCostDifferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BillEstimateCostSummary").add("TotalCostDifference", totalCostDifference())
                .add("ServiceCostDifferences", hasServiceCostDifferences() ? serviceCostDifferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalCostDifference":
            return Optional.ofNullable(clazz.cast(totalCostDifference()));
        case "serviceCostDifferences":
            return Optional.ofNullable(clazz.cast(serviceCostDifferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("totalCostDifference", TOTAL_COST_DIFFERENCE_FIELD);
        map.put("serviceCostDifferences", SERVICE_COST_DIFFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillEstimateCostSummary, T> g) {
        return obj -> g.apply((BillEstimateCostSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BillEstimateCostSummary> {
        /**
         * <p>
         * The total difference in cost between the estimated and historical costs.
         * </p>
         * 
         * @param totalCostDifference
         *        The total difference in cost between the estimated and historical costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCostDifference(CostDifference totalCostDifference);

        /**
         * <p>
         * The total difference in cost between the estimated and historical costs.
         * </p>
         * This is a convenience method that creates an instance of the {@link CostDifference.Builder} avoiding the need
         * to create one manually via {@link CostDifference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CostDifference.Builder#build()} is called immediately and its
         * result is passed to {@link #totalCostDifference(CostDifference)}.
         * 
         * @param totalCostDifference
         *        a consumer that will call methods on {@link CostDifference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #totalCostDifference(CostDifference)
         */
        default Builder totalCostDifference(Consumer<CostDifference.Builder> totalCostDifference) {
            return totalCostDifference(CostDifference.builder().applyMutation(totalCostDifference).build());
        }

        /**
         * <p>
         * A breakdown of cost differences by Amazon Web Services service.
         * </p>
         * 
         * @param serviceCostDifferences
         *        A breakdown of cost differences by Amazon Web Services service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCostDifferences(Map<String, CostDifference> serviceCostDifferences);
    }

    static final class BuilderImpl implements Builder {
        private CostDifference totalCostDifference;

        private Map<String, CostDifference> serviceCostDifferences = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BillEstimateCostSummary model) {
            totalCostDifference(model.totalCostDifference);
            serviceCostDifferences(model.serviceCostDifferences);
        }

        public final CostDifference.Builder getTotalCostDifference() {
            return totalCostDifference != null ? totalCostDifference.toBuilder() : null;
        }

        public final void setTotalCostDifference(CostDifference.BuilderImpl totalCostDifference) {
            this.totalCostDifference = totalCostDifference != null ? totalCostDifference.build() : null;
        }

        @Override
        public final Builder totalCostDifference(CostDifference totalCostDifference) {
            this.totalCostDifference = totalCostDifference;
            return this;
        }

        public final Map<String, CostDifference.Builder> getServiceCostDifferences() {
            Map<String, CostDifference.Builder> result = ServiceCostDifferenceMapCopier
                    .copyToBuilder(this.serviceCostDifferences);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setServiceCostDifferences(Map<String, CostDifference.BuilderImpl> serviceCostDifferences) {
            this.serviceCostDifferences = ServiceCostDifferenceMapCopier.copyFromBuilder(serviceCostDifferences);
        }

        @Override
        public final Builder serviceCostDifferences(Map<String, CostDifference> serviceCostDifferences) {
            this.serviceCostDifferences = ServiceCostDifferenceMapCopier.copy(serviceCostDifferences);
            return this;
        }

        @Override
        public BillEstimateCostSummary build() {
            return new BillEstimateCostSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
