/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a summary of commitment-related information for a bill estimate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BillEstimateCommitmentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BillEstimateCommitmentSummary.Builder, BillEstimateCommitmentSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(BillEstimateCommitmentSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> PURCHASE_AGREEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("purchaseAgreementType").getter(getter(BillEstimateCommitmentSummary::purchaseAgreementTypeAsString))
            .setter(setter(Builder::purchaseAgreementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("purchaseAgreementType").build())
            .build();

    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("offeringId").getter(getter(BillEstimateCommitmentSummary::offeringId))
            .setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offeringId").build()).build();

    private static final SdkField<String> USAGE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("usageAccountId").getter(getter(BillEstimateCommitmentSummary::usageAccountId))
            .setter(setter(Builder::usageAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageAccountId").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(BillEstimateCommitmentSummary::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final SdkField<String> TERM_LENGTH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("termLength").getter(getter(BillEstimateCommitmentSummary::termLength))
            .setter(setter(Builder::termLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("termLength").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("paymentOption").getter(getter(BillEstimateCommitmentSummary::paymentOption))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("paymentOption").build()).build();

    private static final SdkField<CostAmount> UPFRONT_PAYMENT_FIELD = SdkField.<CostAmount> builder(MarshallingType.SDK_POJO)
            .memberName("upfrontPayment").getter(getter(BillEstimateCommitmentSummary::upfrontPayment))
            .setter(setter(Builder::upfrontPayment)).constructor(CostAmount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upfrontPayment").build()).build();

    private static final SdkField<CostAmount> MONTHLY_PAYMENT_FIELD = SdkField.<CostAmount> builder(MarshallingType.SDK_POJO)
            .memberName("monthlyPayment").getter(getter(BillEstimateCommitmentSummary::monthlyPayment))
            .setter(setter(Builder::monthlyPayment)).constructor(CostAmount::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("monthlyPayment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            PURCHASE_AGREEMENT_TYPE_FIELD, OFFERING_ID_FIELD, USAGE_ACCOUNT_ID_FIELD, REGION_FIELD, TERM_LENGTH_FIELD,
            PAYMENT_OPTION_FIELD, UPFRONT_PAYMENT_FIELD, MONTHLY_PAYMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String purchaseAgreementType;

    private final String offeringId;

    private final String usageAccountId;

    private final String region;

    private final String termLength;

    private final String paymentOption;

    private final CostAmount upfrontPayment;

    private final CostAmount monthlyPayment;

    private BillEstimateCommitmentSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.purchaseAgreementType = builder.purchaseAgreementType;
        this.offeringId = builder.offeringId;
        this.usageAccountId = builder.usageAccountId;
        this.region = builder.region;
        this.termLength = builder.termLength;
        this.paymentOption = builder.paymentOption;
        this.upfrontPayment = builder.upfrontPayment;
        this.monthlyPayment = builder.monthlyPayment;
    }

    /**
     * <p>
     * The unique identifier of the commitment.
     * </p>
     * 
     * @return The unique identifier of the commitment.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of purchase agreement (e.g., Reserved Instance, Savings Plan).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #purchaseAgreementType} will return {@link PurchaseAgreementType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #purchaseAgreementTypeAsString}.
     * </p>
     * 
     * @return The type of purchase agreement (e.g., Reserved Instance, Savings Plan).
     * @see PurchaseAgreementType
     */
    public final PurchaseAgreementType purchaseAgreementType() {
        return PurchaseAgreementType.fromValue(purchaseAgreementType);
    }

    /**
     * <p>
     * The type of purchase agreement (e.g., Reserved Instance, Savings Plan).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #purchaseAgreementType} will return {@link PurchaseAgreementType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #purchaseAgreementTypeAsString}.
     * </p>
     * 
     * @return The type of purchase agreement (e.g., Reserved Instance, Savings Plan).
     * @see PurchaseAgreementType
     */
    public final String purchaseAgreementTypeAsString() {
        return purchaseAgreementType;
    }

    /**
     * <p>
     * The identifier of the specific offering associated with this commitment.
     * </p>
     * 
     * @return The identifier of the specific offering associated with this commitment.
     */
    public final String offeringId() {
        return offeringId;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with this commitment.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with this commitment.
     */
    public final String usageAccountId() {
        return usageAccountId;
    }

    /**
     * <p>
     * The Amazon Web Services region associated with this commitment.
     * </p>
     * 
     * @return The Amazon Web Services region associated with this commitment.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The length of the commitment term.
     * </p>
     * 
     * @return The length of the commitment term.
     */
    public final String termLength() {
        return termLength;
    }

    /**
     * <p>
     * The payment option chosen for this commitment (e.g., All Upfront, Partial Upfront, No Upfront).
     * </p>
     * 
     * @return The payment option chosen for this commitment (e.g., All Upfront, Partial Upfront, No Upfront).
     */
    public final String paymentOption() {
        return paymentOption;
    }

    /**
     * <p>
     * The upfront payment amount for this commitment, if applicable.
     * </p>
     * 
     * @return The upfront payment amount for this commitment, if applicable.
     */
    public final CostAmount upfrontPayment() {
        return upfrontPayment;
    }

    /**
     * <p>
     * The monthly payment amount for this commitment, if applicable.
     * </p>
     * 
     * @return The monthly payment amount for this commitment, if applicable.
     */
    public final CostAmount monthlyPayment() {
        return monthlyPayment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(purchaseAgreementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        hashCode = 31 * hashCode + Objects.hashCode(usageAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(termLength());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOption());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontPayment());
        hashCode = 31 * hashCode + Objects.hashCode(monthlyPayment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BillEstimateCommitmentSummary)) {
            return false;
        }
        BillEstimateCommitmentSummary other = (BillEstimateCommitmentSummary) obj;
        return Objects.equals(id(), other.id())
                && Objects.equals(purchaseAgreementTypeAsString(), other.purchaseAgreementTypeAsString())
                && Objects.equals(offeringId(), other.offeringId()) && Objects.equals(usageAccountId(), other.usageAccountId())
                && Objects.equals(region(), other.region()) && Objects.equals(termLength(), other.termLength())
                && Objects.equals(paymentOption(), other.paymentOption())
                && Objects.equals(upfrontPayment(), other.upfrontPayment())
                && Objects.equals(monthlyPayment(), other.monthlyPayment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BillEstimateCommitmentSummary").add("Id", id())
                .add("PurchaseAgreementType", purchaseAgreementTypeAsString()).add("OfferingId", offeringId())
                .add("UsageAccountId", usageAccountId()).add("Region", region()).add("TermLength", termLength())
                .add("PaymentOption", paymentOption()).add("UpfrontPayment", upfrontPayment())
                .add("MonthlyPayment", monthlyPayment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "purchaseAgreementType":
            return Optional.ofNullable(clazz.cast(purchaseAgreementTypeAsString()));
        case "offeringId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        case "usageAccountId":
            return Optional.ofNullable(clazz.cast(usageAccountId()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        case "termLength":
            return Optional.ofNullable(clazz.cast(termLength()));
        case "paymentOption":
            return Optional.ofNullable(clazz.cast(paymentOption()));
        case "upfrontPayment":
            return Optional.ofNullable(clazz.cast(upfrontPayment()));
        case "monthlyPayment":
            return Optional.ofNullable(clazz.cast(monthlyPayment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("purchaseAgreementType", PURCHASE_AGREEMENT_TYPE_FIELD);
        map.put("offeringId", OFFERING_ID_FIELD);
        map.put("usageAccountId", USAGE_ACCOUNT_ID_FIELD);
        map.put("region", REGION_FIELD);
        map.put("termLength", TERM_LENGTH_FIELD);
        map.put("paymentOption", PAYMENT_OPTION_FIELD);
        map.put("upfrontPayment", UPFRONT_PAYMENT_FIELD);
        map.put("monthlyPayment", MONTHLY_PAYMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BillEstimateCommitmentSummary, T> g) {
        return obj -> g.apply((BillEstimateCommitmentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BillEstimateCommitmentSummary> {
        /**
         * <p>
         * The unique identifier of the commitment.
         * </p>
         * 
         * @param id
         *        The unique identifier of the commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of purchase agreement (e.g., Reserved Instance, Savings Plan).
         * </p>
         * 
         * @param purchaseAgreementType
         *        The type of purchase agreement (e.g., Reserved Instance, Savings Plan).
         * @see PurchaseAgreementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PurchaseAgreementType
         */
        Builder purchaseAgreementType(String purchaseAgreementType);

        /**
         * <p>
         * The type of purchase agreement (e.g., Reserved Instance, Savings Plan).
         * </p>
         * 
         * @param purchaseAgreementType
         *        The type of purchase agreement (e.g., Reserved Instance, Savings Plan).
         * @see PurchaseAgreementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PurchaseAgreementType
         */
        Builder purchaseAgreementType(PurchaseAgreementType purchaseAgreementType);

        /**
         * <p>
         * The identifier of the specific offering associated with this commitment.
         * </p>
         * 
         * @param offeringId
         *        The identifier of the specific offering associated with this commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);

        /**
         * <p>
         * The Amazon Web Services account ID associated with this commitment.
         * </p>
         * 
         * @param usageAccountId
         *        The Amazon Web Services account ID associated with this commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageAccountId(String usageAccountId);

        /**
         * <p>
         * The Amazon Web Services region associated with this commitment.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services region associated with this commitment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The length of the commitment term.
         * </p>
         * 
         * @param termLength
         *        The length of the commitment term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termLength(String termLength);

        /**
         * <p>
         * The payment option chosen for this commitment (e.g., All Upfront, Partial Upfront, No Upfront).
         * </p>
         * 
         * @param paymentOption
         *        The payment option chosen for this commitment (e.g., All Upfront, Partial Upfront, No Upfront).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The upfront payment amount for this commitment, if applicable.
         * </p>
         * 
         * @param upfrontPayment
         *        The upfront payment amount for this commitment, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontPayment(CostAmount upfrontPayment);

        /**
         * <p>
         * The upfront payment amount for this commitment, if applicable.
         * </p>
         * This is a convenience method that creates an instance of the {@link CostAmount.Builder} avoiding the need to
         * create one manually via {@link CostAmount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CostAmount.Builder#build()} is called immediately and its result
         * is passed to {@link #upfrontPayment(CostAmount)}.
         * 
         * @param upfrontPayment
         *        a consumer that will call methods on {@link CostAmount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #upfrontPayment(CostAmount)
         */
        default Builder upfrontPayment(Consumer<CostAmount.Builder> upfrontPayment) {
            return upfrontPayment(CostAmount.builder().applyMutation(upfrontPayment).build());
        }

        /**
         * <p>
         * The monthly payment amount for this commitment, if applicable.
         * </p>
         * 
         * @param monthlyPayment
         *        The monthly payment amount for this commitment, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monthlyPayment(CostAmount monthlyPayment);

        /**
         * <p>
         * The monthly payment amount for this commitment, if applicable.
         * </p>
         * This is a convenience method that creates an instance of the {@link CostAmount.Builder} avoiding the need to
         * create one manually via {@link CostAmount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CostAmount.Builder#build()} is called immediately and its result
         * is passed to {@link #monthlyPayment(CostAmount)}.
         * 
         * @param monthlyPayment
         *        a consumer that will call methods on {@link CostAmount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monthlyPayment(CostAmount)
         */
        default Builder monthlyPayment(Consumer<CostAmount.Builder> monthlyPayment) {
            return monthlyPayment(CostAmount.builder().applyMutation(monthlyPayment).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String purchaseAgreementType;

        private String offeringId;

        private String usageAccountId;

        private String region;

        private String termLength;

        private String paymentOption;

        private CostAmount upfrontPayment;

        private CostAmount monthlyPayment;

        private BuilderImpl() {
        }

        private BuilderImpl(BillEstimateCommitmentSummary model) {
            id(model.id);
            purchaseAgreementType(model.purchaseAgreementType);
            offeringId(model.offeringId);
            usageAccountId(model.usageAccountId);
            region(model.region);
            termLength(model.termLength);
            paymentOption(model.paymentOption);
            upfrontPayment(model.upfrontPayment);
            monthlyPayment(model.monthlyPayment);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getPurchaseAgreementType() {
            return purchaseAgreementType;
        }

        public final void setPurchaseAgreementType(String purchaseAgreementType) {
            this.purchaseAgreementType = purchaseAgreementType;
        }

        @Override
        public final Builder purchaseAgreementType(String purchaseAgreementType) {
            this.purchaseAgreementType = purchaseAgreementType;
            return this;
        }

        @Override
        public final Builder purchaseAgreementType(PurchaseAgreementType purchaseAgreementType) {
            this.purchaseAgreementType(purchaseAgreementType == null ? null : purchaseAgreementType.toString());
            return this;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final String getUsageAccountId() {
            return usageAccountId;
        }

        public final void setUsageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
        }

        @Override
        public final Builder usageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getTermLength() {
            return termLength;
        }

        public final void setTermLength(String termLength) {
            this.termLength = termLength;
        }

        @Override
        public final Builder termLength(String termLength) {
            this.termLength = termLength;
            return this;
        }

        public final String getPaymentOption() {
            return paymentOption;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        public final CostAmount.Builder getUpfrontPayment() {
            return upfrontPayment != null ? upfrontPayment.toBuilder() : null;
        }

        public final void setUpfrontPayment(CostAmount.BuilderImpl upfrontPayment) {
            this.upfrontPayment = upfrontPayment != null ? upfrontPayment.build() : null;
        }

        @Override
        public final Builder upfrontPayment(CostAmount upfrontPayment) {
            this.upfrontPayment = upfrontPayment;
            return this;
        }

        public final CostAmount.Builder getMonthlyPayment() {
            return monthlyPayment != null ? monthlyPayment.toBuilder() : null;
        }

        public final void setMonthlyPayment(CostAmount.BuilderImpl monthlyPayment) {
            this.monthlyPayment = monthlyPayment != null ? monthlyPayment.build() : null;
        }

        @Override
        public final Builder monthlyPayment(CostAmount monthlyPayment) {
            this.monthlyPayment = monthlyPayment;
            return this;
        }

        @Override
        public BillEstimateCommitmentSummary build() {
            return new BillEstimateCommitmentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
