/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageEntriesCopier;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchCreateWorkloadEstimateUsageEntry;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateWorkloadEstimateUsageRequest
extends BcmPricingCalculatorRequest
implements ToCopyableBuilder<Builder, BatchCreateWorkloadEstimateUsageRequest> {
    private static final SdkField<String> WORKLOAD_ESTIMATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workloadEstimateId").getter(BatchCreateWorkloadEstimateUsageRequest.getter(BatchCreateWorkloadEstimateUsageRequest::workloadEstimateId)).setter(BatchCreateWorkloadEstimateUsageRequest.setter(Builder::workloadEstimateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadEstimateId").build()}).build();
    private static final SdkField<List<BatchCreateWorkloadEstimateUsageEntry>> USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("usage").getter(BatchCreateWorkloadEstimateUsageRequest.getter(BatchCreateWorkloadEstimateUsageRequest::usage)).setter(BatchCreateWorkloadEstimateUsageRequest.setter(Builder::usage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchCreateWorkloadEstimateUsageEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(BatchCreateWorkloadEstimateUsageRequest.getter(BatchCreateWorkloadEstimateUsageRequest::clientToken)).setter(BatchCreateWorkloadEstimateUsageRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ESTIMATE_ID_FIELD, USAGE_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchCreateWorkloadEstimateUsageRequest.memberNameToFieldInitializer();
    private final String workloadEstimateId;
    private final List<BatchCreateWorkloadEstimateUsageEntry> usage;
    private final String clientToken;

    private BatchCreateWorkloadEstimateUsageRequest(BuilderImpl builder) {
        super(builder);
        this.workloadEstimateId = builder.workloadEstimateId;
        this.usage = builder.usage;
        this.clientToken = builder.clientToken;
    }

    public final String workloadEstimateId() {
        return this.workloadEstimateId;
    }

    public final boolean hasUsage() {
        return this.usage != null && !(this.usage instanceof SdkAutoConstructList);
    }

    public final List<BatchCreateWorkloadEstimateUsageEntry> usage() {
        return this.usage;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadEstimateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsage() ? this.usage() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateWorkloadEstimateUsageRequest)) {
            return false;
        }
        BatchCreateWorkloadEstimateUsageRequest other = (BatchCreateWorkloadEstimateUsageRequest)((Object)obj);
        return Objects.equals(this.workloadEstimateId(), other.workloadEstimateId()) && this.hasUsage() == other.hasUsage() && Objects.equals(this.usage(), other.usage()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateWorkloadEstimateUsageRequest").add("WorkloadEstimateId", (Object)this.workloadEstimateId()).add("Usage", this.hasUsage() ? this.usage() : null).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workloadEstimateId": {
                return Optional.ofNullable(clazz.cast(this.workloadEstimateId()));
            }
            case "usage": {
                return Optional.ofNullable(clazz.cast(this.usage()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workloadEstimateId", WORKLOAD_ESTIMATE_ID_FIELD);
        map.put("usage", USAGE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateWorkloadEstimateUsageRequest, T> g) {
        return obj -> g.apply((BatchCreateWorkloadEstimateUsageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmPricingCalculatorRequest.BuilderImpl
    implements Builder {
        private String workloadEstimateId;
        private List<BatchCreateWorkloadEstimateUsageEntry> usage = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateWorkloadEstimateUsageRequest model) {
            super(model);
            this.workloadEstimateId(model.workloadEstimateId);
            this.usage(model.usage);
            this.clientToken(model.clientToken);
        }

        public final String getWorkloadEstimateId() {
            return this.workloadEstimateId;
        }

        public final void setWorkloadEstimateId(String workloadEstimateId) {
            this.workloadEstimateId = workloadEstimateId;
        }

        @Override
        public final Builder workloadEstimateId(String workloadEstimateId) {
            this.workloadEstimateId = workloadEstimateId;
            return this;
        }

        public final List<BatchCreateWorkloadEstimateUsageEntry.Builder> getUsage() {
            List<BatchCreateWorkloadEstimateUsageEntry.Builder> result = BatchCreateWorkloadEstimateUsageEntriesCopier.copyToBuilder(this.usage);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsage(Collection<BatchCreateWorkloadEstimateUsageEntry.BuilderImpl> usage) {
            this.usage = BatchCreateWorkloadEstimateUsageEntriesCopier.copyFromBuilder(usage);
        }

        @Override
        public final Builder usage(Collection<BatchCreateWorkloadEstimateUsageEntry> usage) {
            this.usage = BatchCreateWorkloadEstimateUsageEntriesCopier.copy(usage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usage(BatchCreateWorkloadEstimateUsageEntry ... usage) {
            this.usage(Arrays.asList(usage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usage(Consumer<BatchCreateWorkloadEstimateUsageEntry.Builder> ... usage) {
            this.usage(Stream.of(usage).map(c -> (BatchCreateWorkloadEstimateUsageEntry)((BatchCreateWorkloadEstimateUsageEntry.Builder)BatchCreateWorkloadEstimateUsageEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchCreateWorkloadEstimateUsageRequest build() {
            return new BatchCreateWorkloadEstimateUsageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BcmPricingCalculatorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCreateWorkloadEstimateUsageRequest> {
        public Builder workloadEstimateId(String var1);

        public Builder usage(Collection<BatchCreateWorkloadEstimateUsageEntry> var1);

        public Builder usage(BatchCreateWorkloadEstimateUsageEntry ... var1);

        public Builder usage(Consumer<BatchCreateWorkloadEstimateUsageEntry.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

