/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ExpressionFilter;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ExpressionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Expression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Expression> {
    private static final SdkField<List<Expression>> AND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("and").getter(Expression.getter(Expression::and)).setter(Expression.setter(Builder::and)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("and").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Expression>> OR_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("or").getter(Expression.getter(Expression::or)).setter(Expression.setter(Builder::or)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("or").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Expression> NOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("not").getter(Expression.getter(Expression::not)).setter(Expression.setter(Builder::not)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("not").build()}).build();
    private static final SdkField<ExpressionFilter> COST_CATEGORIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("costCategories").getter(Expression.getter(Expression::costCategories)).setter(Expression.setter(Builder::costCategories)).constructor(ExpressionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costCategories").build()}).build();
    private static final SdkField<ExpressionFilter> DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dimensions").getter(Expression.getter(Expression::dimensions)).setter(Expression.setter(Builder::dimensions)).constructor(ExpressionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensions").build()}).build();
    private static final SdkField<ExpressionFilter> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tags").getter(Expression.getter(Expression::tags)).setter(Expression.setter(Builder::tags)).constructor(ExpressionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AND_FIELD, OR_FIELD, NOT_FIELD, COST_CATEGORIES_FIELD, DIMENSIONS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Expression.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Expression> and;
    private final List<Expression> or;
    private final Expression not;
    private final ExpressionFilter costCategories;
    private final ExpressionFilter dimensions;
    private final ExpressionFilter tags;

    private Expression(BuilderImpl builder) {
        this.and = builder.and;
        this.or = builder.or;
        this.not = builder.not;
        this.costCategories = builder.costCategories;
        this.dimensions = builder.dimensions;
        this.tags = builder.tags;
    }

    public final boolean hasAnd() {
        return this.and != null && !(this.and instanceof SdkAutoConstructList);
    }

    public final List<Expression> and() {
        return this.and;
    }

    public final boolean hasOr() {
        return this.or != null && !(this.or instanceof SdkAutoConstructList);
    }

    public final List<Expression> or() {
        return this.or;
    }

    public final Expression not() {
        return this.not;
    }

    public final ExpressionFilter costCategories() {
        return this.costCategories;
    }

    public final ExpressionFilter dimensions() {
        return this.dimensions;
    }

    public final ExpressionFilter tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnd() ? this.and() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOr() ? this.or() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.not());
        hashCode = 31 * hashCode + Objects.hashCode(this.costCategories());
        hashCode = 31 * hashCode + Objects.hashCode(this.dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Expression)) {
            return false;
        }
        Expression other = (Expression)obj;
        return this.hasAnd() == other.hasAnd() && Objects.equals(this.and(), other.and()) && this.hasOr() == other.hasOr() && Objects.equals(this.or(), other.or()) && Objects.equals(this.not(), other.not()) && Objects.equals(this.costCategories(), other.costCategories()) && Objects.equals(this.dimensions(), other.dimensions()) && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"Expression").add("And", this.hasAnd() ? this.and() : null).add("Or", this.hasOr() ? this.or() : null).add("Not", (Object)this.not()).add("CostCategories", (Object)this.costCategories()).add("Dimensions", (Object)this.dimensions()).add("Tags", (Object)this.tags()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "and": {
                return Optional.ofNullable(clazz.cast(this.and()));
            }
            case "or": {
                return Optional.ofNullable(clazz.cast(this.or()));
            }
            case "not": {
                return Optional.ofNullable(clazz.cast(this.not()));
            }
            case "costCategories": {
                return Optional.ofNullable(clazz.cast(this.costCategories()));
            }
            case "dimensions": {
                return Optional.ofNullable(clazz.cast(this.dimensions()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("and", AND_FIELD);
        map.put("or", OR_FIELD);
        map.put("not", NOT_FIELD);
        map.put("costCategories", COST_CATEGORIES_FIELD);
        map.put("dimensions", DIMENSIONS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Expression, T> g) {
        return obj -> g.apply((Expression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Expression> and = DefaultSdkAutoConstructList.getInstance();
        private List<Expression> or = DefaultSdkAutoConstructList.getInstance();
        private Expression not;
        private ExpressionFilter costCategories;
        private ExpressionFilter dimensions;
        private ExpressionFilter tags;

        private BuilderImpl() {
        }

        private BuilderImpl(Expression model) {
            this.and(model.and);
            this.or(model.or);
            this.not(model.not);
            this.costCategories(model.costCategories);
            this.dimensions(model.dimensions);
            this.tags(model.tags);
        }

        public final List<Builder> getAnd() {
            List<Builder> result = ExpressionListCopier.copyToBuilder(this.and);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAnd(Collection<BuilderImpl> and) {
            this.and = ExpressionListCopier.copyFromBuilder(and);
        }

        @Override
        public final Builder and(Collection<Expression> and) {
            this.and = ExpressionListCopier.copy(and);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Expression ... and) {
            this.and(Arrays.asList(and));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder and(Consumer<Builder> ... and) {
            this.and(Stream.of(and).map(c -> (Expression)((Builder)Expression.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getOr() {
            List<Builder> result = ExpressionListCopier.copyToBuilder(this.or);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOr(Collection<BuilderImpl> or) {
            this.or = ExpressionListCopier.copyFromBuilder(or);
        }

        @Override
        public final Builder or(Collection<Expression> or) {
            this.or = ExpressionListCopier.copy(or);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Expression ... or) {
            this.or(Arrays.asList(or));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder or(Consumer<Builder> ... or) {
            this.or(Stream.of(or).map(c -> (Expression)((Builder)Expression.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Builder getNot() {
            return this.not != null ? this.not.toBuilder() : null;
        }

        public final void setNot(BuilderImpl not) {
            this.not = not != null ? not.build() : null;
        }

        @Override
        public final Builder not(Expression not) {
            this.not = not;
            return this;
        }

        public final ExpressionFilter.Builder getCostCategories() {
            return this.costCategories != null ? this.costCategories.toBuilder() : null;
        }

        public final void setCostCategories(ExpressionFilter.BuilderImpl costCategories) {
            this.costCategories = costCategories != null ? costCategories.build() : null;
        }

        @Override
        public final Builder costCategories(ExpressionFilter costCategories) {
            this.costCategories = costCategories;
            return this;
        }

        public final ExpressionFilter.Builder getDimensions() {
            return this.dimensions != null ? this.dimensions.toBuilder() : null;
        }

        public final void setDimensions(ExpressionFilter.BuilderImpl dimensions) {
            this.dimensions = dimensions != null ? dimensions.build() : null;
        }

        @Override
        public final Builder dimensions(ExpressionFilter dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final ExpressionFilter.Builder getTags() {
            return this.tags != null ? this.tags.toBuilder() : null;
        }

        public final void setTags(ExpressionFilter.BuilderImpl tags) {
            this.tags = tags != null ? tags.build() : null;
        }

        @Override
        public final Builder tags(ExpressionFilter tags) {
            this.tags = tags;
            return this;
        }

        public Expression build() {
            return new Expression(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Expression> {
        public Builder and(Collection<Expression> var1);

        public Builder and(Expression ... var1);

        public Builder and(Consumer<Builder> ... var1);

        public Builder or(Collection<Expression> var1);

        public Builder or(Expression ... var1);

        public Builder or(Consumer<Builder> ... var1);

        public Builder not(Expression var1);

        default public Builder not(Consumer<Builder> not) {
            return this.not((Expression)((Builder)Expression.builder().applyMutation(not)).build());
        }

        public Builder costCategories(ExpressionFilter var1);

        default public Builder costCategories(Consumer<ExpressionFilter.Builder> costCategories) {
            return this.costCategories((ExpressionFilter)((ExpressionFilter.Builder)ExpressionFilter.builder().applyMutation(costCategories)).build());
        }

        public Builder dimensions(ExpressionFilter var1);

        default public Builder dimensions(Consumer<ExpressionFilter.Builder> dimensions) {
            return this.dimensions((ExpressionFilter)((ExpressionFilter.Builder)ExpressionFilter.builder().applyMutation(dimensions)).build());
        }

        public Builder tags(ExpressionFilter var1);

        default public Builder tags(Consumer<ExpressionFilter.Builder> tags) {
            return this.tags((ExpressionFilter)((ExpressionFilter.Builder)ExpressionFilter.builder().applyMutation(tags)).build());
        }
    }
}

