/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.BcmPricingCalculatorClient;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillEstimateLineItemSummary;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateLineItemsResponse;

public class ListBillEstimateLineItemsIterable
implements SdkIterable<ListBillEstimateLineItemsResponse> {
    private final BcmPricingCalculatorClient client;
    private final ListBillEstimateLineItemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBillEstimateLineItemsIterable(BcmPricingCalculatorClient client, ListBillEstimateLineItemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBillEstimateLineItemsResponseFetcher();
    }

    public Iterator<ListBillEstimateLineItemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BillEstimateLineItemSummary> items() {
        Function<ListBillEstimateLineItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBillEstimateLineItemsResponseFetcher
    implements SyncPageFetcher<ListBillEstimateLineItemsResponse> {
        private ListBillEstimateLineItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListBillEstimateLineItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBillEstimateLineItemsResponse nextPage(ListBillEstimateLineItemsResponse previousPage) {
            if (previousPage == null) {
                return ListBillEstimateLineItemsIterable.this.client.listBillEstimateLineItems(ListBillEstimateLineItemsIterable.this.firstRequest);
            }
            return ListBillEstimateLineItemsIterable.this.client.listBillEstimateLineItems((ListBillEstimateLineItemsRequest)((Object)ListBillEstimateLineItemsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

