/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateWorkloadEstimateUsageEntriesCopier;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BatchUpdateWorkloadEstimateUsageEntry;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchUpdateWorkloadEstimateUsageRequest
extends BcmPricingCalculatorRequest
implements ToCopyableBuilder<Builder, BatchUpdateWorkloadEstimateUsageRequest> {
    private static final SdkField<String> WORKLOAD_ESTIMATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workloadEstimateId").getter(BatchUpdateWorkloadEstimateUsageRequest.getter(BatchUpdateWorkloadEstimateUsageRequest::workloadEstimateId)).setter(BatchUpdateWorkloadEstimateUsageRequest.setter(Builder::workloadEstimateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadEstimateId").build()}).build();
    private static final SdkField<List<BatchUpdateWorkloadEstimateUsageEntry>> USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("usage").getter(BatchUpdateWorkloadEstimateUsageRequest.getter(BatchUpdateWorkloadEstimateUsageRequest::usage)).setter(BatchUpdateWorkloadEstimateUsageRequest.setter(Builder::usage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usage").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchUpdateWorkloadEstimateUsageEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKLOAD_ESTIMATE_ID_FIELD, USAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchUpdateWorkloadEstimateUsageRequest.memberNameToFieldInitializer();
    private final String workloadEstimateId;
    private final List<BatchUpdateWorkloadEstimateUsageEntry> usage;

    private BatchUpdateWorkloadEstimateUsageRequest(BuilderImpl builder) {
        super(builder);
        this.workloadEstimateId = builder.workloadEstimateId;
        this.usage = builder.usage;
    }

    public final String workloadEstimateId() {
        return this.workloadEstimateId;
    }

    public final boolean hasUsage() {
        return this.usage != null && !(this.usage instanceof SdkAutoConstructList);
    }

    public final List<BatchUpdateWorkloadEstimateUsageEntry> usage() {
        return this.usage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadEstimateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUsage() ? this.usage() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateWorkloadEstimateUsageRequest)) {
            return false;
        }
        BatchUpdateWorkloadEstimateUsageRequest other = (BatchUpdateWorkloadEstimateUsageRequest)((Object)obj);
        return Objects.equals(this.workloadEstimateId(), other.workloadEstimateId()) && this.hasUsage() == other.hasUsage() && Objects.equals(this.usage(), other.usage());
    }

    public final String toString() {
        return ToString.builder((String)"BatchUpdateWorkloadEstimateUsageRequest").add("WorkloadEstimateId", (Object)this.workloadEstimateId()).add("Usage", this.hasUsage() ? this.usage() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workloadEstimateId": {
                return Optional.ofNullable(clazz.cast(this.workloadEstimateId()));
            }
            case "usage": {
                return Optional.ofNullable(clazz.cast(this.usage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workloadEstimateId", WORKLOAD_ESTIMATE_ID_FIELD);
        map.put("usage", USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateWorkloadEstimateUsageRequest, T> g) {
        return obj -> g.apply((BatchUpdateWorkloadEstimateUsageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmPricingCalculatorRequest.BuilderImpl
    implements Builder {
        private String workloadEstimateId;
        private List<BatchUpdateWorkloadEstimateUsageEntry> usage = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateWorkloadEstimateUsageRequest model) {
            super(model);
            this.workloadEstimateId(model.workloadEstimateId);
            this.usage(model.usage);
        }

        public final String getWorkloadEstimateId() {
            return this.workloadEstimateId;
        }

        public final void setWorkloadEstimateId(String workloadEstimateId) {
            this.workloadEstimateId = workloadEstimateId;
        }

        @Override
        public final Builder workloadEstimateId(String workloadEstimateId) {
            this.workloadEstimateId = workloadEstimateId;
            return this;
        }

        public final List<BatchUpdateWorkloadEstimateUsageEntry.Builder> getUsage() {
            List<BatchUpdateWorkloadEstimateUsageEntry.Builder> result = BatchUpdateWorkloadEstimateUsageEntriesCopier.copyToBuilder(this.usage);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUsage(Collection<BatchUpdateWorkloadEstimateUsageEntry.BuilderImpl> usage) {
            this.usage = BatchUpdateWorkloadEstimateUsageEntriesCopier.copyFromBuilder(usage);
        }

        @Override
        public final Builder usage(Collection<BatchUpdateWorkloadEstimateUsageEntry> usage) {
            this.usage = BatchUpdateWorkloadEstimateUsageEntriesCopier.copy(usage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usage(BatchUpdateWorkloadEstimateUsageEntry ... usage) {
            this.usage(Arrays.asList(usage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usage(Consumer<BatchUpdateWorkloadEstimateUsageEntry.Builder> ... usage) {
            this.usage(Stream.of(usage).map(c -> (BatchUpdateWorkloadEstimateUsageEntry)((BatchUpdateWorkloadEstimateUsageEntry.Builder)BatchUpdateWorkloadEstimateUsageEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchUpdateWorkloadEstimateUsageRequest build() {
            return new BatchUpdateWorkloadEstimateUsageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BcmPricingCalculatorRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchUpdateWorkloadEstimateUsageRequest> {
        public Builder workloadEstimateId(String var1);

        public Builder usage(Collection<BatchUpdateWorkloadEstimateUsageEntry> var1);

        public Builder usage(BatchUpdateWorkloadEstimateUsageEntry ... var1);

        public Builder usage(Consumer<BatchUpdateWorkloadEstimateUsageEntry.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

