/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.BcmPricingCalculatorAsyncClient;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillScenarioUsageModificationItem;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillScenarioUsageModificationsResponse;

public class ListBillScenarioUsageModificationsPublisher
implements SdkPublisher<ListBillScenarioUsageModificationsResponse> {
    private final BcmPricingCalculatorAsyncClient client;
    private final ListBillScenarioUsageModificationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBillScenarioUsageModificationsPublisher(BcmPricingCalculatorAsyncClient client, ListBillScenarioUsageModificationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBillScenarioUsageModificationsPublisher(BcmPricingCalculatorAsyncClient client, ListBillScenarioUsageModificationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBillScenarioUsageModificationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBillScenarioUsageModificationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<BillScenarioUsageModificationItem> items() {
        Function<ListBillScenarioUsageModificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListBillScenarioUsageModificationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListBillScenarioUsageModificationsResponseFetcher
    implements AsyncPageFetcher<ListBillScenarioUsageModificationsResponse> {
        private ListBillScenarioUsageModificationsResponseFetcher() {
        }

        public boolean hasNextPage(ListBillScenarioUsageModificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBillScenarioUsageModificationsResponse> nextPage(ListBillScenarioUsageModificationsResponse previousPage) {
            if (previousPage == null) {
                return ListBillScenarioUsageModificationsPublisher.this.client.listBillScenarioUsageModifications(ListBillScenarioUsageModificationsPublisher.this.firstRequest);
            }
            return ListBillScenarioUsageModificationsPublisher.this.client.listBillScenarioUsageModifications((ListBillScenarioUsageModificationsRequest)((Object)ListBillScenarioUsageModificationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

