/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.BcmPricingCalculatorClient;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListWorkloadEstimatesResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.WorkloadEstimateSummary;

public class ListWorkloadEstimatesIterable
implements SdkIterable<ListWorkloadEstimatesResponse> {
    private final BcmPricingCalculatorClient client;
    private final ListWorkloadEstimatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkloadEstimatesIterable(BcmPricingCalculatorClient client, ListWorkloadEstimatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkloadEstimatesResponseFetcher();
    }

    public Iterator<ListWorkloadEstimatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkloadEstimateSummary> items() {
        Function<ListWorkloadEstimatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkloadEstimatesResponseFetcher
    implements SyncPageFetcher<ListWorkloadEstimatesResponse> {
        private ListWorkloadEstimatesResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkloadEstimatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkloadEstimatesResponse nextPage(ListWorkloadEstimatesResponse previousPage) {
            if (previousPage == null) {
                return ListWorkloadEstimatesIterable.this.client.listWorkloadEstimates(ListWorkloadEstimatesIterable.this.firstRequest);
            }
            return ListWorkloadEstimatesIterable.this.client.listWorkloadEstimates((ListWorkloadEstimatesRequest)((Object)ListWorkloadEstimatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

