/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.BcmPricingCalculatorClient;
import software.amazon.awssdk.services.bcmpricingcalculator.internal.UserAgentUtils;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillEstimateInputUsageModificationSummary;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsRequest;
import software.amazon.awssdk.services.bcmpricingcalculator.model.ListBillEstimateInputUsageModificationsResponse;

public class ListBillEstimateInputUsageModificationsIterable
implements SdkIterable<ListBillEstimateInputUsageModificationsResponse> {
    private final BcmPricingCalculatorClient client;
    private final ListBillEstimateInputUsageModificationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListBillEstimateInputUsageModificationsIterable(BcmPricingCalculatorClient client, ListBillEstimateInputUsageModificationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListBillEstimateInputUsageModificationsResponseFetcher();
    }

    public Iterator<ListBillEstimateInputUsageModificationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BillEstimateInputUsageModificationSummary> items() {
        Function<ListBillEstimateInputUsageModificationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListBillEstimateInputUsageModificationsResponseFetcher
    implements SyncPageFetcher<ListBillEstimateInputUsageModificationsResponse> {
        private ListBillEstimateInputUsageModificationsResponseFetcher() {
        }

        public boolean hasNextPage(ListBillEstimateInputUsageModificationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListBillEstimateInputUsageModificationsResponse nextPage(ListBillEstimateInputUsageModificationsResponse previousPage) {
            if (previousPage == null) {
                return ListBillEstimateInputUsageModificationsIterable.this.client.listBillEstimateInputUsageModifications(ListBillEstimateInputUsageModificationsIterable.this.firstRequest);
            }
            return ListBillEstimateInputUsageModificationsIterable.this.client.listBillEstimateInputUsageModifications((ListBillEstimateInputUsageModificationsRequest)((Object)ListBillEstimateInputUsageModificationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

